// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/cg_method_invocation.h,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//



#ifndef _CG_METHOD_INVOCATION_H_
#define _CG_METHOD_INVOCATION_H_

#include "jit.h"
#include "data_emitter.h"

extern int gen_invokevirtual(Mem_Manager& mem_manager,
							  Code_Emitter& emitter,
							  Stack& stack,
							  Pre_Alloc_Operand_Pool& op_pool,
							  Frame& frame,
							  Class_Handle class_handle,
                              Compile_Handle comp_handle,
							  unsigned index,
							  Jit_Method_Info *method_info);

extern int gen_invokestatic(Mem_Manager& mem_manager,
							  Code_Emitter& emitter,
							  Stack& stack,
							  Pre_Alloc_Operand_Pool& op_pool,
							  Frame& frame,
							  Class_Handle class_handle,
                              Compile_Handle comp_handle,
							  unsigned index,
							  Jit_Method_Info *method_info);

extern int gen_invokespecial(Mem_Manager& mem_manager,
							  Code_Emitter& emitter,
							  Stack& stack,
							  Pre_Alloc_Operand_Pool& op_pool,
							  Frame& frame,
							  Class_Handle class_handle,
                              Compile_Handle comp_handle,
							  unsigned index,
							  Jit_Method_Info *method_info);

extern int gen_invokeinterface(Mem_Manager& mem_manager,
        					    Code_Emitter& emitter,
        					    Stack& stack,
        					    Pre_Alloc_Operand_Pool& op_pool,
        					    Frame& frame,
        					    Class_Handle class_handle,
                              Compile_Handle comp_handle,
        					    unsigned index,
                                Jit_Method_Info *method_info,
                                unsigned n_args,
								Data_Emitter& data_emitter,
                                Code_Patch *& code_patch_list);

#endif // _CG_METHOD_INVOCATION_H_
