// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/o1_debugging_support.h,v 1.2 2001/08/13 10:00:42 xhshi Exp $
//


#ifndef _O1_DEBUGGING_SUPPORT_H_
#define _O1_DEBUGGING_SUPPORT_H_

#include "jvmdi_clean.h"

#define DBG_LOC_UNKNOWN -1

class Dbg
{
public:
    Dbg() : _bc_location((unsigned)DBG_LOC_UNKNOWN), _offset((unsigned)DBG_LOC_UNKNOWN) {}
    void     set_bc_location(unsigned loc) {_bc_location = loc;}
    unsigned get_bc_location()             {return _bc_location;}
    void     set_code_offset(int off)      {_offset = off;}
    unsigned get_code_offset()             {return _offset;}
private:
    unsigned _bc_location;
    unsigned _offset;
};

//
// forward declaration
//
class  Mem_Manager;
class  Code_Emitter;
class  Stack;
class  Code_Patch;
struct Jit_Method_Info;
void gen_jvmdi_event_method(Mem_Manager&     mem,
                            Code_Emitter&    emitter,
                            Stack&           stack,
                            Code_Patch*&     code_patch_list,
                            Jit_Method_Info *method_info,
                            bool             is_entry);

#endif // _O1_DEBUGGING_SUPPORT_H_
