// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/vtune.h,v 1.3 2001/11/21 08:33:45 zying1 Exp $
//



#ifndef _VTUNE_H_
#define _VTUNE_H_

#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <assert.h>
#include <stdarg.h>
#include <string.h>

#ifdef __cplusplus
extern "C"{
#endif 

#ifndef _TEST_java_sourcefile
#include "ijitprof.h"
#else // _TEST_java_sourcefile
typedef int iJIT_ModeFlags;
#endif // _TEST_java_sourcefile
////////////////////////////////////////////////////////////////////////////
// data
////////////////////////////////////////////////////////////////////////////
extern iJIT_ModeFlags VTuneModeFlags;
////////////////////////////////////////////////////////////////////////////
// functions
////////////////////////////////////////////////////////////////////////////
struct lineInfo_t;

void set_VTuneModeFlags(iJIT_ModeFlags flags);
void pError(char *fmt, ...);
void settle_classpath();
char *sprint_cp_Utf8(char *buf, int sizeof_buf, char *utf8);
char *java_sourcefile(char *filename_buf, int sizeof_filename_buf,
                    char *java_classfile,
                    char *method_name=NULL, size_t code_len=NULL,
                    int *lineNo=NULL, lineInfo_t **lineInfo=NULL);
////////////////////////////////////////////////////////////////////////////
// type and class
////////////////////////////////////////////////////////////////////////////
typedef unsigned char  u1;
typedef unsigned short u2;
typedef unsigned int   u4;

struct lineInfo_t {         // don't add extra field to this struct!!!
    u2 start_pc;
    u2 line_number;
};

struct codeException_t {    // don't add extra field to this struct!!!
    u2 start_pc;
    u2 end_pc;
    u2 handler_pc;
    u2 catch_type;
};

struct file_t {
    int fh;
    int siz;
    file_t() : fh(-1), siz(-1) {}
    bool openfile(char *filename) {
        fh = -1;
        siz = -1;
        fh = open(filename,_O_BINARY | _O_RDONLY);
        if (fh<0)
            return false;
        struct _stat st;
        _fstat(fh,&st);
        siz = st.st_size;
        return true;
    }
    ~file_t() { if (fh!=-1) close(fh); }

    void rewind() {
        int ret = lseek(fh,0,SEEK_SET);
        if (ret==-1)
            pError("*** file_t::rewind: can't rewind classfile\n");
    }
    u1 read_u1(int *p_fpos) {
        *p_fpos += 1;
        u1 buf[1];
        int ret = _read(fh,buf,1);
        if (ret==-1)
            pError("*** file_t::read_u1: can't read 1-byte from classfile\n");
        return *(u1*)buf;
    }
    u2 read_u2(int *p_fpos) {
        *p_fpos += 2;
        u1 buf[2];
        int ret = _read(fh,buf,2);
        if (ret==-1)
            pError("*** file_t::read_u2: can't read 2-byte from classfile\n");
        return ((u2)buf[0]<<8) + (u2)buf[1];
    }
    u4 read_u4(int *p_fpos) {
        *p_fpos += 4;
        u1 buf[4];
        int ret = _read(fh,buf,4);
        if (ret==-1)
            pError("*** file_t::read_u4: can't read 4-byte from classfile\n");
        return ((u4)buf[0]<<24) + ((u4)buf[1]<<16) +
               ((u4)buf[2]<<8) + ((u4)buf[3]);
    }
    void read(char *buf, int n_bytes, int *p_fpos) {
        *p_fpos += n_bytes;
        int ret = _read(fh,buf,n_bytes);
        if (ret==-1)
            pError("*** file_t::read: can't read %d byte(s) from classfile\n",n_bytes);
    }
    void skip(int n_bytes, int *p_fpos) {
        int ret = lseek(fh,n_bytes,SEEK_CUR);
        if (ret==-1)
            pError("*** file_t::skip: can't skip %d byte(s) from classfile\n",n_bytes);
        *p_fpos += n_bytes;
    }
    int size() { return siz; }
};
#ifdef __cplusplus
}
#endif

#endif // _VTUNE_H_
