// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/cg_prepass.h,v 1.2 2001/08/13 09:54:55 xhshi Exp $
//



#ifndef _CG_PREPASS_H_
#define _CG_PREPASS_H_

#include "Mem_Manager.h"
#include "jit_intf.h"

class Cfg_Node;
class Return_Address_Tracking;

struct Bytecode_Info {
    unsigned is_block_entry:1;          // is start of bb
    unsigned is_visited:1;              // whether it's been visited in prepass
    unsigned fgnode_inited:1;           // whether fgnode has been initialized by Flow_Graph
    Cfg_Node *fgnode;                   // NULL until processed by Flow_Graph
    Cfg_Node *subr_ret;
    Return_Address_Tracking *stk;
};


class CG_Prepass {
public:
    CG_Prepass(Compile_Handle comp_handle,
        Class_Handle class_handle, Method_Handle method_handle,
        Mem_Manager&,
        const unsigned char *first_bc,unsigned code_length,
        unsigned maxStk, unsigned maxLocals);
    
    //
    // public data members
    //
    Class_Handle const class_handle;
    const unsigned char *const first_bc;
    const unsigned code_length;
    JIT_Result result;
    
    Bytecode_Info *bytecode_info; // used to be private
    unsigned num_jsr;
    bool has_fp;
private:
    void find_labels(Compile_Handle comp_handle,
        const unsigned char *bc, unsigned idx);
    Mem_Manager &_mm;
};

extern unsigned num_words_of_type(Java_Type type);

#endif // _CG_PREPASS_H_
