// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//

// forward declaration
class Cfg_Node;
class Inst;
class Operand;
class Call_Inst;

#define MAX_LAZY_ARGS  4 // the max number of args of the constructor
#define MAX_LAZY_DEPTH 8 // the max stack depth of the constructor

class Lazy_Throw : public Closure {
    bool           null_check[MAX_LAZY_ARGS];  // for null pointer
    Method_Handle  vrtl_check[MAX_LAZY_ARGS];  // for invokevirtual
    Flow_Graph     *fg;
    Compile_Handle comp_handle;  
    Expressions&   exprs;
    Mem_Manager&   mem;

    void init_check()
    {
        for (int i = 0; i < MAX_LAZY_ARGS; i++)
        {
            null_check[i] = false;
            vrtl_check[i] = NULL;
        }
    }
    Inst*        find_obj_new(Inst *head, Inst *obj);
    bool         is_excp_obj(Operand *src, Operand *obj);
    bool         bc_method_has_side_effects(Method_Handle mh, unsigned *arg_map);
    bool         method_has_side_effects(Call_Inst *cinst, Operand *obj);
    Class_Handle throwable_class(Call_Inst *new_call);
    void         gen_lazy_excp_call(Cfg_Node     *node,
                                    Cfg_Node     *lnode,
                                    Cfg_Node     *anode,
                                    Call_Inst    *new_inst, // new() 
                                    Call_Inst    *constructor, 
                                    Call_Inst    *athrow,   // athrow()
                                    Class_Handle exc_ch);
    Cfg_Node *   create_new_node(Cfg_Node   *anode,
                                 Cfg_Node   *inode);
    void         replace_athrow(Cfg_Node     *node,
                                Call_Inst    *new_inst,
                                Call_Inst    *constructor,
                                Call_Inst    *athrow,
                                Class_Handle exc_ch);
    void         remove_athrow(Cfg_Node     *node,
                               Call_Inst    *new_inst,
                               Call_Inst    *constructor,
                               Call_Inst    *athrow,
                               Class_Handle exc_ch);
public:
    Lazy_Throw(Flow_Graph     *f, 
               Mem_Manager&   m, 
               Expressions&   e, 
               Compile_Handle comp_h) 
               : fg(f), comp_handle(comp_h), mem(m), exprs(e) {init_check();}
    void eliminate_athrow(Cfg_Node *node);
};

class Lazy_Stack {
    unsigned entries[MAX_LAZY_DEPTH];
    unsigned top;
public:
    Lazy_Stack() 
    {
        top = 0;
        for (int i = 0; i < MAX_LAZY_DEPTH; i++)
            entries[i] = 0;
    }
    void push(unsigned bc_off) 
    {
        assert(top < MAX_LAZY_DEPTH); 
        entries[top++] = bc_off;
    }
    unsigned pop()
    {
        assert(top > 0);
        return entries[--top];
    }
};