// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/overridden.h,v 1.2 2001/08/13 09:52:49 xhshi Exp $
//

#ifndef _OVERRIDDEN_H_
#define _OVERRIDDEN_H_

#define MAX_OVERRIDDEN_CODE_SIZE 7

struct or_entry {
    Method_Handle m_handle;
    unsigned      code_offset;
    char          code_length;
    char          orig_code[MAX_OVERRIDDEN_CODE_SIZE];
};

/*
 *      +----------------+
 *      |     n_entry    |
 *      +----------------+
 *      |    or_entry    |  0
 *      +----------------+
 *      |     ...        |
 *      +----------------+
 *      |    or_entry    |  n_entry - 1
 *      +----------------+
 */
typedef struct {
    unsigned n_entry;
    or_entry entries[1];
} Overridden_Rec;

extern Overridden_Rec *create_overridden_rec(Code_Patch     *code_patch,
                                             char           *code_buffer,
                                             Method_Handle  mh,
                                             Compile_Handle cmpl);
extern void recover_overridden(Method_Handle caller,
                               Method_Handle callee); //method that is overridden

#endif //_OVERRIDDEN_H_
