// Copyright (C)  2000-2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/gnu_specific.cpp,v 1.18 2002/01/17 05:00:42 xli18 Exp $
//


#include "platform.h"
#include <assert.h>
#include <iostream.h>

#include "environment.h"
#include "object_layout.h"
#include "Class.h"
#include "orp_utils.h"
#include "orp_threads.h"
#include "java_lang_Thread.h"
#include "thread_dot_data.h"

#ifndef OBJECT_LOCK_V2
#include "thread_generic.h"
#include "find_natives.h"
#else
#include "thread_generic_olv2.h"
#include "find_natives_olv2.h"
#endif

#include "ini.h"
#include "exceptions.h"
#include "gnu_specific.h"



unsigned sizeof_java_lang_class()
{
    return sizeof(void *);
} //sizeof_java_lang_class



long is_this_a_daemon_thread(void *p_ref)
{
    Classpath_Java_java_lang_Thread *p_jlt = (Classpath_Java_java_lang_Thread *)p_ref;
    return p_jlt->daemon;
}


int32 is_thread_private_data_field_in_use(volatile Java_java_lang_Object *p_this_volatile)
{
    Classpath_Java_java_lang_Thread *p_jlt = (Classpath_Java_java_lang_Thread *)p_this_volatile;
    return (int32)(p_jlt->data);
}


void set_thread_priority(ORP_thread *p_orp_thread, 
                         volatile Java_java_lang_Object *p_this_volatile)
{
#ifdef ORP_NT
    Classpath_Java_java_lang_Thread *p_jlt = (Classpath_Java_java_lang_Thread *)p_this_volatile;

    int status;
    status = SetThreadPriority(p_orp_thread->thread_handle,
		                        THREAD_PRIORITY_NORMAL + p_jlt->priority - 5);
	if (status == 0)
    {
        DWORD error = GetLastError();
    }

    status = RESUME_THREAD(p_orp_thread);
    assert(status == 0);
#else
    // Not implemented
#endif // ORP_NT 
}


void set_java_thread_private_data_field(volatile Java_java_lang_Object *p_this_volatile, 
                                          ORP_thread *p_orp_thread)
{
    Classpath_Java_java_lang_Thread *p_jlt = (Classpath_Java_java_lang_Thread *)p_this_volatile;
    assert(p_jlt->data == 0);

    assert(p_TLS_orpthread->gc_enabled_status == disabled);

#ifdef OLD_VERSION_CLASSPATH
    GC_Frame gcf1;
    orp_push_gc_frame(&gcf1, (void *)&p_this_volatile, sizeof(void *) );

    extern Class *thread_helper;
    volatile Hjava_lang_thread_dot_data *p_obj_volatile;
    p_obj_volatile = (Hjava_lang_thread_dot_data *)class_alloc_new_object(thread_helper);

    orp_pop_gc_frame(&gcf1);  

    p_obj_volatile->p_thr = p_orp_thread;
    p_jlt->data = (Java_java_lang_Object *)p_obj_volatile;
#else //new classpath
//  After change "data" field to long, it's unnecessary for 
//  Hjava_lang_thread_dot_data
    p_jlt->data = (long)p_orp_thread;
#endif

}


ORP_thread *get_orp_thread_ptr(void *p_ref)
{
#ifdef ORP_POSIX
    ORP_thread *p_orpthread = (ORP_thread *) pthread_getspecific(thread_local_storage_key);
    assert(  p_orpthread == NULL || ( p_orpthread->gc_enabled_status == disabled) );
#else
    assert( (p_TLS_orpthread == 0) || (p_TLS_orpthread->gc_enabled_status == disabled) );
#endif

    Classpath_Java_java_lang_Thread *p_jlt = (Classpath_Java_java_lang_Thread *)p_ref;

#ifdef OLD_VERSION_CLASSPATH
    Hjava_lang_thread_dot_data *p_obj = (Hjava_lang_thread_dot_data *)p_jlt->data;
    ORP_thread *p_thr = (ORP_thread *)p_obj->p_thr;
#else //new classpath
// After change "data" field to long, it's unnecessary for 
// Hjava_lang_thread_dot_data
    ORP_thread *p_thr = (ORP_thread *)p_jlt->data;
#endif
    return p_thr;
}


void set_interrupt_flag_in_thread_object(volatile Java_java_lang_Object *p_java_thr_volatile)
{
  // toss for gnu  Java_java_lang_Thread *p_jlt = (Java_java_lang_Thread *)p_java_thr_volatile;
  // toss for gnu  p_jlt->interrupt_flag = 0xff;
}


void set_alive_flag_in_thread_object(volatile Java_java_lang_Object *p_java_thr_volatile)
{
//    Java_java_lang_Thread *p_jlt = (Java_java_lang_Thread *)p_java_thr_volatile;
//    p_jlt->alive_flag = 0xff;
}


void reset_alive_flag_in_thread_object(volatile Java_java_lang_Object *p_java_thr_volatile)
{
//    Java_java_lang_Thread *p_jlt = (Java_java_lang_Thread *)p_java_thr_volatile;
//    p_jlt->alive_flag = 0;
}




///////////////////////////////////////////////////////////////////
// begin java.lang.String field access




void set_java_lang_string_fields(Java_java_lang_String *str,
                                 JavaArrayOfChar       *value,
                                 int32                  offset,
                                 int32                  count)
{
    assert(!orp_is_gc_enabled(p_TLS_orpthread));
    assert(str);
    Classpath_Java_java_lang_String *classpath_str = (Classpath_Java_java_lang_String *)str;
    gc_heap_slot_write_ref(str, (Java_java_lang_Object **)&(classpath_str->value), (Java_java_lang_Object *)value);
    gc_heap_slot_write_int32(str, &classpath_str->offset, offset);
    gc_heap_slot_write_int32(str, &classpath_str->count, count);
} //set_java_lang_string_fields



void get_java_lang_string_fields(Java_java_lang_String  *str,
                                 JavaArrayOfChar       **value,
                                 int32                  *offset,
                                 int32                  *count)
{
    assert(!orp_is_gc_enabled(p_TLS_orpthread));
    assert(str);
    Classpath_Java_java_lang_String *classpath_str = (Classpath_Java_java_lang_String *)str;
    if(value) {
        *value = classpath_str->value;
    }
    if(offset) {
        *offset = classpath_str->offset;
    }
    if(count) {
        *count = classpath_str->count;
    }
} //get_java_lang_string_fields



JavaArrayOfChar *get_java_lang_string_field_value(Java_java_lang_String *str)
{
    assert(!orp_is_gc_enabled(p_TLS_orpthread));
    assert(str);
    Classpath_Java_java_lang_String *classpath_str = (Classpath_Java_java_lang_String *)str;
    return classpath_str->value;
} //get_java_lang_string_field_value



int32 get_java_lang_string_field_offset(Java_java_lang_String *str)
{
    assert(!orp_is_gc_enabled(p_TLS_orpthread));
    assert(str);
    Classpath_Java_java_lang_String *classpath_str = (Classpath_Java_java_lang_String *)str;
    return classpath_str->offset;
} //get_java_lang_string_field_offset



int32 get_java_lang_string_field_count(Java_java_lang_String *str)
{
    assert(!orp_is_gc_enabled(p_TLS_orpthread));
    assert(str);
    Classpath_Java_java_lang_String *classpath_str = (Classpath_Java_java_lang_String *)str;
    return classpath_str->count;
} //get_java_lang_string_field_count


// end java.lang.String field access
///////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////
// begin java.lang.Throwable field access


typedef struct Classpath_Java_java_lang_Throwable {
    VTable                *vt;

#ifndef OLD_OBJ_LAYOUT
    POINTER_SIZE_INT obj_info;
#endif
    Java_java_lang_Object *trace;
    Java_java_lang_String *message;
} Classpath_Java_java_lang_Throwable;



void set_java_lang_throwable_field_trace(Java_java_lang_Throwable *thr, Java_java_lang_Object *trace)
{
    assert(0);  // not tested yet
    assert(!orp_is_gc_enabled(p_TLS_orpthread));
    assert(thr);
    Classpath_Java_java_lang_Throwable *classpath_thr = (Classpath_Java_java_lang_Throwable *)thr;
    gc_heap_slot_write_ref(thr, (Java_java_lang_Object **)&(classpath_thr->trace), (Java_java_lang_Object *)trace);
} //get_java_lang_throwable_field_trace



Java_java_lang_Object *get_java_lang_throwable_field_trace(Java_java_lang_Throwable *thr)
{
    assert(0);  // not tested yet
    assert(!orp_is_gc_enabled(p_TLS_orpthread));
    assert(thr);
    Classpath_Java_java_lang_Throwable *classpath_thr = (Classpath_Java_java_lang_Throwable *)thr;
    return classpath_thr->trace;
} //get_java_lang_throwable_field_trace



Java_java_lang_String *get_java_lang_throwable_field_message(Java_java_lang_Throwable *thr)
{
    assert(!orp_is_gc_enabled(p_TLS_orpthread));
    assert(thr);
    Classpath_Java_java_lang_Throwable *classpath_thr = (Classpath_Java_java_lang_Throwable *)thr;
    return classpath_thr->message;
} //get_java_lang_throwable_field_message



void print_stack_trace(FILE *f, Java_java_lang_Throwable *exc)
{
     Global_Env *env = ORP_Global_State::loader_env;    
     String *name  = env->string_pool.lookup("printStackTrace");
     String *descr = env->string_pool.lookup("()V");
     Signature *sig = env->sig_table.lookup(name, descr);
     Method *method = class_lookup_method_recursive(exc->vt->clss, sig);
     J_Value args[1];
     args[0].r = (void *)exc;
     Class *clss = 0;
     set_current_thread_exception(0);
     orp_execute_java_method_array(method, &clss, args);
} //print_stack_trace


// end java.lang.Throwable field access
///////////////////////////////////////////////////////////////////



static const char *methods_with_native_impl[] =
{

#ifndef OLD_VERSION_CLASSPATH
//GNU Classpath has loadLibrary, we keep it here for correctness,
//because GNU Classpath implement a loadLibrary which requires 
//libpath.length != 0; but it's ok in reality without libpath, for
//system can lookup needed libs in default pathes.

	"java/lang/Runtime.loadLibrary(Ljava/lang/String;)V",
#endif

#ifndef NON_ORP_NATIVE_LIBS

//GNU Classpath has newInstance, we keep it here for correctness
//see function getConstructor0 in java_lang_Class.cpp for detail

    "java/lang/Class.newInstance()Ljava/lang/Object;",

//GNU Classpath has intern, we keep it here for efficiency
	"java/lang/String.intern()Ljava/lang/String;",

//GNU Classpath has join, we keep it here for efficiency
	"java/lang/Thread.join(JI)V",

#ifdef OLD_VERSION_CLASSPATH
    "gnu/vm/stack/StackTrace.copyCurrentStackTrace()Lgnu/vm/stack/StackTrace;",
#endif

#endif //NON_ORP_NATIVE_LIBS

}; //methods_with_native_impl

static int num_methods_with_native_impl = sizeof(methods_with_native_impl) / sizeof(methods_with_native_impl[0]);


Boolean use_native_implementation(Method *method)
{
    //return FALSE;
    const char *cname = method->get_class()->name->bytes;
    const char *mname = method->get_name()->bytes;
    const char *descr = method->get_descriptor();
    int len = strlen(cname) + strlen(mname) + strlen(descr) + 10;
    char *name = (char *)malloc(len);
    sprintf(name, "%s.%s%s", cname, mname, descr);
    for(int i = 0; i < num_methods_with_native_impl; i++) {
        if(!strcmp(name, methods_with_native_impl[i])) {
            return TRUE;
        }
    }
    return FALSE;
} //use_native_implementation

