// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/include/gnu_classpath_jni_utils.h,v 1.2 2002/01/09 03:31:41 gwu2 Exp $
//
#include "jni_direct.h"

void throw_exception_from_jni(JNIEnv *jenv, const char *exc, const char *msg);

inline void get_string_specifics(JNIEnv *jenv, jstring jstr, jint *count, jint *offset, jcharArray *array)
{
	assert(count);
	assert(offset);
	assert(array);

	static jfieldID count_id = NULL;
	static jfieldID data_id = NULL;
	static jfieldID offset_id = NULL;

	if(!offset_id){
		jclass jls = FindClass(jenv, "java/lang/String");
		count_id = GetFieldID(jenv, jls, "count", "I");
		data_id = GetFieldID(jenv, jls, "value", "[C");
		offset_id = GetFieldID(jenv, jls, "offset", "I");
	}

	*count = GetIntField(jenv, jstr, count_id);
    *array = GetObjectField(jenv, jstr, data_id);
	*offset = GetIntField(jenv, jstr, offset_id);
 } 
