// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_lang_Double.cpp,v 1.13 2002/01/09 03:45:03 gwu2 Exp $
//


#include "platform.h"
#include "jni.h"
#include "assert.h"
#include <math.h>
#include <stdlib.h>
#include <string.h>

#include "java_lang_Double.h"

#include "include/gnu_classpath_jni_utils.h"
/*
 * Class:     java_lang_Double
 * Method:    doubleValueOf
 * Signature: (Ljava/lang/String;)D
 */
JNIEXPORT jdouble JNICALL Java_java_lang_Double_parseDouble
  (JNIEnv *env, jclass clazz, jstring str)
{
	jint count;
    jcharArray char_array;
	jint offset;
	get_string_specifics(env, str, &count, &offset, &char_array);

	unsigned strLength = (unsigned)count;
    unsigned i = 0;

	bool error = false;
    bool minus = false;
    bool digitsPresent = false;
    bool afterDecimalPoint = false;
	
	bool afterExponent = false;
	long exponent = 0;
	bool expminus = false;

    double val = 0; // The value to be returned.
    
	double fract = 0.1;
    
    jboolean isCopy;
    jchar *jchar_array = env->GetCharArrayElements(char_array, &isCopy);
	jchar_array += offset; //skip the offset

    char ch = (char)jchar_array[0];
    if(ch == '-' || ch == '+') {
        minus = ch == '-';
        i++;
    }

    for(; i < strLength; i++) {
        int ch = (int)jchar_array[i];
        if(ch == '.') {
            if(afterDecimalPoint || !digitsPresent) {
                assert(0);
            }
            afterDecimalPoint = true;
            continue;
        }
        if(ch >= '0' && ch <= '9') {
			ch -= '0';
			if(afterExponent){
				exponent = 10 * exponent + ch;
				continue;
			}
            if(afterDecimalPoint) {
                val = val + fract * ch;
                fract *= 0.1;
            } else {
                val = 10 * val + ch;
                digitsPresent = true;
            }
        } else {
			switch(ch){
			case 'e':
			case 'E':
				afterExponent = true;
				break;
			case 'f':
			case 'F':
			case 'd':
			case 'D':
				break;
			case '+':
				break;
			case '-':
				if(!afterExponent || 
					(jchar_array[i-1] != 'e' && jchar_array[i-1] != 'E') ){
					error = true;
					break;
				}
				expminus = true;
				break;
			default:
				error = true;
			}
			if (error)
				break;
		}
    }
    if(!digitsPresent) {
        error = true;
    }
    if(minus) {
        val *= -1;
    }
	if(expminus)
		exponent = -exponent;
	if(exponent != 0){
		val *= pow(10, exponent);
	}

    env->ReleaseCharArrayElements(char_array, jchar_array, JNI_ABORT);

    if(error) {
        jclass clazz = env->FindClass("java/lang/NumberFormatException");
        jint ok = env->ThrowNew(clazz, "from Java_java_lang_Double_doubleValueOf");
        return 0;
    }
    return val;
}


union my_union
{
	jdouble d;
	jlong l;
};


/*
 * Class:     java_lang_Double
 * Method:    doubleToLongBits
 * Signature: (D)J
 */

JNIEXPORT jlong JNICALL Java_java_lang_Double_doubleToLongBits
  (JNIEnv *jenv, jclass clazz, jdouble double_value)
{

	// The result is a representation of the floating-point argument 
	// according to the IEEE 754-floating-point "double-format" bit layout:
	
	// Bit 63 represents the sign of the floating point number.
	// Bits 62-52 represent the exponent.
	// Bits 51-0 the significand (or the mantissa)

	// If the argument is positive Infinity, the result will be 0x7ff0000000000000L.
	// If the argument is negative infinity, the result will be 0xfff0000000000000L.
	// If the argument is NaN, the result will be 0x7ff8000000000000L.

	union my_union u;
	u.d = double_value;

	jlong e = u.l & __INT64_C(0x7ff0000000000000);
	jlong f = u.l & __INT64_C(0x000fffffffffffff);

	if ((e == __INT64_C(0x7ff0000000000000)) && (f != 0L))
		u.l = __INT64_C(0x7ff8000000000000);

	return u.l;
}




// Helper function for function "toString"

static inline jstring ReturnString(JNIEnv *jenv, const char *str, jobject ref)
{
	jstring ret_string = jenv->NewStringUTF(str);
	assert(ret_string);
	return ret_string;
}

inline jlong castDoubleToLong(jdouble d)
{
	union {
		jlong l;
		jdouble d;
	} U;
	U.d = d;
	return U.l;
} // castDoubleToLong

/*
 * Class:     java_lang_Double
 * Method:    toString
 * Signature: (DZ)Ljava/lang/String;
 */


#ifdef OLD_VERSION_CLASSPATH
JNIEXPORT jstring JNICALL Java_java_lang_Double_toString
  (JNIEnv *jenv, jclass clazz, jdouble double_value)
#else
// new classpath add param of "isFloat", but currently not use it
JNIEXPORT jstring JNICALL Java_java_lang_Double_toString
  (JNIEnv *jenv, jclass clazz, jdouble double_value, jboolean isFloat)
#endif

{
	jclass double_class = jenv->FindClass("java/lang/Double");
	assert(double_class);
	
	jmethodID meth_id = jenv->GetStaticMethodID(double_class, "isNaN", "(D)Z");
	assert(meth_id);

    //Use jvalue array to pass parameters is wrong
	//jvalue jarg[1];
	//jarg[0].d = double_value;
	//jboolean is_nan = jenv->CallStaticBooleanMethod(double_class, meth_id, jarg);
	jboolean is_nan = jenv->CallStaticBooleanMethod(double_class, meth_id, double_value);

	if (is_nan) {
		// Return NaN
		return ReturnString(jenv, "NaN", double_class);
	}

	jfieldID POSITIVE_INFINITY_id = 
				jenv->GetStaticFieldID(double_class, "POSITIVE_INFINITY", "D");
	jdouble POSITIVE_INFINITY = 
				jenv->GetStaticDoubleField(double_class, POSITIVE_INFINITY_id);

	if (double_value == POSITIVE_INFINITY)  {
		// Return POSITIVE_INFINITY
		return ReturnString(jenv, "Infinity", double_class);
	}

	jfieldID NEGATIVE_INFINITY_id = 
				jenv->GetStaticFieldID(double_class, "NEGATIVE_INFINITY", "D");
	jdouble NEGATIVE_INFINITY = 
				jenv->GetStaticDoubleField(double_class, NEGATIVE_INFINITY_id);

	if (double_value == NEGATIVE_INFINITY)  {
		// Return POSITIVE_INFINITY
		return ReturnString(jenv, "-Infinity", double_class);
	}

	bool negzero = false;
	if (double_value == 0){
		jlong bits = castDoubleToLong(double_value);
		if(bits & __UINT64_C(0x8000000000000000) )
			negzero = true;
	}
	char return_val[75];
	if(negzero)
		strcpy(return_val, "-0.0");
	else{
		sprintf(return_val, "%.20g", double_value);
		// add a tail '0' if no '.' presents
		if(!strchr(return_val, '.'))
			strcat(return_val, ".0");
	}
	return ReturnString(jenv, return_val, double_class);
	assert(0);

/*******************************
// The following sequence is used before

	int decimal, sign;
	// Use VC++ function _ecvt to convert...use 20 for digits parameter.
#ifdef ORP_NT
	char *buffer = _ecvt(double_value, 20, &decimal, &sign );
#elif defined(__linux__)
	char *buffer = ecvt(double_value, 20, &decimal, &sign );
#else
#error
-- ecvt() is not implemented in this platform, try sprintf() please
#endif
	// Get the absolute value.
	double_value = fabs (double_value);

	char *x = buffer;
	char *y = return_val;

	// Copy in the sign of the number to the return string.
	if (sign)
		*y++ = '-';

	// If double_value is zero, it is represented as "0.0" or "-0.0" depending
	// on the sign of the input number.

	// If the magnitude is >= 10^-3 or less than 10^7, then it is represented 
	// as the integer part of double_value, in decimal form with no leading 
	// zeroes, followed by '.', followed by one or more decimal digits 
	// representing the fractional part of double_value.

	if ((double_value >= 1e-3) && (double_value < 1e7) || (double_value == 0)) {
	
		if (decimal <= 0)
			// A 0 or negative integer value for decimal indicates that the decimal 
			// point lies to the left of the first digit. 
			*y++ = '0';
		else {
			// positive value for decimal...
			for (int j = 0; j < decimal; j++) {
				// Copy all the digits till the decimal point.
				if (*x)
					*y++ = *x++;
				else
					*y++ = '0';
			}
		}
		// Copy in the decimal point.
		*y++ = '.';

		if (*x == 0) {
			*y++ = '0';
			decimal++;
		}

		// Add as many zeroes after the decimal point as indicated by "decimal"
		while (decimal++ < 0)
		  *y++ = '0';

		// Now, copy non-zero digits after that.--- the string x is null-terminated, 
		// so this loop will terminate.
		while (*x)
		  *y++ = *x++;

		*y = 0;
		
		// Create a new string and return.
		return ReturnString(jenv, return_val, double_class);
	}

	// In this case, we need to use a "computerized scientific notation"
	// , which is essentially the 'E' notation.

	*y++ = *x++;
	decimal--;
	*y++ = '.';

	if (*x == 0)
		*y++ = '0';

	while (*x)
		*y++ = *x++;

	*y++ = 'E';

	if (decimal < 0) {
		// '-' appears after 'E'
		*y++ = '-';
		decimal = -decimal;
	}

	// Now, construct the exponent.
	char exp[4];
	char *e = exp + 4;

	*--e = 0;

	do {
		*--e = '0' + decimal % 10;
		decimal /= 10;
	} while (decimal > 0);

	// Copy the exponent into the return string.
	while (*e)
		*y++ = *e++;

	// Null-terminate
	*y = 0;

	// Return the constructed string.
	return ReturnString(jenv, return_val, double_class);
	
//end of old Double.toString implementation
*/

}


/*
 * Class:     java_lang_Double
 * Method:    longBitsToDouble
 * Signature: (J)D
 */

JNIEXPORT jdouble JNICALL Java_java_lang_Double_longBitsToDouble
  (JNIEnv *jenv, jclass clazz, jlong long_value)
{
	union my_union u;
	u.l = long_value;
	return u.d;
}

/*
 * Class:     java_lang_Double
 * Method:    initIDs
 * Signature: ()V
 */

JNIEXPORT void JNICALL Java_java_lang_Double_initIDs
  (JNIEnv *jenv, jclass clazz)
{
}


