// Copyright (C)  2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_lang_Throwable.cpp,v 1.8 2001/11/22 01:25:15 gwu2 Exp $
//
#include "platform.h"

#include "object_layout.h"
#include "Class.h"
#include "ini.h"
#include "gc_for_orp.h"
#include "orp_utils.h"
#include "environment.h"
#include "exceptions.h"
#include "jni_utils.h"
#include "jni_direct.h"
#include "method_lookup.h"

#include "java_lang_Throwable.h"

#ifdef STACK_TRACE_ADDITIONAL_INFO

BOOL getMethodTraceAdditionalInfo(Method *meth, int eip, char *buf, int len)
{
	if(meth->is_native()){
		assert(len >= 14);
		strcpy(buf, "Native Method");
		return TRUE;
	}

	int offset = eip - (int)meth->get_code_addr();
	Line_Number_Table *ptable = meth->_line_number_table;
	if(!ptable || ptable->length == 0){
		assert(len >= 15);
		strcpy(buf, "Source Unknown");
		return TRUE;
	}
	Line_Number_Table_Entry *table = ptable->table;
	int l = 0, r = ptable->length-1, m = (l+r)/2;
	while(l < m && m < r){
		if(offset > table[m].npc_offset)
			l = m + 1;
		else
			if(offset < table[m].npc_offset)
				r = m - 1;
			else
				break;
		m = (l+r)/2;
	};
	if(offset < table[m].npc_offset)
		offset = table[m-1].line_number;
	else
		offset = table[m].line_number;
	const char *src = (const char*)meth->get_class()->src_file_name->bytes;
	assert(len >= (int)strlen(src) + 1 + 6);
	sprintf(buf, "%s:%d", src, offset);
	return TRUE;
}

#endif

/*
 * Class:     java_lang_Throwable
 * Method:    printStackTrace0
 * Signature: (Ljava/lang/Object;)V
 */
JNIEXPORT void JNICALL Java_java_lang_Throwable_printStackTrace0
  (JNIEnv *jenv, jobject pthis, jobject pstream)
{
    Class *throwable = ((Object_Handle)pthis)->java_reference->vt->clss;
    jfieldID traceinfo_id = (jfieldID)LookupField(throwable, "traceinfo");
    jstring info = GetObjectField(jenv, pthis, traceinfo_id);
    
    Class *stream = ((Object_Handle)pstream)->java_reference->vt->clss;
    jmethodID print_id = (jmethodID)LookupMethod(stream, "print", "(Ljava/lang/String;)V");
    CallVoidMethod(jenv, pstream, print_id, info);
}

/*
 * Class:     java_lang_Throwable
 * Method:    fillInStackTrace
 * Signature: ()Ljava/lang/Throwable;
 */
JNIEXPORT jthrowable JNICALL Java_java_lang_Throwable_fillInStackTrace
  (JNIEnv *jenv, jobject pthis)
{
    Class *throwable = ((Object_Handle)pthis)->java_reference->vt->clss;
    
    ExpandableMemBlock str;
    /*
    const char* thrdname = "<null>";
    jstring name = NULL;
    volatile Java_java_lang_Thread *pthread = p_TLS_orpthread->p_java_lang_thread; 
    if(pthread){
        jfieldID name_id = (jfieldID)LookupField(pthread->vt->clss, "name");
        Object_Handle thr_handle = orp_create_local_object_handle();
        thr_handle->java_reference = (Java_java_lang_Thread *)pthread;
        name = GetObjectField (jenv, (void*)thr_handle, name_id);
        thrdname = GetStringUTFChars(jenv, name, NULL);
    }
    
    str.AppendFormatBlock("Exception in thread \"%s\" %s\n",
                            thrdname,
                            throwable->name->bytes);

    if(name)
        ReleaseStringUTFChars(jenv, name, thrdname);
    */

    Frame_Context context;
	context.ljf   = (uint32)get_orp_last_java_frame();
	context.eip   = 0;
	context.p_eip = &(context.eip);

#ifdef STACK_TRACE_ADDITIONAL_INFO
	char buf[256];
#endif

	if (p_TLS_orpthread->throw_context) {
		orp_copy_frame_context(&context, p_TLS_orpthread->throw_context);
		JIT_Specific_Info *jit_info = methods.find((void *)*context.p_eip);
        Method *method = jit_info->get_method();
        Class *clss    = method->get_class();
        if(!orp_instanceof_class(throwable, clss)){
#ifdef STACK_TRACE_ADDITIONAL_INFO
			getMethodTraceAdditionalInfo(method, *context.p_eip, buf, 256);
			str.AppendFormatBlock("\tat %s.%s(%s)\n",
				   method->get_class()->name->bytes,
				   method->get_name()->bytes, buf);
#else
			str.AppendFormatBlock("\tat %s.%s\n",
				   method->get_class()->name->bytes,
				   method->get_name()->bytes);
#endif
		}
	}

    Boolean is_first_unwind = TRUE;
    while(1){
        orp_disable_gc(); 
		Boolean result = unwind_to_next_java_frame(&context, is_first_unwind, FALSE);
        orp_enable_gc();
        if (result) {
            if(is_first_unwind){
                is_first_unwind = FALSE;
            }

            JIT_Specific_Info *jit_info = methods.find((void *)*context.p_eip);
            Method *method = jit_info->get_method();
            Class *clss    = method->get_class();
        	if(orp_instanceof_class(throwable, clss))
			    continue;
#ifdef STACK_TRACE_ADDITIONAL_INFO
			getMethodTraceAdditionalInfo(method, *context.p_eip, buf, 256);
			str.AppendFormatBlock("\tat %s.%s(%s)\n",
				   method->get_class()->name->bytes,
				   method->get_name()->bytes, buf);
#else
			str.AppendFormatBlock("\tat %s.%s\n",
				   method->get_class()->name->bytes,
				   method->get_name()->bytes);
#endif
        }else{
             break;
        }
    }
    const char *info = str.toString();
    
    jfieldID traceinfo_id = (jfieldID*)LookupField(throwable, "traceinfo");
    
    orp_disable_gc();
    Java_java_lang_String *jstr = create_java_lang_String_from_C_string(info);
    Object_Handle str_handle = orp_create_local_object_handle();
    str_handle->java_reference = jstr;
    orp_enable_gc();

    SetObjectField(jenv, pthis, traceinfo_id, str_handle);

    return NULL;    
}

/*******************************************************************************
 *  The following is RNI implementation
 *******************************************************************************/

/*
#define STACK_DEPTH  128

Java_java_lang_Throwable *java_lang_Throwable_fillInStackTrace(Java_java_lang_Throwable *exobj)
{
	return NULL;
}

void stream_write(Java_java_lang_Object *stream,
					Method *m, //The 'write' method
					char *msg)
{
	J_Value args[4];
    args[0].r = (void *)stream;

	unsigned length = strlen(msg);
	unsigned sz = sizeof(JavaArray) + (length) * sizeof (J_Byte);
    sz = sz + OBJECT_HEADER_SIZE;
    // align the object upwards
    sz = (((sz + (GC_OBJECT_ALIGNMENT - 1)) 
          / GC_OBJECT_ALIGNMENT) * GC_OBJECT_ALIGNMENT);
 
	Class *clss = ORP_Global_State::loader_env->ArrayOfByte_Class;

    orp_disable_gc();       
 
    JavaArrayOfByte *array = (JavaArrayOfByte *)gc_malloc(sz, (Partial_Reveal_VTable *)clss->vtable);
    array->length = length;
	memcpy(&(array->body[0]), msg, length);

    gc_heap_slot_write_int32 ((Java_java_lang_Object *)array,
        &(array->length),
        length);

	args[1].r = array;
	args[2].i = 0;
	args[3].i = length;

    set_current_thread_exception(0);
    orp_execute_java_method_array(m, NULL, args);

	orp_enable_gc();        
}

//#define UNWIND_1
#define UNWIND_2
#include "gnu_specific.h"

void java_lang_Throwable_printStackTrace0(Java_java_lang_Throwable *exobj, Java_java_lang_Object *stream)
{
	if(!stream)return;
	Class *clss = stream->vt->clss;
	assert(clss);
    
    String *s = ORP_Global_State::loader_env->string_pool.lookup("java/io/PrintStream");
    Loader_Exception ld_exc;
    Class *clss2 =
        class_load_verify_prepare(ORP_Global_State::loader_env, s, &ld_exc);
    if(!clss2)return;
	if(!orp_instanceof_class(clss2, clss))return;
	
    Method *m = LookupMethod(clss, "write", "([BII)V");
	assert(m);

   	Class *clss_thr = exobj->vt->clss;

	char msg[512];

#ifdef UNWIND_1
	void *optimistic_trace[STACK_DEPTH];
    unsigned depth =
        orp_get_stack_depth_from_native_new(0, optimistic_trace, STACK_DEPTH);
    unsigned depth1;
    if(depth <= STACK_DEPTH) {
        depth1 = depth;
    } else {
        depth1 = STACK_DEPTH;
    }

    stream_write(stream, m, "Exception in thread \n");
    for(unsigned i = 0; i < depth1; i++) {
        void *eip = optimistic_trace[i];
        assert(orp_identify_eip(eip) == ORP_TYPE_JAVA);
        JIT_Specific_Info *jit_info = methods.find(eip);
        Method *method = jit_info->get_method();
        Class *clss    = method->get_class();
		if(orp_instanceof_class(clss_thr, clss))
			continue;
        sprintf(msg, 
			   "at %s.%s%s\n",
               method->get_class()->name->bytes,
               method->get_name()->bytes,
               method->get_descriptor());
		stream_write(stream, m, msg);
    }
#endif

#ifdef UNWIND_2
    Boolean have_thr_context = FALSE;
    Frame_Context thr_context;
	if (p_TLS_orpthread->throw_context) {
		orp_copy_frame_context(&thr_context, p_TLS_orpthread->throw_context);
		have_thr_context = TRUE;
	}

    Frame_Context context;
	context.ljf   = (uint32)get_orp_last_java_frame();
	context.eip   = 0;
	context.p_eip = &(context.eip);

    Boolean throw_context_used = FALSE;
    Boolean is_first = TRUE;
    while(1){
        orp_disable_gc(); 
		Boolean result = unwind_to_next_java_frame(&context,is_first,FALSE);
        orp_enable_gc();
        if (result) {
            JIT_Specific_Info *jit_info = methods.find((void *)*context.p_eip);
            is_first = FALSE;
            Method *method = jit_info->get_method();
            Class *clss    = method->get_class();
        	if(orp_instanceof_class(clss_thr, clss))
			    continue;
            sprintf(msg, 
			       "at %s.%s%s\n",
                   method->get_class()->name->bytes,
                   method->get_name()->bytes,
                   method->get_descriptor());
		    stream_write(stream, m, msg);
        }else{
            if((!throw_context_used)&&(have_thr_context)) {
				throw_context_used = TRUE;
				orp_copy_frame_context(&context, &thr_context);
				is_first = TRUE;
				JIT_Specific_Info *jit_info = methods.find((void *)*context.p_eip);
                Method *method = jit_info->get_method();
                Class *clss    = method->get_class();
        	    if(orp_instanceof_class(clss_thr, clss))
			        continue;
                sprintf(msg, 
			           "at %s.%s%s\n",
                       method->get_class()->name->bytes,
                       method->get_name()->bytes,
                       method->get_descriptor());
		        stream_write(stream, m, msg);
            }else
                break;
        }
    }
#endif
}
*/