// Copyright (C)  2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_lang_reflect_Method.cpp,v 1.5 2001/11/21 09:36:36 gwu2 Exp $
//

#ifdef ORP_POSIX
#include <unistd.h>
#endif

#include "platform.h"
#include <assert.h>
#include "object_layout.h"
#include "orp_utils.h"
#include "exceptions.h"
#include "jni.h"

#include <sys/types.h>
#include <sys/stat.h>

#ifdef ORP_NT
#include <io.h>
#endif

#include "native_utils.h"
#include "jni_direct.h"
#include "jni_utils.h"
#include "object_layout.h"

#include <fcntl.h>

#ifdef ORP_NT
#include <direct.h>
#endif

#include <errno.h>
#include "VMSystem.h"
#include "java_lang_reflect_Method.h"
#include "environment.h"

/*
 * Class:     case JAVA_lang_reflect_Method
 * Method:    getExceptionTypes
 * Signature: ()[Ljava/lang/Class;
 */
JNIEXPORT jobjectArray JNICALL Java_java_lang_reflect_Method_getExceptionTypes
  (JNIEnv *jenv, jobject p_this)
{
	Method *m = GetMethod(jenv, p_this);
	assert(m);
	
	int n_exceptions = m->num_exceptions_method_can_throw ();

	jclass cclazz = FindClass (jenv, "java/lang/Class");

	// Create array of java/lang/Class elements
	jobjectArray exceptionTypes = (jobjectArray) NewObjectArray (jenv, n_exceptions, cclazz, 0);

	int ii;
	Class_Loader *cl = m->get_class()->class_loader;
	for (ii =0; ii < n_exceptions; ii++) {
		//jclass exclass = FindClass (jenv, m->get_exception_name(ii)->bytes);
		jclass exclass = FindClassWithClassLoader(m->get_exception_name(ii)->bytes, cl);
		SetObjectArrayElement (jenv, exceptionTypes, ii, exclass);
	}

	return exceptionTypes;
}

/*
 * Class:     case JAVA_lang_reflect_Method
 * Method:    getModifiers
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_java_lang_reflect_Method_getModifiers
  (JNIEnv *jenv, jobject p_this)
{
	Method *m = GetMethod(jenv, p_this);
	assert(m);
	jint modifiers = m->get_access_flags();
	return modifiers;
}

/*
 * Class:     case JAVA_lang_reflect_Method
 * Method:    getParameterTypes
 * Signature: ()[Ljava/lang/Class;
 */
JNIEXPORT jobjectArray JNICALL Java_java_lang_reflect_Method_getParameterTypes
  (JNIEnv *jenv, jobject p_this)
{
	Method *m = GetMethod(jenv, p_this);
	assert(m);

	int nargs = m->get_num_args();

	//jclass *ptypes = GetMethodParameterTypes(jenv, m->get_descriptor(), &nargs);
	Class *clss = m->get_class();
	jclass *ptypes = GetMethodParameterTypes(jenv, m->get_descriptor(), &nargs, clss->class_loader);
	jclass cclazz = FindClass (jenv, "java/lang/Class");

	// Create array of java/lang/Class elements
	jobjectArray rtrnobjs = (jobjectArray)NewObjectArray (jenv, (nargs - 1), cclazz, 0);
	int ii;
	for (ii =0; ii < (nargs - 1); ii++) {
		SetObjectArrayElement (jenv, rtrnobjs, ii, ptypes[ii]);
	}
	free((void*)ptypes);

	return rtrnobjs;
}

/*
 * Class:     case JAVA_lang_reflect_Method
 * Method:    getReturnType
 * Signature: ()Ljava/lang/Class;
 */
JNIEXPORT jclass JNICALL Java_java_lang_reflect_Method_getReturnType
  (JNIEnv *jenv, jobject p_this)
{
	Method *m = GetMethod(jenv, p_this);
	assert(m);
	jclass rtrnobj = NULL;
	Java_Type type = m->get_return_java_type();
	switch(type){
	case JAVA_TYPE_BYTE:  /* = 'B' */
		rtrnobj = FindClass(jenv, "byte"); break;
    case JAVA_TYPE_CHAR:    /* = 'C' */
		rtrnobj = FindClass(jenv, "char"); break;
    case JAVA_TYPE_DOUBLE:  /* = 'D' */
		rtrnobj = FindClass(jenv, "double"); break;
    case JAVA_TYPE_FLOAT:   /* = 'F' */
		rtrnobj = FindClass(jenv, "float"); break;
    case JAVA_TYPE_INT:     /* = 'I' */
		rtrnobj = FindClass(jenv, "int"); break;
    case JAVA_TYPE_LONG:    /* = 'J' */
		rtrnobj = FindClass(jenv, "long"); break;
    case JAVA_TYPE_SHORT:   /* = 'S' */
		rtrnobj = FindClass(jenv, "short"); break;
    case JAVA_TYPE_BOOLEAN: /* = 'Z' */
		rtrnobj = FindClass(jenv, "boolean"); break;
    case JAVA_TYPE_CLASS:{   /* = 'L' */
		Class *clss = m->get_return_class_type();
		assert(clss);
		//rtrnobj = FindClass(jenv, clss->name->bytes); 
		rtrnobj = orp_create_local_object_handle();
		((Object_Handle)rtrnobj)->java_reference = (Java_java_lang_Object*)clss;
		break; }
    case JAVA_TYPE_ARRAY:{   /* = '[' */
		Class *clss = m->get_return_class_type();
		assert(clss && clss->is_array);
		//rtrnobj = FindClass(jenv, clss->name->bytes); 
		rtrnobj = orp_create_local_object_handle();
		((Object_Handle)rtrnobj)->java_reference = (Java_java_lang_Object*)clss;
		break;}
    case JAVA_TYPE_VOID:    /* = 'V' */
		rtrnobj = FindClass(jenv, "void" /* "java/lang/Void" */); break;
    case JAVA_TYPE_STRING:  /* = '$' */        // For constant strings
		rtrnobj = FindClass(jenv, "java/lang/String"); break;
	default:
		assert(0);
	}
	return rtrnobj;
}

/*
 * Class:     case JAVA_lang_reflect_Method
 * Method:    invokeNative
 * Signature: (Ljava/lang/Object;[Ljava/lang/Object;Ljava/lang/Class;I)Ljava/lang/Object;
 */
JNIEXPORT jobject JNICALL Java_java_lang_reflect_Method_invokeNative
  (JNIEnv *jenv, jobject p_this, jobject obj, jobjectArray args, 
	jclass declaringClass, jint slot)
{
	Method *m = GetMethod(jenv, p_this);
	assert(m);

	//if the method is an instance method. If the specified 
	// object argument is null, the invocation throws a NullPointerException
	if(!m->is_static()){
		if(!obj){
			ThrowNew_Quick (jenv, "java/lang/NullPointerException", 0);
			return (jobject)0;
		}
	}

	// class declaring the method
	Class *clss = m->get_class();
	assert(clss);

	// class on which the method is invoked
	Class *clzz;
		
	if(!m->is_static()){
		assert(obj);
		clzz = ((Object_Handle)obj)->java_reference->vt->clss;	
		assert(clzz);
		//if the specified object argument is not an instance of the class 
		// or interface declaring the underlying method, the invocation 
		// throws an IllegalArgumentException. 
		if(!orp_instanceof_class(clzz, clss)){
			ThrowNew_Quick (jenv, "java/lang/IllegalArgumentException", 0);
			return (jobject)0;
		}
	}else
		clzz = clss;

	// TO COMPLETE: ... other verifications
	//if this Method object enforces Java language access control and the 
	// underlying method is inaccessible, the invocation throws an 
	// IllegalAccessException. 

	//... ...

	if(clss != clzz){ //look for real implementation of the virtual method 
		m = LookupMethod(clzz, m->get_name()->bytes, m->get_descriptor());
		assert(m);
	}

	if( class_is_interface(clzz) ||
		m->is_abstract() ){
		//Java Library Documentation doesn't mention this case
		return (jobject)0;
	}

	int nargs = m->get_num_args();
	J_Value *vargs = (J_Value *)orp_malloc_gc_safe(nargs * sizeof(J_Value));

	Arg_List_Iterator iter = m->get_argument_list();
	if(m->is_static())
		unhandle_jobjectArray(jenv, iter, args, vargs, nargs);
	else{
		vargs[0].r = ((Object_Handle)obj)->java_reference; //put this into the first field
		unhandle_jobjectArray(jenv, iter, args, vargs + 1, nargs - 1);
	}

	J_Value result;
	Object_Handle jresult;
	
	orp_disable_gc();       
	
	set_current_thread_exception(0);
	orp_execute_java_method_array(m, &result, vargs);
	Java_java_lang_Object *expobj; 
	if(expobj = (Java_java_lang_Object*)get_current_thread_exception()) {
#if 0
		void print_stack_trace(FILE *f, Java_java_lang_Throwable *exc);
		print_stack_trace(NULL, expobj);
#endif
		orp_enable_gc();  
		set_current_thread_exception(0);
		jclass clzz = FindClass (jenv, "java/lang/reflect/InvocationTargetException");
		clss = (Class*)((Object_Handle)clzz)->java_reference;
		assert(clss);
		Method *m = LookupMethod(clss, "<init>", "(Ljava/lang/Throwable;)V");
		assert(m);
		Object_Handle exp = orp_create_local_object_handle();
		exp->java_reference = expobj;
		jobject nexp = NewObject(jenv, clzz, (jmethodID)m, exp);
		Java_java_lang_Throwable *nexpobj = ((Object_Handle)nexp)->java_reference;
		orp_disable_gc(); //??
		throw_java_exception_from_native(nexpobj);
		return 0;
	}

	Java_Type type = m->get_return_java_type();
	if(type != JAVA_TYPE_ARRAY && type != JAVA_TYPE_CLASS){
		orp_enable_gc();        //to avoid assert in class_load_verify_prepare_from_jni()
		jresult = (Object_Handle)WrapPrimitiveValueJ(jenv, result, type);
		orp_disable_gc(); 
	}
	else
		if(result.r) {
			jresult = orp_create_local_object_handle();
			jresult->java_reference = (Java_java_lang_Object *)result.r;
		} else {
			jresult = 0;
		}
	orp_free_gc_safe(vargs);

	orp_enable_gc();        

	return jresult;
}
