// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_net_PlainDatagramSocketImpl.cpp,v 1.4 2001/12/12 06:30:03 xli18 Exp $
//



#include "platform.h"
#include <assert.h>
#include <errno.h>

#ifdef ORP_NT
#include <winsock2.h>
#endif

#ifdef ORP_POSIX
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <string.h>
#endif

#include <jni.h>
#include <gnu_classpath_jni_utils.h>
#include "java_net_PlainSocketImpl_common.h"
#include "java_net_PlainDatagramSocketImpl.h"


#ifdef ORP_POSIX
extern int  WSAGetLastError();
#define INVALID_SOCKET -1
#define SOCKET_ERROR -1
#define SOCKET int
#endif

#ifdef OBJECT_LOCK_V2
#include "platform_utils_olv2.h"  //used to replace strerror(error) with socket_strerror(error)
#else
#include "platform_utils.h"
#endif

/*
 * Class:     java_net_PlainDatagramSocketImpl
 * Method:    create
 * Signature: ()V
 */

JNIEXPORT void JNICALL Java_java_net_PlainDatagramSocketImpl_create
  (JNIEnv *jenv, jobject jobj)
{
	// This is clearly a datagram socket -- so send in 0.
  	create_socket(jenv, jobj, 0);
}



/*
 * Class:     java_net_PlainDatagramSocketImpl
 * Method:    close
 * Signature: ()V
 */

JNIEXPORT void JNICALL Java_java_net_PlainDatagramSocketImpl_close
  (JNIEnv *jenv, jobject jobj)
{
	close_socket(jenv, jobj);
} // Java_java_net_PlainDatagramSocketImpl_close




/*
 * Class:     java_net_PlainDatagramSocketImpl
 * Method:    bind
 * Signature: (ILjava/net/InetAddress;)V
 */

JNIEXPORT void JNICALL Java_java_net_PlainDatagramSocketImpl_bind
  (JNIEnv *jenv, jobject jobj, jint localPortNumber, jobject INET_address)
{
	bind_socket(jenv, jobj, INET_address, localPortNumber, 0);

} // Java_java_net_PlainDatagramSocketImpl_bind


/*
 * Class:     java_net_PlainDatagramSocketImpl
 * Method:    sendto
 * Signature: (Ljava/net/InetAddress;I[BI)V
 */

JNIEXPORT void JNICALL Java_java_net_PlainDatagramSocketImpl_sendto
  (JNIEnv *jenv, jobject jobj, jobject INET_address, jint port, jbyteArray sendBuf, jint length)
{
	jclass clazz = get_plainDatagramSocketImpl_class(jenv);
	assert(clazz);
	SOCKET sock = get_socket_native_fd(jenv, clazz, jobj);
	
	if (sock == INVALID_SOCKET) { 
		int  error = WSAGetLastError();
#ifdef _DEBUG
		printf("java_net_PlainDatagramSocketImpl::sendto(): %s\n", socket_strerror(error));
#endif
		throw_exception_from_jni(jenv, "java/io/IOException", socket_strerror(error));
		return;
	}
	// Extract the actual byte array to send from.
	jboolean is_copy;
	jbyte *bytes = jenv->GetByteArrayElements(sendBuf, &is_copy);
    	assert(bytes);

	int written = 0; 
    	struct sockaddr socketStruct;
	memset(&socketStruct, 0, sizeof(socketStruct));
	socketStruct.sa_family = AF_INET;
    uint16 *p16 = (uint16 *)&(socketStruct.sa_data[0]);
	uint32 *p32 = (uint32 *)&(socketStruct.sa_data[2]);
	*p16 = htons((unsigned short)port);
	assert(INET_address);		// "to" Address better be specified.
    *p32 = get_net_address(jenv, INET_address);	

	// Start sending to specified address.
	if ((written = sendto(sock, (const char *) bytes, length, 0, &socketStruct, sizeof(socketStruct))) == -1) {
		int error = WSAGetLastError ();
#ifdef _DEBUG
       	printf("java_net_PlainDatagramSocketImpl_sendto::send(): %s\n", socket_strerror(error));
#endif
       	throw_exception_from_jni(jenv, "java/io/IOException", socket_strerror(error));
       	return;
	}
	jenv->ReleaseByteArrayElements(sendBuf, bytes, JNI_ABORT);
	return;
} // Java_java_net_PlainDatagramSocketImpl_sendto



/*
 * Class:     java_net_PlainDatagramSocketImpl
 * Method:    receive
 * Signature: (Ljava/net/DatagramPacket;)V
 */


JNIEXPORT void JNICALL Java_java_net_PlainDatagramSocketImpl_receive
  (JNIEnv *jenv, jobject jobj, jobject data)
{
	// The data is to be extracted into the array of bytes.
	// What is received is an object of type "java/net/DatagramPacket
	jclass data_class = jenv->GetObjectClass(data);
	assert(data_class);
	
	// Use "getLength()" to determine the length of the packet.
	jmethodID meth_id = jenv->GetMethodID(data_class, "getLength", "()I");
	assert(meth_id);
	jsize length = jenv->CallIntMethod(data, meth_id);
	assert(length >= 0);

	if (length == 0) { 
#ifdef _DEBUG
		printf("Java_java_net_PlainDatagramSocketImpl_receive() : passed in zero byte array\n");
#endif
		return;
	}
	// Use "getData()" to get the byte array that needs to be filled.
	meth_id = jenv->GetMethodID(data_class, "getData", "()[B");
	assert(meth_id);
	jarray byte_array = jenv->CallObjectMethod(data, meth_id);
	assert(byte_array);

	jclass clazz = get_plainDatagramSocketImpl_class(jenv);
	assert(clazz);
	SOCKET sock = get_socket_native_fd(jenv, clazz, jobj);
	
	if (sock == INVALID_SOCKET) { 
		int  error = WSAGetLastError();
#ifdef _DEBUG
		printf("java_net_PlainDatagramSocketImpl_receive(): %s\n", socket_strerror(error));
#endif
		throw_exception_from_jni(jenv, "java/io/IOException", socket_strerror(error));
		return;
	}

	// Extract the actual byte array to be read into.
	jboolean is_copy;
	jbyte *bytes = jenv->GetByteArrayElements(byte_array, &is_copy);
    assert(bytes);

	// Read in the data using "recvfrom()" starting at the given offset
	int read = 0; 
    struct sockaddr socketStruct;
	memset(&socketStruct, 0, sizeof(socketStruct));
	
#ifdef ORP_POSIX
	socklen_t from_len = sizeof(socketStruct);
#else
	int from_len = sizeof(socketStruct);
#endif	

	// Try to read as many bytes as the size of the byte array passed in.
	if ((read = recvfrom(sock, (char *) bytes, length, 0, &socketStruct, &from_len)) == -1) {
		int error = WSAGetLastError ();
       	orp_cout << "java_net_PlainDatagramSocketImpl_receive::receive error = " << error << endl;
       	// Should I throw an exception here???????        
		jenv->ReleaseByteArrayElements(byte_array, bytes, JNI_ABORT);
		return;
	}
	// Now we have been returned the sender's address etc...so parse that...
    uint16 *p16 = (uint16 *)&(socketStruct.sa_data[0]);
	uint32 *p32 = (uint32 *)&(socketStruct.sa_data[2]);
	jobject inet_addr = create_inet_addr(jenv, ntohl(*p32));
	assert(inet_addr);

	// Use "setAddress()" to set the Inet address of the Datagram packet.
	meth_id = jenv->GetMethodID(data_class, "setAddress", "(Ljava/net/InetAddress;)V");
	assert(meth_id);
	jenv->CallVoidMethod(data, meth_id, inet_addr);
	
	// Use "setPort()" to set the port of the Datagram packet.
	meth_id = jenv->GetMethodID(data_class, "setPort", "(I)V");
	assert(meth_id);
	int port = ntohs((unsigned short) (*p16));
	jenv->CallVoidMethod(data, meth_id, port);
	
	// Use setLength() to record number of bytes read.
	meth_id = jenv->GetMethodID(data_class, "setLength", "(I)V");
	assert(meth_id);
	jenv->CallVoidMethod(data, meth_id, read);
	
	// Copy back array and return.
	jenv->ReleaseByteArrayElements(byte_array, bytes, 0);
	return;

} // Java_java_net_PlainDatagramSocketImpl_receive



/*
 * Class:     java_net_PlainDatagramSocketImpl
 * Method:    join
 * Signature: (Ljava/net/InetAddress;)V
 */

JNIEXPORT void JNICALL Java_java_net_PlainDatagramSocketImpl_join
  (JNIEnv *jenv, jobject, jobject)
{
	// To join a multicast group....
#ifdef WIN32
	orp_cout << "Java_java_net_PlainDatagramSocketImpl_join() -- " 
			 << "Not supported on Win32 " << endl;
#endif
	assert(0);
} // Java_java_net_PlainDatagramSocketImpl_join




/*
 * Class:     java_net_PlainDatagramSocketImpl
 * Method:    leave
 * Signature: (Ljava/net/InetAddress;)V
 */

JNIEXPORT void JNICALL Java_java_net_PlainDatagramSocketImpl_leave
  (JNIEnv *, jobject, jobject)
{
	// To leave a multicast group.
#ifdef WIN32
	orp_cout << "Java_java_net_PlainDatagramSocketImpl_leave() " 
			 << "Not supported on Win32 " << endl;
#endif
	assert(0);
} // Java_java_net_PlainDatagramSocketImpl_leave



/*
 * Class:     java_net_PlainDatagramSocketImpl
 * Method:    getOption
 * Signature: (I)Ljava/lang/Object;
 */

JNIEXPORT jobject JNICALL Java_java_net_PlainDatagramSocketImpl_getOption
  (JNIEnv *jenv, jobject jobj, jint option_type)
{
	return socketGetOption(jenv, jobj, option_type);
} // Java_java_net_PlainDatagramSocketImpl_getOption




/*
 * Class:     java_net_PlainDatagramSocketImpl
 * Method:    setOption
 * Signature: (ILjava/lang/Object;)V
 */
JNIEXPORT void JNICALL Java_java_net_PlainDatagramSocketImpl_setOption
  (JNIEnv *jenv, jobject jobj, jint option_type, jobject value)
{
	socketSetOption(jenv, jobj, option_type, value);
} // Java_java_net_PlainDatagramSocketImpl_setOption









