// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/base/orp_init.cpp,v 1.24 2002/01/15 00:37:43 ssubram5 Exp $
//


#include "platform.h"
#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

#include "orp_types.h"
#include "jit_intf.h"
#include "Class.h"
#include "environment.h"
#include "method_lookup.h"
#include "exceptions.h"
#include "ini.h"
#include "orp_synch.h"
#include "object_layout.h"
#include "orp_utils.h"
#include "nogc.h"
#include "orp_synch.h"
#include "orp_for_gc.h"
#include "jni_direct.h"
#ifdef USE_IA64_JIT
#include "orp_ia64.h"
#endif

#ifdef OBJECT_LOCK_V2
#include "mon_enter_exit_olv2.h"
#else
#include "mon_enter_exit.h"
#endif

#ifdef WIN32
#include <winsock2.h>
#endif

#ifdef CLI_OCL
#include "../../common/cli_loader/PE_File.h"
#include "../../common/cli_loader/CLI.h"
#include "../include/cli_misc.h"
#endif

bool orp_is_initialized = false;

// turn this for for now ----> #define LIB_DEPENDENT_OPTS





void orp_initialize_critical_sections()
{
    p_jit_a_method_lock = new Lock_Manager();
    p_vtable_patch_lock = new Lock_Manager();
    p_load_class_lock = new Lock_Manager();
    p_meth_addr_table_lock = new Lock_Manager();
    p_thread_lock = p_gc_lock = new Lock_Manager();

	p_sapphire_link_block_lock = new Lock_Manager();
	p_ssb_lock = new Lock_Manager();
	p_sapphire_lock = new Lock_Manager();
} //orp_initialize_critical_sections



Class *preload_class(const char *classname)
{
    String *s = ORP_Global_State::loader_env->string_pool.lookup(classname);

    Loader_Exception ld_exc;
    Class *clss = class_load_verify_prepare(ORP_Global_State::loader_env, s, &ld_exc);
	if(clss == NULL) {

//#ifdef CLASS_LOADER_BOOTSTRAP
#ifndef OLD_VERSION_CLASSPATH
		extern bool bootstrapped;
		if (!bootstrapped) { 
			assert(strcmp(classname, "java/lang/Class") == 0);
			// signal end of bootstrap 
			bootstrapped = true;
		} else { 
			orp_cout << "Couldn't load class " << classname << endl;
			orp_exit(1);
		}
#else
		orp_cout << "Couldn't load class " << classname << endl;
		orp_exit(1);
#endif
    }
    return clss;
} //preload_class



// Return an untyped array of byte vtable (and class) for use by the GC.
void *orp_get_array_of_byte_vtable() 
{
    return (void *)ORP_Global_State::loader_env->ArrayOfByte_Class->vtable;
} //orp_get_array_of_byte_vtable



static Class *preload_primitive_class(const char *classname)
{
    String *s = ORP_Global_State::loader_env->string_pool.lookup(classname);

    Class *clss = new_class(s);
    clss->is_primitive = 1;
    ORP_Global_State::loader_env->class_table.insert(clss);

    return clss;
} //preload_primitive_class




#ifdef LIB_DEPENDENT_OPTS

static Class *class_initialize_by_name(const char *classname)
{
    String *s = ORP_Global_State::loader_env->string_pool.lookup(classname);

    Loader_Exception ld_exc;
    Class *clss = class_load_verify_prepare(ORP_Global_State::loader_env, s, &ld_exc);
	if(clss == NULL) {
        orp_cout << "Couldn't load class " << classname << endl;
        orp_exit(1);
    } else {
        class_initialize(clss);
    }
    return clss;
} //class_initialize_by_name



void lib_dependent_opts()
{
    class_initialize_by_name("java/lang/Math");
} //lib_dependent_opts

#endif



void init_java_lang_class_vtable()
{
} //init_java_lang_class_vtable



#ifdef CLI_OCL

Global_CLI_Env *global_cli_env = NULL;
// A HACK to reuse array creation code for creating both 
// Java arrays as well as CLI arrays.
bool currently_creating_java_arrays = true;

#endif



void orp_init(Global_Env *env,
              Loader_Exception *exception)
{
    if(orp_is_initialized)
        return;

    orp_is_initialized = true;
#ifdef _TRACE
    orp_cout << "Initializing the ORP" << endl;
#endif

    orp_init_mem_alloc();
    orp_monitor_init();

    orp_thread_init(env);

    jni_init();
    orp_atomic_compare_exchange = (void *(*)(void ** ,void *,void *))getaddress__orp_atomic_compare_exchange();

    active_thread_count = 1;

//#ifdef CLASS_LOADER_BOOTSTRAP
#ifndef OLD_VERSION_CLASSPATH
    // boot strap java.lang.class class
	preload_class("java/lang/Class");
#endif

    Class *class_java_lang_Object = preload_class("java/lang/Object");
    env->java_io_Serializable_Class = preload_class("java/io/Serializable");

    // java.lang.class
    env->JavaLangClass_Class = preload_class("java/lang/Class");
    
	// Any class loaded before this assignment must have its p_vtable field
    // patched manually.
    env->JavaLangClass_Class->p_vtable = env->JavaLangClass_Class->vtable;
    // Currently, there are two classes loaded recursively by
    // java.lang.Class: java.io.Serializable and java.lang.Object.
    class_java_lang_Object->p_vtable = env->JavaLangClass_Class->p_vtable;
    env->java_io_Serializable_Class->p_vtable = env->JavaLangClass_Class->p_vtable;


///////////////////////////////

    env->Boolean_Class = preload_primitive_class("boolean");
    env->Char_Class    = preload_primitive_class("char");

    env->Float_Class   = preload_primitive_class("float");
    env->Double_Class  = preload_primitive_class("double");
    env->Byte_Class    = preload_primitive_class("byte");
    env->Short_Class   = preload_primitive_class("short");
    env->Int_Class     = preload_primitive_class("int");
    env->Long_Class    = preload_primitive_class("long");
#ifdef CLI_TESTING
    env->UByte_Class   = preload_primitive_class("ubyte");
    env->UShort_Class  = preload_primitive_class("ushort");
    env->UInt_Class    = preload_primitive_class("uint");
    env->IntPtr_Class  = preload_primitive_class("native int");
    env->UIntPtr_Class = preload_primitive_class("native uint");
    env->ULong_Class   = preload_primitive_class("ulong");

#ifdef CLI_OCL
	// BAD HACK...We still NEED the Java arrays that derive from java/lang/Object for
	// initialization (orp_init). So CLI arrays that derive from System.Array which
	// in turn derive from System.Object are created later. Use the global 
	// boolean ...dont expect problems bcos single threaded orp_init() stage.
	// This way I can use the same preload_class(..) to accomplish both preloads.
	assert(currently_creating_java_arrays);
#endif // CLI_OCL

#endif // CLI_TESTING
    
    env->Void_Class    = preload_primitive_class("void");

    env->ArrayOfBoolean_Class   = preload_class("[Z");
    env->ArrayOfByte_Class      = preload_class("[B");
    env->ArrayOfChar_Class      = preload_class("[C");
    env->ArrayOfShort_Class     = preload_class("[S");
    env->ArrayOfInt_Class       = preload_class("[I");
    env->ArrayOfLong_Class      = preload_class("[J");
    env->ArrayOfFloat_Class     = preload_class("[F");
    env->ArrayOfDouble_Class    = preload_class("[D");
#ifdef CLI_TESTING
    env->ArrayOfUByte_Class     = preload_class("[b");
    env->ArrayOfUShort_Class    = preload_class("[s");
    env->ArrayOfUInt_Class      = preload_class("[i");
    env->ArrayOfIntPtr_Class    = preload_class("[N");
    env->ArrayOfUIntPtr_Class   = preload_class("[n");
    env->ArrayOfULong_Class     = preload_class("[j");
#endif

#ifndef POINTER64
    // In IA32, Arrays of Doubles need to be eight byte aligned to improve 
    // performance. In IA64 all objects (arrays, class data structures, heap objects)
    // get aligned on eight byte boundaries. So, this special code is not needed.
    env->ArrayOfDouble_Class->alignment = 8;
 
    // align doubles on 8, clear alignment field and put
    // in 8.
    set_prop_alignment_mask (env->ArrayOfDouble_Class, 8);
    // Set high bit in size so that gc knows there are constraints
#endif


    env->JavaLangString_Class   = preload_class("java/lang/String");
    env->JavaLangObject_Class   = class_java_lang_Object;

    env->java_lang_Throwable_Class =
        preload_class("java/lang/Throwable");
    env->java_lang_Error_Class =
        preload_class("java/lang/Error");
    env->java_lang_ExceptionInInitializerError_Class =
        preload_class("java/lang/ExceptionInInitializerError");
    env->java_lang_NullPointerException_Class =
        preload_class("java/lang/NullPointerException");
    env->java_lang_ArrayIndexOutOfBoundsException_Class =
        preload_class("java/lang/ArrayIndexOutOfBoundsException");
    env->java_lang_ArrayStoreException_Class =
        preload_class("java/lang/ArrayStoreException");
    env->java_lang_ArithmeticException_Class =
        preload_class("java/lang/ArithmeticException");
    env->java_lang_ClassCastException_Class =
        preload_class("java/lang/ClassCastException");

    env->java_lang_Cloneable_Class =
        preload_class("java/lang/Cloneable");
    env->java_lang_Thread_Class =
        preload_class("java/lang/Thread");

    env->java_util_Date_Class = 
        preload_class("java/util/Date");

    env->java_lang_Runtime_Class = 
		preload_class("java/lang/Runtime");

    Method *m = class_lookup_method_recursive(env->java_lang_Throwable_Class,
                                              "<init>", "()V");
    assert(m);
    m->set_side_effects(MSE_False);
    m = class_lookup_method_recursive(env->java_lang_Throwable_Class,
                                      "<init>", "(Ljava/lang/String;)V");
    assert(m);
    m->set_side_effects(MSE_False);
  
    // Invoke java.lang.Class constructor
    Class *jlc = env->JavaLangClass_Class;
    Method *java_lang_class_init = object_lookup_method(jlc, "<init>", "()V");
    orp_execute_java_method(java_lang_class_init, 0, jlc);

    void init_threadgroup();
    init_threadgroup();

	extern void init_base_classes(Global_Env *env);
	init_base_classes(env);

#ifdef _TRACE
    orp_cout << "initializeSystemClass completed" << endl;
#endif


#ifdef USE_IA64_JIT
    uint64 rse_mode = set_rse_mode(0);
    assert((get_rsc() & 3) == 0);
#endif

#ifdef WIN32
	// Code to startup Networking on Win32
	WORD wVersionRequested;
	WSADATA wsaData;
	int err; 
	wVersionRequested = MAKEWORD( 2, 2 ); 
	err = WSAStartup( wVersionRequested, &wsaData );

	if ( err != 0 ) {
		// Tell the user that we could not find a usable WinSock DLL.                                      
		orp_cout << "Couldn't startup Winsock 2.0 dll " << endl;
		assert(0);
	}
#endif

#ifdef LIB_DEPENDENT_OPTS
    lib_dependent_opts();
#endif

#ifdef CLI_OCL

    Global_CLI_Env *gce = new Global_CLI_Env();

    char *assembly_name = "mscorlib";
    char *name_space = "System";

    CLI_TypeDef *load_typedef_from_assembly(const char *,const char *,const char *);
    Class *load_class_from_type_def(CLI_TypeDef *, const char *);

	// Preload and prepare System.Object
    CLI_TypeDef *type_def = load_typedef_from_assembly(assembly_name, name_space,"Object");
    assert(type_def);
    gce->System_Object = load_class_from_type_def(type_def, "what.is.the.filename");
    Loader_Result res = cli_class_prepare(gce->System_Object);
    assert(res == LD_OK);

	// Preload and prepare System.ORPType
    type_def = load_typedef_from_assembly(assembly_name, "System", "ORPType");
    assert(type_def);
    gce->System_ORPType = 
        load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_ORPType);
    assert(res == LD_OK);

	// Preload and prepare System.Array
    type_def = load_typedef_from_assembly(assembly_name, name_space, "Array");
    assert(type_def);
    gce->System_Array = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_Array);
    assert(res == LD_OK);
	
	// NOW, turn on creation of CLI arrays.	
	currently_creating_java_arrays	= false;
	// Note the 'C' added at the end of each CLI array name.
	// I HAD to do this to maintain uniqueness between classnames 
	// of both Java and CLI arrays. Once again, Java arrays are needed now
	// during the ORP/OCL bootstrap stage since Java/lang/Class is still being
	// used and has not been replaced by a full-fledged System.Type yet and 
	// I believe for a host of other reasons too.
 	
    gce->ArrayOfBoolean_Class   = preload_class("[ZC");
    gce->ArrayOfByte_Class      = preload_class("[BC");
    gce->ArrayOfChar_Class      = preload_class("[CC");
    gce->ArrayOfShort_Class     = preload_class("[SC");
    gce->ArrayOfInt_Class       = preload_class("[IC");
    gce->ArrayOfLong_Class      = preload_class("[JC");
    gce->ArrayOfFloat_Class     = preload_class("[FC");
    gce->ArrayOfDouble_Class    = preload_class("[DC");
    gce->ArrayOfUByte_Class     = preload_class("[bC");
    gce->ArrayOfUShort_Class    = preload_class("[sC");
    gce->ArrayOfUInt_Class      = preload_class("[iC");
    gce->ArrayOfIntPtr_Class    = preload_class("[NC");
    gce->ArrayOfUIntPtr_Class   = preload_class("[nC");
    gce->ArrayOfULong_Class     = preload_class("[jC");

	// Preload and prepare System.String
    type_def = load_typedef_from_assembly(assembly_name, name_space, "String");
    assert(type_def);
    gce->System_String = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_String);
    assert(res == LD_OK);

	// Preload and prepare System.Boolean
    type_def = load_typedef_from_assembly(assembly_name, name_space, "Boolean");
    assert(type_def);
    gce->System_Boolean = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_Boolean);
    assert(res == LD_OK);

	// Preload and prepare System.Char 
    type_def = load_typedef_from_assembly(assembly_name, name_space, "Char");
    assert(type_def);
    gce->System_Char = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_Char);
    assert(res == LD_OK);

	// Preload and prepare System.Byte
    type_def = load_typedef_from_assembly(assembly_name, name_space, "Byte");
    assert(type_def);
    gce->System_Byte = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_Byte);
    assert(res == LD_OK);

	// Preload and prepare System.SByte
    type_def = load_typedef_from_assembly(assembly_name, name_space, "SByte");
    assert(type_def);
    gce->System_SByte = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_SByte);
    assert(res == LD_OK);

	// Preload and prepare System.Int16
    type_def = load_typedef_from_assembly(assembly_name, name_space, "Int16");
    assert(type_def);
    gce->System_Int16 = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_Int16);
    assert(res == LD_OK);

	// Preload and prepare System.UInt16
    type_def = load_typedef_from_assembly(assembly_name, name_space, "UInt16");
    assert(type_def);
    gce->System_UInt16 = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_UInt16);
    assert(res == LD_OK);

	// Preload and prepare System.Int32
    type_def = load_typedef_from_assembly(assembly_name, name_space, "Int32");
    assert(type_def);
    gce->System_Int32 = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_Int32);
    assert(res == LD_OK);

	// Preload and prepare System.UInt32
    type_def = load_typedef_from_assembly(assembly_name, name_space, "UInt32");
    assert(type_def);
    gce->System_UInt32 = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_UInt32);
    assert(res == LD_OK);

	// Preload and prepare System.Int64
    type_def = load_typedef_from_assembly(assembly_name, name_space, "Int64");
    assert(type_def);
    gce->System_Int64 = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_Int64);
    assert(res == LD_OK);

	// Preload and prepare System.UInt64
    type_def = load_typedef_from_assembly(assembly_name, name_space, "UInt64");
    assert(type_def);
    gce->System_UInt64 = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_UInt64);
    assert(res == LD_OK);

	// Preload and prepare System.IntPtr
    type_def = load_typedef_from_assembly(assembly_name, name_space, "IntPtr");
    assert(type_def);
    gce->System_IntPtr = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_IntPtr);
    assert(res == LD_OK);

	// Preload and prepare System.UIntPtr
    type_def = load_typedef_from_assembly(assembly_name, name_space, "UIntPtr");
    assert(type_def);
    gce->System_UIntPtr = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_UIntPtr);
    assert(res == LD_OK);
	
	// Preload and prepare System.Single
    type_def = load_typedef_from_assembly(assembly_name, name_space, "Single");
    assert(type_def);
    gce->System_Single = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_Single);
    assert(res == LD_OK);

	// Preload and prepare System.Double
    type_def = load_typedef_from_assembly(assembly_name, name_space, "Double");
    assert(type_def);
    gce->System_Double = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_Double);
    assert(res == LD_OK);

	// Preload and prepare ICloneable interface
    type_def = load_typedef_from_assembly(assembly_name, name_space, "ICloneable");
    assert(type_def);
    gce->System_ICloneable = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_ICloneable);
    assert(res == LD_OK);

	// Preload and prepare IComparable interface
    type_def = load_typedef_from_assembly(assembly_name, name_space, "IComparable");
    assert(type_def);
    gce->System_IComparable = load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_IComparable);
    assert(res == LD_OK);

	// Preload and prepare IEnumerable interface
    type_def = load_typedef_from_assembly(assembly_name, "System.Collections", "IEnumerable");
    assert(type_def);
    gce->System_Collections_IEnumerable = 
        load_class_from_type_def(type_def, "what.is.the.filename");
    res = cli_class_prepare(gce->System_Collections_IEnumerable);
    assert(res == LD_OK);
	// If following line is changed MAKE SURE to change the code in line 1724 of 
	// Class_File_Loader.cpp
	global_cli_env = gce;

#endif //CLI_OCL

} //orp_init


