// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/base/orp_vtune.cpp,v 1.4 2001/12/07 00:16:00 xli18 Exp $
//



#include "platform.h"
#include "fstream.h"

#include "orp_utils.h"

#include "orp_vtune.h"



#ifdef ORP_VTUNE_SUPPORT

#include "..\ia32_o1_jit\iJITProf.h"


void vtune_dump(iJIT_Method_Load &mInfo, ostream &o)
{
    o    << " method_id=" << (void *)mInfo.method_id
         << " method_name=" << mInfo.method_name << endl
         << " method_load_address=" << (void *)mInfo.method_load_address
         << " method_size=" << mInfo.method_size << endl
         << " line_number_size=" << mInfo.line_number_size
         << " line_number_table=" << mInfo.line_number_table << endl
         << " class_id=" << (void *)mInfo.class_id << endl
         << " class_file_name=" << mInfo.class_file_name << endl
         << " source_file_name=" << mInfo.source_file_name << endl
         << endl;
} //vtune_dump



void vtune_notify_load_finished(JIT_Specific_Info *m)
{
    Method *method = m->get_method();
    Class *clss = method->get_class();
    iJIT_Method_Load mInfo;
    mInfo.method_id           = (unsigned long)m;
    mInfo.method_name         = (char*)method->get_name()->bytes;
    mInfo.method_load_address = (unsigned long)m->get_code_block_addr();
    mInfo.method_size         = m->get_code_block_size();

    LineNumberInfo lni;
    lni.Offset                = 0;
    lni.LineNumber            = -1;
	unsigned short start_pc = (unsigned short)-1;
    Line_Number_Entry *lne = method->get_line_number_entries();
    for(; lne; lne = lne->next) {
        if(lne->start_pc == 0) {
            lni.LineNumber = lne->line_number;
            break;
        }
        if(lne->start_pc < start_pc) {
            start_pc       = lne->start_pc;
            lni.LineNumber = lne->line_number;
        }
    }
    if(((long)lni.LineNumber) < 0) {
        mInfo.line_number_size    = 0;
        mInfo.line_number_table   = 0;
    } else {
        mInfo.line_number_size    = 1;
        mInfo.line_number_table   = &lni;
    }

    mInfo.class_id            = (unsigned long)clss;
    if(clss->class_file_name && clss->src_file_name) {
        mInfo.class_file_name   = (char *)clss->class_file_name->bytes;
        mInfo.source_file_name  = (char *)clss->src_file_name->bytes;
        int notify_VTune =
            iJIT_NotifyEvent(//iORE_EVENT_TYPE_METHOD_LOAD_FINISHED,
                                iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED,
                             (void *)&mInfo);
        m->set_loaded_for_vtune(true);
    } else {
#if 1 //def TRACE_ORE
        cout << "Can't use vtune for " << clss->name->bytes
            << "." << method->get_name()->bytes << endl;
#endif
    }
} //vtune_notify_load_finished



#define MAX_NATIVES 1000
static Method *native_methods[MAX_NATIVES];
static int num_native_methods = 0;


void vtune_notify_unload_start(JIT_Specific_Info *m)
{
    if(m->get_loaded_for_vtune()) {
        int notify_VTune =
            iJIT_NotifyEvent(//iORE_EVENT_TYPE_METHOD_UNLOAD_START,
                                iJVM_EVENT_TYPE_METHOD_UNLOAD_START,
                             (void *)&m);
    }
} //vtune_notify_unload_start



void vtune_notify_native_load_finished(Method *method, const Byte *code, unsigned code_size)
{
    if(num_native_methods >= MAX_NATIVES) {
        printf("\n*** Too many natives: %d\n", num_native_methods);
        orp_exit(1);
    }
    native_methods[num_native_methods++] = method;

    Class *clss = method->get_class();
    iJIT_Method_Load mInfo;
    mInfo.method_id           = (unsigned long)method;
    mInfo.method_name         = (char*)method->get_name()->bytes;
    mInfo.method_load_address = (unsigned long)code;
    mInfo.method_size         = code_size;
    mInfo.line_number_size    = 0;
    mInfo.line_number_table   = 0;

    mInfo.class_id            = (unsigned long)clss;
    if(clss->class_file_name && clss->src_file_name) {
        mInfo.class_file_name   = (char *)clss->class_file_name->bytes;
        mInfo.source_file_name  = (char *)clss->src_file_name->bytes;
        int notify_VTune =
            iJIT_NotifyEvent(//iORE_EVENT_TYPE_METHOD_LOAD_FINISHED,
                                iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED,
                             (void *)&mInfo);
    } else {
#if 1 //def TRACE_ORE
        cout << "Can't use vtune for native " << clss->name->bytes
            << "." << method->get_name()->bytes << endl;
#endif
    }
} //vtune_notify_native_load_finished



void vtune_notify_native_unload_start(Method *m)
{
    int notify_VTune = iJIT_NotifyEvent(//iORE_EVENT_TYPE_METHOD_UNLOAD_START,
                                        iJVM_EVENT_TYPE_METHOD_UNLOAD_START,
                                        (void *)&m);
} //vtune_notify_native_unload_start



void vtune_notify_native_unload_all()
{
    for(int i = 0; i < num_native_methods; i++) {
        vtune_notify_native_unload_start(native_methods[i]);
    }
} //vtune_notify_native_unload_all


void vtune_notify_stub_load_finished(const char *name, const Byte *code, unsigned code_size)
{
    iJIT_Method_Load* pInfo;
    pInfo = (iJIT_Method_Load*)malloc(sizeof(iJIT_Method_Load)) ;
    iJIT_Method_Load& mInfo = (*pInfo);

//    iJIT_Method_Load mInfo;
    mInfo.method_id           = (unsigned long)code;
    mInfo.method_name         = (char *)name;
    mInfo.method_load_address = (unsigned long)code;
    mInfo.method_size         = code_size;
    mInfo.line_number_size    = 0;
    mInfo.line_number_table   = 0;

    mInfo.class_id            = (unsigned long)0;
    mInfo.class_file_name     = "STUB";
    mInfo.source_file_name    = "stub.java";
    int notify_VTune = iJIT_NotifyEvent(//iORE_EVENT_TYPE_METHOD_LOAD_FINISHED,
                                        iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED,
                                        (void *)&mInfo);
} //vtune_notify_stub_load_finished


#define MAX_SPECIALS 100
static const Byte *special_methods[MAX_SPECIALS];
static int num_special_methods = 0;

void vtune_notify_special_unload_start(const Byte *code);

void vtune_notify_special_load_finished(const char *name, const Byte *code, unsigned code_size)
{
    if(num_special_methods >= MAX_SPECIALS) {
        printf("\n*** Too many special methods: %d\n", num_special_methods);
        orp_exit(1);
    }
    special_methods[num_special_methods++] = code;

    iJIT_Method_Load mInfo;
    mInfo.method_id           = (unsigned long)code;
    mInfo.method_name         = (char *)name;
    mInfo.method_load_address = (unsigned long)code;
    mInfo.method_size         = code_size;
    mInfo.line_number_size    = 0;
    mInfo.line_number_table   = 0;

    mInfo.class_id            = (unsigned long)0;
    mInfo.class_file_name     = "IVM";
    mInfo.source_file_name    = "ivm.java";
    int notify_VTune = iJIT_NotifyEvent(//iORE_EVENT_TYPE_METHOD_LOAD_FINISHED,
                                        iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED,
                                        (void *)&mInfo);

    vtune_notify_special_unload_start(code);
} //vtune_notify_special_load_finished



void vtune_notify_special_unload_start(const Byte *code)
{
    int notify_VTune = iJIT_NotifyEvent(//iORE_EVENT_TYPE_METHOD_UNLOAD_START,
                                        iJVM_EVENT_TYPE_METHOD_UNLOAD_START,
                                        (void *)&code);
} //vtune_notify_special_unload_start



void vtune_notify_special_unload_all()
{
    for(int i = 0; i < num_special_methods; i++) {
        //vtune_notify_special_unload_start(special_methods[i]);
    }
} //vtune_notify_special_unload_all



#endif
