// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/include/los_container.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#ifndef _los_container_H_
#define _los_container_H_

//
// The LOS Container contains an array of large object stores.
// Initially we start with one, then add them as needed. If
// any falls empty, we delete that store.
//


#include "Block_Store.h"
#include "card_table.h"
#include "object_layout.h"
#include "gc_space.h"
#include "gc_consts.h"
#include "gc_interface.h"
#include "gc_plan.h"

class Gc_Fast_Hooks;
// class Gc_Plan;
class Large_Object_Store;

class LOS_Container : public Gc_Component {
public:

    LOS_Container(Gc_Interface  *p_gc_interface,
                  Gc_Fast_Hooks *p_gc_hooks,
                  Gc_Plan       *p_gc_plan,
		          Generation    *p_container,
		          Card_Table    *p_card_table,
			      Block_Store   *p_bs);

    virtual ~LOS_Container() {
		// BE SURE TO DELETE ALL CONTAINED LOSs: TODO
	}

    //
    // Debugging routine for printing out LOS stats.
    //
    void dump_stats();

	//
	// Allocate an object into large object space.
	//
 
    Java_java_lang_Object *gc_pinned_malloc(unsigned size, 
		                   Partial_Reveal_VTable *p_vtable,
						   bool return_null_on_fail,
                           bool double_align
                           );
 
	//
	// A special version during bootstrapping for objects
	// that still don't have classes.
	//
	Java_java_lang_Object *gc_pinned_malloc_noclass(unsigned size);

	//
	// Do any required cleanup at the end of the collection.
	// This may include running finalizers on dead objects,
	// etc.. 
	//
	virtual void cleanup();

    //
    // The LOS is being give a chance to set up the instrumentation
    // to do things like space accounting, just before a GC hits.
    //
    void prepare_for_collection();

	Java_java_lang_Object *p_scavenge_object(Java_java_lang_Object **pp_obj) {
		orp_exit(1); // illegal call
		return NULL;
	}

#if 0 // (GC_DEBUG>3)
	//
	// Debug routine to inspect details.
	//
	virtual void inspect(unsigned int level);
#endif // _DEBUG

	//
	// Merge the entries in the incoming remembered set with entry.
    // This is only valid for GC Spaces with their own remembered sets.
    // (Such as cars, and unlike nurseries and steps.)
	//
	virtual void update_remembered_set(Java_java_lang_Object **pp_obj) {
		cout << "Error: attempt to add entry to a LOS rs (I don't have one!)" << endl;
        orp_exit(1);
	}

#if 0 //  (GC_DEBUG>3)
	//
	// Each space provides a routine to verify that it is consistent.
	// i.e. contains only well-formed objects.
	//
	virtual bool verify_space();
#endif // _DEBUG

    bool _walk_los(bool (*func)(Object_Gc_Header *));

	inline virtual int my_block_size_bytes() {
		return _los_block_size_bytes;
	}

	void set_generation(Generation *p_gen);

	//
	// We failed to allocate an object even after triggering a
	// collection. This is the time to try to extend the LOS.
	//
	void extend_los(unsigned int real_size_bytes);
    // #ifdef GC_MARK_FLAGS implements non-resident mark bits
	void clear_mark_bits ();
    // #endif // GC_MARK_FLAGS

    bool is_block_available(unsigned int size);
private:

	int _number_of_large_object_stores;

	Large_Object_Store *_p_los_array[MAXIMUM_LOSES_IN_LOS_CONTAINER];

    Generation *_p_container;

    Card_Table *_p_card_table;

	int _los_block_size_bytes;

    // 
    // Add a new los to this container.
    //
    void add_los (Large_Object_Store *an_los);
	//
	// A pointer to the enclosing GC Interface.
	//
	Gc_Interface *_p_gc_interface;

	unsigned int _largest_object_size;

	//
	// This is a pointer to the live object which has
	// the highest address in the LOS. It is used when
	// doing linear scans, so that we don't fall of the
	// high end (into unallocated space).
	//
	Java_java_lang_Object *_p_last_object;
	//
	// When doing a linear scan to reclaim dead objects,
	// we keep track of the last live object we scanned,
	// so that when we get to the end, if we find that the
	// last object is no longer live, we know what the 
	// new last object is.
	//
	Java_java_lang_Object *_p_last_live_object;
	//
	// This flag is set when the LOS can't do a first-fit of the
	// required block size. This flag is checked again after the
	// subsequent collection to see if this allocation still fails.
	// This is a signal that the heap needs extending. This boolean
	// is reset after any successful allocation.
	//
	bool _los_space_may_be_critically_low;

	//
	// Out of space - need a collection.
	//
	void _notify_large_object_store_exhausted(unsigned int real_size_bytes);
	//
	// Really out of space, despite a collection - error.
	//
    
    void _notify_large_object_store_exhausted_error(unsigned int size);

};

#endif // _los_container_H_

