// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/include/train.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#ifndef _train_H_
#define _train_H_

//
// Definition of trains in collector of mature object space.
//
// Currently a Train is a Gc_Space, though it really doesn't need to be.
// Need to fix..
//
//                          Gc_Space (abstract)
//                              |
//             ------------------------------------
//             |                     |            |
//             |                     |            |
//        Block_List (abstract)      |            |
//             |                     |            |
//      ---------------------        |            |
//      |                    |       |         Nursery
//     Car                  Step   Train
//
//

#include <assert.h>
#include "gc_header.h"
#include "gc_interface.h"
#include "Block_Store.h"
#include "car.h"
#include "mrl_gc_v1.h"
#include "gc_consts.h"
#include "gc_globals.h"


class Card_Table;
class Gc_Fast_Hooks;
class Gc_Space;
class Train_Generation;
class Gc_Plan;

class Train : public Gc_Space {
public:
    Train(unsigned long    train_number,
          Gc_Fast_Hooks    *p_gc_hooks,
          Gc_Plan          *p_gc_plan,
		  Train_Generation *p_container,
          Card_Table       *p_card_table,
		  Block_Store      *p_block_store);

    virtual ~Train();

	//
	// Return a pointer to the oldest car.
	//
	Car *p_nominate_focus_car() {
		
		if (_number_of_cars > 0) {
			return _p_cars[0];
		}

		return NULL;
	}
	//
	// Return the number of cars in this train.
	//
	unsigned long get_number_of_cars() {
		return _number_of_cars;
	}

	Java_java_lang_Object *p_scavenge_object(Java_java_lang_Object **pp_obj);

#if (GC_DEBUG>2)
	//
	// Do any pending cheney scans.
	//
	void execute_cheney_scan(Generation *p_gen, bool doing_mos_collection) {
		cout << "Error: illegal train request to execute cheney scan" << endl;
		orp_exit(1); // illegal for trains
	}
#endif // _DEBUG

    void enumerate_reference_queues ();

	virtual void cleanup();
	//
	// Membership checking routines for trains need to be overridden.
	//
	virtual bool is_my_object(Java_java_lang_Object *p_obj);

	virtual bool is_my_reference(Java_java_lang_Object **pp_obj_ref);

	virtual bool is_my_address(void *p_addr);
	//
	// routines for introspection
	//

    virtual bool is_train() {
        return true;
    }

    //
    // Return my name and ID in a printable string for debugging.
    //
    virtual void my_name() {
        cout << "Train with ID " << identity;
    }

	Remembered_Set *
        generate_root_set(Remembered_Set *p_rs);

    //
    // Our container generation is asking us to attempt to
    // reclaim ourselves. Return true if the entire train
    // was garbage.
    //
	bool reclaim_train(Remembered_Set *p_outside_refs,
                       Remembered_Set *p_weak_refs);

    //
    // Run all finalizers at exit time if required by app.
    //
    void run_all_finalizers();

	unsigned long get_train_id(){ 
		return get_id();
	}
    Object_Gc_Header *p_move_to_train_end(Java_java_lang_Object **pp_obj);
    //
    // Check if the train is a candidate for reclamation.
    //
    bool no_incoming_refs();

	void _add_car(void);
    
    bool is_reference_in_my_train(Java_java_lang_Object **pp_obj_ref);

	bool is_reference_outside_my_train(Java_java_lang_Object **pp_obj_ref) {
		if (is_reference_in_my_train(pp_obj_ref)) {
			return false;
		}

		return true;
	}

	//void move_object_to_end_of_train(Java_java_lang_Object **pp_ref);

#if (GC_DEBUG>0)
	//
	// Debug routine to inspect details.
	//
	virtual void inspect(unsigned int level);
#endif // _DEBUG

	//
	// Need to be able to update train ids after reclaiming trains.
	//
	void set_id(unsigned id) {
		identity = id;
	}
	//
	// Merge the entries in the incoming remembered set with entry.
    // This is only valid for GC Spaces with their own remembered sets.
    // (Such as cars, and unlike nurseries and steps.)
	//
	virtual void update_remembered_set(Java_java_lang_Object **pp_obj) {
		cout << "Error: attempt to add entry to a train's rs (I don't have one!)" << endl;
        orp_exit(1);
	}
    //
    // Debug routine to verify none of the consituent cars have invalid
    // entries into their write barriers.
    //
    void verify_cars_write_barriers();

#if (GC_DEBUG>3)
	//
	// Each space provides a routine to verify that it is consistent.
	// i.e. contains only well-formed objects.
	//
	virtual bool verify_space();
#endif // _DEBUG

	//
	// Overload operator== to compare trains of objects.
	//
	bool operator==(Train &train2) {
		if (identity == train2.get_train_id())
        	return true;

		return false;
	}

	bool operator<(Train &train2) {
		if (identity < train2.get_train_id())
        	return true;

		return false;
	}

	bool operator>(Train &train2) {
		if (identity > train2.get_train_id())
        	return true;

		return false;
	}


    // Loop through all the cars doing any need cheney scans.
    // This can be sped up at some point since we know that only the cars
    // at the end of the train need to be scanned. It can be more than the last
    // one since we may have had to create a new car to hold unscanned objects.
    //
    bool cheney_scan_cars (bool doing_mos_collection);
    // Do any of the cars have a pending chency scan??
    bool cheney_scan_pending ();

    bool walk_train(bool (*func)(Object_Gc_Header *, Remembered_Set *p_rs));

	virtual int my_block_size_bytes() {
		cerr << "Trains don't have block sizes" << endl;
		assert(0);
		orp_exit(1);
		return -1;
	}

static Train *sapphire_select_to_train (Java_java_lang_Object **pp_slot);

Java_java_lang_Object *p_reserve_space(Java_java_lang_Object **pp_obj);
Java_java_lang_Object *p_reserve_bytes(unsigned size);

	//
	// The oldest car has been completely evacuated.
	// Delete it.
	//
	void _free_oldest_car();

private:
    Train();
	//
	// Bump the scan pointer forward past an object
	//
	virtual bool 
	_advance_scan_pointer(unsigned int real_object_size_bytes) {
		orp_exit(1); // illegal
		return true;
	}
    //
    // The number cars I currently own.
    //
    unsigned long _number_of_cars;

    Train_Generation *_p_train_generation;

    Car *_p_cars[MAXIMUM_CARS];
};


#endif // _train_H_
