// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/gc_header.cpp,v 1.9 2002/01/11 15:47:38 weldon Exp $
//

#include "platform.h"
#include "gc_header.h"
#include "orp_types.h"
//#include "native.h"    /* in ..\native\include\ */
#include "gc_debug.h"
#include "gc_space.h"
 
#ifdef OBJECT_SPLITTING
#include "gc_plan.h"
#endif // OBJECT_SPLITTING

#include "gc_globals.h"

//#if (GC_DEBUG>0)
#include "block_store.h"
#include "step.h"
#include "los.h"
 
#include "gc_for_orp.h"

#ifdef GC_SAPPHIRE
// Yet another kludge to keep sapphire code seperated.
#include "sapphire.h"
#endif // GC_SAPPHIRE
 
extern Block_Store *p_global_bs;
//#endif // _DEBUG
//
// This holds the status of each of the blocks in the system.

gc_block_status *gc_block_status_table;

#include <string.h>
static int object_hash = 0;

void *get_free_block_link(void *p_block_ptr)
{
	return *(void **)((char *)p_block_ptr + sizeof(POINTER_SIZE_INT) * 2);
}

unsigned int get_free_block_size(void *p_block_ptr)
{
	return *(int *)((char *)p_block_ptr + sizeof(POINTER_SIZE_INT));
}

bool is_java_object(void *p_thing)
{
	Java_java_lang_Object *p_obj = (Java_java_lang_Object *)p_thing;
	return is_java_object(p_obj);
}

 
bool is_vtable(Partial_Reveal_VTable *p_vtable)
{
    if (p_vtable == 0)
		return false;

    if (p_loaded_vtable_directory->is_present((Java_java_lang_Object **)p_vtable)) 
        return true;

    return false;
}

bool is_java_object(Java_java_lang_Object *p_obj)
{
    VTable *p_vtable = p_obj->vt;
    return is_vtable(p_vtable);
}
 
// #ifdef GC_MARK_FLAGS - implements non-resident marking bits.

//
// Code for marking LOS objects...
//
// Make a mark available for every 8 bytes (on IA64 make if every 16 bytes)
// This does not need to be exact, in fact since it is conservative we
// can collect objects in this are only if all objects are free.
// So to shrink the size of the mark table just shift by say 8 (256 bytes)
// But be careful not to clear the bits after you look at the first object
// in the card.

bool is_object_marked(Java_java_lang_Object *p_obj)
{
#ifdef _DEBUG
   block_info *a_block = GC_BLOCK_INFO(p_obj);
   MARK *mark = a_block->mark_table;
   int block_offset = ((POINTER_SIZE_INT)p_obj & GC_BLOCK_LOW_MASK); 
   int the_index = block_offset >> GC_LOS_MARK_SHIFT_COUNT;
   POINTER_SIZE_INT index = GC_LOS_MARK_INDEX(p_obj);
#endif
    return GC_LOS_MARK(p_obj);
}

bool
is_object_unmarked(Java_java_lang_Object *p_obj)
{
    if (is_object_marked(p_obj)) {
        return false;
    } else {
        return true;
    }
}


void set_free_block_header(void *p_block_ptr)
{
   	*((POINTER_SIZE_INT *)p_block_ptr) = FREE_BLOCK_HEADER;
}

void set_free_block_link(void *p_block_ptr, void *p_next_block)
{
	*(void **)((Byte *)p_block_ptr + sizeof(POINTER_SIZE_INT) * 2) = p_next_block;	
}

void set_free_block_size(void *p_block_ptr, unsigned int size)
{
    assert (size != 0);
	*((POINTER_SIZE_INT *)((Byte *)p_block_ptr + sizeof(POINTER_SIZE_INT))) = size;
}

void set_object_marked(Java_java_lang_Object *p_obj)
{
#ifdef _DEBUG
   block_info *a_block = GC_BLOCK_INFO(p_obj);
   MARK *mark = a_block->mark_table;
   int block_offset = ((POINTER_SIZE_INT)p_obj & GC_BLOCK_LOW_MASK); 
   int the_index = block_offset >> GC_LOS_MARK_SHIFT_COUNT;
   POINTER_SIZE_INT index = GC_LOS_MARK_INDEX(p_obj);
   char result = GC_LOS_MARK(p_obj);
#endif
    GC_LOS_MARK(p_obj)=true;
}

void set_object_unmarked(Java_java_lang_Object *p_obj)
{
#ifdef _DEBUG
// from gc_header.h    
//   GC_MARK_INDEX(P_OBJ) ((P_OBJ & GC_BLOCK_LOW_MASK) << (GC_BLOCK_INFO(P_OBJ)->mark_shift_count))
//   GC_MARK(P_OBJ) (GC_BLOCK_INFO(P_OBJ)->mark_table[GC_MARK_INFO(P_OBJ)])
   block_info *a_block = GC_BLOCK_INFO(p_obj);
   MARK *mark = a_block->mark_table;
   int block_offset = ((POINTER_SIZE_INT)p_obj & GC_BLOCK_LOW_MASK); 
   int the_index = block_offset >> GC_LOS_MARK_SHIFT_COUNT;
   POINTER_SIZE_INT index = GC_LOS_MARK_INDEX(p_obj);
   char result = GC_LOS_MARK(p_obj);
#endif
    GC_LOS_MARK(p_obj)=false;
}

void set_object_unmarked(Object_Gc_Header *p_hdr)
{
#ifdef _DEBUG
   block_info *a_block = GC_BLOCK_INFO(p_hdr);
   MARK *mark = a_block->mark_table;
   int block_offset = ((POINTER_SIZE_INT)p_hdr & GC_BLOCK_LOW_MASK); 
   int the_index = block_offset >> GC_LOS_MARK_SHIFT_COUNT;
   POINTER_SIZE_INT index = GC_LOS_MARK_INDEX(p_hdr);
   char result = GC_LOS_MARK(p_hdr);
#endif
    GC_LOS_MARK(p_hdr)=false;
}

void
update_reference_forwarded(Java_java_lang_Object **pp_obj)
{
    assert(0);


    return;
}
 
// end file gc_header.cpp


