// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/step.h,v 1.5 2002/01/09 14:50:13 weldon Exp $
//

#ifndef _step_H_
#define _step_H_

//
// Each generation consists of a variable number of steps which are used
// to age objects before promoting them to an older generation. Steps
// are built out of blocks.
//
//
// A Step is a Gc_Space. It is a container, or a repository of
// Java objects. Along with Cars, it inherits from Block_List, which
// implements spaces that are built out of non-contiguous blocks.
//
//                          Gc_Space (abstract)
//                              |
//             ------------------------------------
//             |                                  |
//             |                                  |
//        Block_List (abstract)                   |
//      ---------------------                     |
//      |                    |                 Nursery
//     Car                  Step
//
//

#include "platform.h"

#include "gc_header.h"
#include "remembered_set.h"
#include "block_store.h"
#include "generation.h"
#include "descendents.h"
#include "gc_hooks.h"

#include "block_list.h"

#ifdef GC_COPY_V2
// I am not sure why this is set to a constant but for a simple copy collector
// it needs to be very big. This will cause us to have very big arrays
// to hold this information and this needs to be dealt with. - RLH 8-17-98
#define MAXIMUM_BLOCKS_IN_STEP 16384

#else 

#define MAXIMUM_BLOCKS_IN_STEP 32768

#endif
block_list_info *add_new_step ();
void set_up_step_cheney_spaces(step_info *step, block_info **pp_step_from_blocks);

class Card_Table;
class Gc_Fast_Hooks;
class Gc_Plan;

class Step : public Block_List {
public:
	//
	// Create a step (done by Step_Plus_Nursery_Generation).
	//
    Step(unsigned long step_id,
         Gc_Fast_Hooks *p_gc_hooks,
         Gc_Plan       *p_gc_plan,
		 Generation    *p_container,
		 Gc_Space      *p_superior,
         Card_Table    *p_card_table,
		 Block_Store   *p_block_store);

	//
	// Delete a step. Currently unused. May need to collapse steps later.
	//
	virtual ~Step()
		// BUG BUG: NEED TO CALL ANCESTOR DESTRUCTOR : ~Block_List() {
		//
		// Delete only the FROM blocks. (The ancestor will take
		// care of the rest.
		//
	{
        assert(0);
	}


	//
	// routines for introspection
	//

	virtual bool is_step() {
		return true;
	}

	//
	// Merge the entries in the incoming remembered set with entry.
    // This is only valid for GC Spaces with their own remembered sets.
    // (Such as cars, and unlike nurseries and steps.)
	//
	virtual void update_remembered_set(Java_java_lang_Object **pp_obj) {
		cout << "Error: attempt to add entry to a step's rs (I don't have one!)" << endl;
        orp_exit(1);
	}

protected:
	//
	// The following routine should be implemented by all containers
	// that implement block lists. The value returned by the container
	// reflects a generation encoding, which is used by the block list
	// object for marking all sub blocks in the block store. This is
	// used later for doing fast checks of generations.
	//
	virtual unsigned long _get_generation_encoding() {
		//
		// We return zero signifying that all steps are currently
		// part of the young generation.
		//
		return YOS_GEN_NUMBER;
	}

private:

    Step();

};



#endif // _step_H_

