// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/remembered_set.cpp,v 1.3 2001/10/12 14:47:04 rlhudson Exp $
//

#include "remembered_set.h"
#include "gc_header.h"
#include "train_generation.h"

#include "gc_space.h"
#include "block_store.h"
extern Block_Store *p_global_bs;

// Override the add_entry to do check to ensure pointer is valid.

//
// Add an entry into this hash table, if it doesn't already exist.
//

// For now remove the inline so we can check for valid references.
//    inline 
unsigned 
Remembered_Set::add_entry(Java_java_lang_Object **address)
{

    return Hash_Table::add_entry((void *)address);
}
//
// Clone myself.
//
Remembered_Set *
Remembered_Set::p_clone()
{
    Remembered_Set *p_cloned_rs = new Remembered_Set();

    rewind();
    
    Java_java_lang_Object **pp_obj_ref;
    while ((pp_obj_ref = next()) != NULL) {
        p_cloned_rs->add_entry(pp_obj_ref);
    }
    rewind();
    p_cloned_rs->rewind();

    return p_cloned_rs;
}

#if 0 // UNNECESSARY ??
//
// This is a higher-speed version of the step-generation's
// _reflect_tenuring_in_write_barrier. It searches for entries
// into younger space that have to be updated due to the recent
// tenuring, and updates appropriately.
//
void Remembered_Set::reflect_tenuring(Java_java_lang_Object *p_old,
                                      Train_Generation  *p_mature_generation) 
{       

    for (int index = 0; index < _size_in_entries; index++) {

        Java_java_lang_Object **pp_ref = (Java_java_lang_Object **)_table[index];

        if ((pp_ref != NULL) && (*pp_ref == p_old)) {
            //
            // OK, we got a match. Update this to reflect the recent tenuring.
            //
            update_reference_forwarded(pp_ref);
            //
            // Remove this entry from the remembered set.
            //
            _table[index] = 0;
            //
            // May need to update inter-car remembered sets
            //
            p_mature_generation->add_entry_to_generation_write_barriers(pp_ref,
                                                                        *pp_ref);
        }
    }
}
#endif




// end file gc\remembered_set.cpp


