// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/step_generation.cpp,v 1.13 2002/01/09 14:50:13 weldon Exp $
//

#include "platform.h"
#include "step_generation.h"
#include "card_table.h"
#include "car.h"
#include "train.h"
#include "remembered_set.h"
#include "gc_hooks.h"
#include "block_store.h"
#include "finalize.h"
#include "gc_plan.h"
#include "orp_for_gc.h"


// First the queues.

java_lang_ref_ReferenceQueue *global_weak_ref_queue = NULL;
java_lang_ref_ReferenceQueue *global_soft_ref_queue = NULL;
java_lang_ref_ReferenceQueue *global_phantom_ref_queue = NULL;

//
// Enumerate the reference queues.
//
void enumerate_reference_queues ()
{
    gc_add_root_set_entry((Java_java_lang_Object **)&global_weak_ref_queue);
    gc_add_root_set_entry((Java_java_lang_Object **)&global_soft_ref_queue);
    gc_add_root_set_entry((Java_java_lang_Object **)&global_phantom_ref_queue);
#ifdef GC_TRACE_WEAK_REF
    orp_cout << "We just enumerated the weak/soft/phantom reference queues" << endl;
#endif // GC_TRACE_WEAK_REF
}

//
// If a queue has been specified we need to move the reference into the queue.
// Similar code is in car.cpp, if there is a bug here there probable is one there.
//
void process_weak_reference (Java_java_lang_ref_Reference *p_ref_Reference)
{
    // If there is a queue enqueue the reference object.
    if (p_ref_Reference->queue) {
        // If the object has not already been enqueud do, if it has
        // been enqued don't enqueue it again.
        if (!p_ref_Reference->enqueued) {
            java_lang_ref_ReferenceQueue *the_queue = p_ref_Reference->queue;
            if (the_queue->which == 1){
                p_ref_Reference->next = the_queue->head2;
                the_queue->head2 = p_ref_Reference;
            } else {                
                assert ((the_queue->which == 2) || (the_queue->which == 0));
                p_ref_Reference->next = the_queue->head1;
                the_queue->head1 = p_ref_Reference;
            }
            orp_notify_reference_queue((Java_java_lang_Object *)the_queue);
            p_ref_Reference->enqueued = true;
        }
    }
    p_ref_Reference->referent = NULL; // Clear the referent.
#ifdef GC_TRACE_WEAK_REF
    orp_cout << "Weak Reference has to been processed." << endl;
#endif // GC_TRACE_WEAK_REF
    return;
}

void process_soft_reference (Java_java_lang_ref_Reference *p_ref_Reference)
{
    // If there is a queue, enqueue the reference object.
    if (p_ref_Reference->queue) {
        // If the object has not already been enqueued, do it, if it has
        // been enqueued don't enqueue it again.
        if (!p_ref_Reference->enqueued) {
            java_lang_ref_ReferenceQueue *the_queue = p_ref_Reference->queue;
            if (the_queue->which == 1){
                p_ref_Reference->next = the_queue->head2;
                the_queue->head2 = p_ref_Reference;
            } else {                
                assert ((the_queue->which == 2) || (the_queue->which == 0));
                p_ref_Reference->next = the_queue->head1;
                the_queue->head1 = p_ref_Reference;
            }
            orp_notify_reference_queue((Java_java_lang_Object *)the_queue);
            p_ref_Reference->enqueued = true;
        }
    }
    p_ref_Reference->referent = NULL; // Clear the referent.
#ifdef GC_TRACE_WEAK_REF
	orp_cout << "Soft Reference has been processed." << endl;
#endif // GC_TRACE_WEAK_REF
    return;
}

void process_phantom_reference (Java_java_lang_ref_Reference *p_ref_Reference)
{
    // If there is a queue, enqueue the reference object.
    if (p_ref_Reference->queue) {
        // If the object has not already been enqueued do it, if it has
        // been enqueued don't enqueue it again.
        if (!p_ref_Reference->enqueued) {
            java_lang_ref_ReferenceQueue *the_queue = p_ref_Reference->queue;
            if (the_queue->which == 1){
                p_ref_Reference->next = the_queue->head2;
                the_queue->head2 = p_ref_Reference;
            } else {                
                assert ((the_queue->which == 2) || (the_queue->which == 0));
                p_ref_Reference->next = the_queue->head1;
                the_queue->head1 = p_ref_Reference;
            }
            orp_notify_reference_queue((Java_java_lang_Object *)the_queue);
            p_ref_Reference->enqueued = true;
        }
    } 
#ifdef GC_TRACE_WEAK_REF
    // The referent is not cleared in the case of a phantom reference.
	orp_cout << "Phantom Reference has been processed." << endl;
#endif // GC_TRACE_WEAK_REF
    return;
}


// This is executed for all steps and cars at each collection.
//
// We have a list of java.lang.ref.referenece objects. They each have 
// a hidden field pointing to the referent. This field is only accessable 
// via the "get" method. If the referent was in a region that was being
// collected then either it was moved indicating that it is still alive
// or it was not moved indicating that the only references to it are 
// weak references. 
//
// If it was moved (and is alive) then the java.lang.ref.reference is 
//    dequeued from the queue associated with the old location of the object
//    and queued with the new location.
// If it was not moved (is unreachable) then the java.lang.ref.reference 
//    object will be places on the java.lang.ref.ReferenceQueue if on was associated 
//    with it when it was created.
//
//
void
_update_weak_references(bool doing_mos_collection)
{
#ifndef GC_REWORK
	if (_p_weak_object_list) {
		java_lang_ref_Reference *p_ref_Reference = (java_lang_ref_Reference *)_p_weak_object_list;
		java_lang_ref_Reference *p_next = NULL;
		_p_weak_object_list = NULL; // This is about to be rebuilt.

	    while (p_ref_Reference != NULL) {
			p_next = p_ref_Reference->next;
		    Java_java_lang_Object *p_obj = p_ref_Reference->referent;
 
		    if (p_obj) {			
				Gc_Space *p_gc_space = p_global_bs->p_get_object_container(p_obj);
				if (p_gc_space->is_large_object_space()) {
		            if (is_object_unmarked(p_obj)) {
			            //
				        // An unmarked object in LOS is toast at the end of the
					    // gc cycle. 
						//
						// The object is only reachable via this pointer.
						// enqueue the object if that has been requested. 
						process_weak_reference (p_ref_Reference);
					}
					else {
							//LOS objects that are marked are put back on the _p_weak_ref_object_list;
						gc_register_weak_ref ((JavaObject *)p_ref_Reference, (JavaObject *)(p_get_already_forwarded_object(p_obj)));
					}
	            } else {	
                   
					if (is_object_forwarded(p_obj)) { 
						// gc_register_weak_ref will always add to the front of the list
						// so we won't have to reprocess objects that have been removed and
						// then reregistered with the step_generation.
						gc_register_weak_ref ((Partial_Reveal_JavaObject *)p_ref_Reference, (Partial_Reveal_JavaObject *)(p_get_already_forwarded_object(p_obj)));
					} else { 
						//
                        // The object is only reachable via this this pointer.
						// enqueue the object if that has been requested.
						//
						process_weak_reference (p_ref_Reference); 
                 	}
				}
	        }  else {
				// We have a reference with the referent cleared. We can ignore it.
			} 
			p_ref_Reference = p_next;
		}
	}
#endif
    // Cheney scan since we might have promoted a reference object.
//GC_REWORK...    Generation::execute_pending_cheney_scans(false);
} 

void
_update_phantom_references(bool doing_mos_collection)
{
#ifndef GC_REWORK
	// loop through all the objects on the list. All the referents have been moved
	// to new cars if they are strongly reachable (still alive). If they aren't 
	// alive then the referents are enqueued. My reading of the spec is that we
	// don't clear the referent even though we can not retrieve the referent. I assume this
	// is done so that the objects that the referent's referents are kept
	// alive so that they can be used.

	if (global_phantom_ref_queue) {
		java_lang_ref_Reference *p_ref_Reference = (java_lang_ref_Reference *)global_phantom_ref_queue;
		java_lang_ref_Reference *p_next = NULL;

		// Clear _p_phantom_object_list since it will be rebuilt as needed.
		global_phantom_ref_queue = NULL;

	    while (p_ref_Reference != NULL) {
		    Java_java_lang_Object *p_obj;
			p_obj = p_ref_Reference->referent;
		    if (p_obj) {			
				if (BLOCK_INFO(p_obj)->in_los_p) {
		            if (is_object_unmarked(p_obj)) {
			            //
				        // An unmarked object in LOS is toast at the end of the
					    // gc cycle. 
						//
						// The object is only reachable via this pointer.
						// enqueue the object if that has been requested. 
						process_phantom_reference (p_ref_Reference);
						// Keep the object alive.

						// Evict the referent, treating the object as if it 
						// was reachable from a root.
						Java_java_lang_Object *temp =
							_p_evict_object_or_update_forwarding(&p_ref_Reference->referent, doing_mos_collection); 

						// gc_register_soft_ref will always add to the front of the list
						// of some other car. These pointers are scanned, not remembered.
						gc_register_phantom_ref ((JavaObject *)p_ref_Reference, (JavaObject *)(p_obj));
					} else { // LOS objects that are marked (alive) are re registered
						gc_register_phantom_ref ((JavaObject *)p_ref_Reference, (JavaObject *)(p_obj));
					}
				} else { // It is not a large object
					if (!(BLOCK_INFO(p_obj)->c_area_p) || (is_object_forwarded(p_obj)) { // It is alive...
						p_next = p_ref_Reference->next;
						p_ref_Reference->next = NULL;
						// gc_register_weak_ref will always add to the front of the list
						// of some other car.
						gc_register_phantom_ref ((JavaObject *)p_ref_Reference, (JavaObject *)(p_get_already_forwarded_object(p_obj)));
					} else { 

                        // Object has died. Save it.
	    				// Assert that p_obj is in this generation
						p_next = p_ref_Reference->next;
						p_ref_Reference->next = NULL;
						// Evict the referent, treating the object as if it 
						// was reachable from a root.
						Java_java_lang_Object *temp =
							_p_evict_object_or_update_forwarding(&p_ref_Reference->referent, doing_mos_collection); 
#if (GC_DEBUG>0)
						assert (temp == p_ref_Reference->referent);
#endif
						//
						// The object is only reachable via this this pointer.
						// enqueue the object if that has been requested.
						//
						process_phantom_reference (p_ref_Reference);

#ifdef GC_TRACE_WEAK_REF
						orp_cout << "Moving phantom object." << endl;
#endif // GC_TRACE_WEAK_REF
					}
               	}
	        } else {
				// How can we have a ref.Reference with out a referent?
				// The application can clear the referent leaving us with a null referent.
				// In this case the ref.Reference object can be removed from the list.
				p_next = p_ref_Reference->next;
				p_ref_Reference->next = NULL; 
			}
			p_ref_Reference = p_next;
		}
	}
    // Cheney scan the spaces that might hold promoted objects.
#endif // not GC_REWORK.
//GC_REWORK... 	Generation::execute_pending_cheney_scans(false);
} 

void
_update_soft_references(bool low_on_space, bool doing_mos_collection)
{

#ifndef GC_REWORK
    // loop through all the objects on the list. All the referents have been moved
	// if they are strongly reachable (still alive). If they aren't 
	// alive and update_soft_reference we are low on space then the referents are 
	// cleared and enqueued.
	// If we are not low on space then the object is copied to new space
	// and kept alive.

	if (_p_soft_object_list) {
		java_lang_ref_Reference *p_ref_Reference = (java_lang_ref_Reference *)_p_soft_object_list;
		java_lang_ref_Reference *p_next = NULL;

		// Clear _p_soft_object_list since it will be rebuilt as needed.
		_p_soft_object_list = NULL;

	    while (p_ref_Reference != NULL) {
		    Java_java_lang_Object *p_obj;
			p_obj = p_ref_Reference->referent;
		    if (p_obj) {
				if (is_object_forwarded(p_obj)) { // It has been moved.
					p_next = p_ref_Reference->next;
					p_ref_Reference->next = NULL;
					// gc_register_soft_ref will always add to the front of the list
					// of some other car.
					gc_register_soft_ref ((JavaObject *)p_ref_Reference, (JavaObject *)(p_get_already_forwarded_object(p_obj)));
				} else { // Object has died. Kill it if we are low_on_space
	    			// Assert that p_obj is in this generation

					if (low_on_space) {
						p_next = p_ref_Reference->next;
						p_ref_Reference->next = NULL;
						//
				        // The object is only reachable via this this pointer.
						// enqueue the object if that has been requested.
						//
						process_soft_reference (p_ref_Reference);
					} else {
						p_next = p_ref_Reference->next;
						p_ref_Reference->next = NULL;
						// Move the referent to another car, treating the object as if it 
						// was reachable from a root.				
						Java_java_lang_Object *temp =
							_p_evict_object_or_update_forwarding(&p_ref_Reference->referent, doing_mos_collection); 
#if (GC_DEBUG>0)
						assert (temp == p_ref_Reference->referent);
#endif

#ifdef GC_TRACE_WEAK_REF
						orp_cout << "Moving unreachable soft object." << endl;
#endif // GC_TRACE_WEAK_REF
					}
               	}
	        } else {
				// How can we have a ref.Reference with out a referent?
				// The application can clear the referent leaving us with a null referent.
				// In this case the ref.Reference object can be removed from the list.
				p_next = p_ref_Reference->next;
				p_ref_Reference->next = NULL; 
			}

			p_ref_Reference = p_next;
		}
	}
    // Cheney scan the spaces that might hold promoted objects.
#endif
//GC_REWORK... 	Generation::execute_pending_cheney_scans(false);
} 


//
// We have finished a minor collection. Beforp we return we need to
// scan the spent nurseries, from spaces and LOS for unreachable 
// objects that have just become candidates for finalization.
//
void 
_locate_and_process_finalizable_objects(bool doing_mos_collection)
{
#ifdef GC_REWORK
    assert(0); // Deal with finalized objects not yet done for new system.
    orp_cout << "Not finalizing object in step generation. " << endl;
    return;
#else
    Java_java_lang_Object *p_obj;
    Java_java_lang_Object *p_source_object;
    Java_java_lang_Object *p_target_object;
    Java_java_lang_Object **pp_obj_ref;
    Object_List       *p_object_list = _p_finalizable_object_list;

    //
    // Create a new Object List for storing new state of objects
    //
    _p_finalizable_object_list = new Object_List();

    //
    // Iterate through the finalizable objects in our generation
    //
    p_object_list->rewind();
    while ((p_obj = p_object_list->next()) != NULL) {

        Gc_Space *p_container = 
            _p_block_store->p_get_object_container(p_obj);
        if (p_container->is_large_object_space()) {
           if (is_object_unmarked(p_obj)) {
                //
                // Found an unreachable pinned object - temporarily revive it
                // and notify the ORP.
                //
                pp_obj_ref = &p_obj;
                p_source_object = p_obj;
                p_target_object = p_container->p_evict_object(pp_obj_ref, doing_mos_collection);
                orp_finalize_object(p_target_object);
           } else {
                //
                // This object doesn't move:just return it to the list
                //
                _p_finalizable_object_list->add_entry(p_obj);
           } // if (is_object_unmarked(p_obj))
        } else { // not in LOS
            if (!is_object_forwarded(p_obj)) {
                //
                // Found an unreachable object - temporarily revive it
                // and notify the ORP.
                //  
            
                pp_obj_ref = &p_obj;
                p_source_object = p_obj;
                p_target_object = p_container->p_evict_object(pp_obj_ref, doing_mos_collection);
                orp_finalize_object(p_target_object);
 
#if 0 // DEBUG DELETEME DELETE ME JUNK TRASH
                cout << "OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO" << endl;
                cout << "Finalizing young unreachable object " << p_source_object << " after moving to ";
                cout << p_target_object;
                cout << " of type " << p_obj->vt->clss->name->bytes << endl;
#endif
            } else {
                //
                // This object is still alive
                //
                //
                // Locate the new resting place:
                //
                Object_Gc_Header *p_gc_hdr = P_OBJ_INFO(p_obj);
                p_target_object     = 
                    (Java_java_lang_Object *)((POINTER_SIZE_INT)*p_gc_hdr & ~FORWARDING_BIT_MASK);
 
                //
                // Check if it has been tenured
                //
                Generation *p_generation = 
                    p_global_bs->p_get_object_generation(p_target_object);

                if (p_generation==this) {
                    //
                    // Nope: we are still in young space
                    //
                    _p_finalizable_object_list->add_entry(p_target_object);

                } else {
                    //
                    // Yes: tenured: container has to be a car
                    //
                    p_container =
                        _p_block_store->p_get_object_container(p_target_object);

                    assert(p_container->is_car());
                    ((Car *)p_container)->record_finalizable_object(p_target_object);

                } // if (p_generation==this) 
            } // if (!is_object_forwarded(p_obj))
        } // if (p_container->is_large_objec_space())
    } // while ((p_obj = p_object_list->next()) != NULL
    //
    // OK, we have gotten all the candidates for finalization.
    // Now revive all finalizer-reachable objects.
    //
//    orp_cout << "Executing pending cheney scans due to finalizable objects." << endl;
    execute_pending_cheney_scans(false);
    //
    delete p_object_list;
#endif // GC_REWORK NOT DONE YET HERE.
}

 

Step_Generation::Step_Generation(unsigned long gen_num,
                                 Gc_Fast_Hooks *p_gc_hooks,
                                 Gc_Plan       *p_gc_plan,
		                         Gc_Interface  *p_container,
					             Generation    *p_superior,
                                 Card_Table    *p_card_table,
		                         Block_Store   *p_block_store)
    : Generation(gen_num, 
                 p_gc_hooks,
                 p_gc_plan,
                 p_container, 
                 p_superior, 
                 p_card_table,
                 p_block_store)
{
/**
    int step_index = _number_of_steps = 
        _p_gc_plan->number_of_steps();

    while (--step_index >= 0)
	    _add_step(step_index);

**/
       //
       // Create an object set for objects in this generation that
       // will need to be finalized when they become unreachable.
       //
    _p_finalizable_object_list = new Object_List();

	
	//
	// This queue holds all the reference object whose referent (as returned by get)
	// are in this step (or step_nursery) generation. Since all steps in this generation 
	// are collected at the same time we only need one set of queues. 
	// In MOS the queues are assocated with each car.
	// These objects are created lazily since creating them now before initialization 
	// is complete creates new issues.
	//
    _p_weak_object_list = NULL;

    _p_soft_object_list = NULL;

    _p_phantom_object_list = NULL;

#if (GC_DEBUG>0)
    step_generation_creation_hook(this);
#endif

}

//
// This support routine is used during generation initialization to
// add another step to the generation. Currently we don't dynamically
// vary the number of steps at run time.
//
void
Step_Generation::_add_step(unsigned long step_index)
{
	//
	// First determine the higher step that this to-be-constructed
	// step will be promoting objects into. (The "higher" step.)
	// If this is the highest step, the "higher" step will be NULL,
	// and objects will be tenured into a higher generation, instead
	// of being promoted into a higher step.
	//
	Step *p_higher_step = 
		step_index == _number_of_steps - 1
		? NULL : _p_step[step_index + 1];

	//
	// Now create the step.
	//
    _p_step[step_index] = new Step(step_index,
                                   _p_gc_hooks,
                                   _p_gc_plan,
		                           this,
								   p_higher_step,
                                   _p_card_table,
		                           _p_block_store);
}

//
// Every generation needs to define a policy for handling objects
// found during cheney scans.
// 
// This is the one for Step Generations and derivatives.
// Step Generations (and NS Generations) simply send eviction notices
// to all reachable objects.
//
// When a container (Gc_Space or Block_List) does a cheney scan,
// it queries the generation of the FROM space container of the object
// that was moved, for the policy for doing the cheney scan. That is
// how we get to this routine.
//
// In terms of Tri-color algorithms this routine scans a grey object,
// and turns objects it finds to grey using the evict notice.
//


//
// Do any cleanup after a collection.
//
void
Step_Generation::cleanup()
{
    assert(0);
	return;
}

void
Step_Generation::run_all_finalizers() 
{
    Java_java_lang_Object *p_obj;

    _p_finalizable_object_list->rewind();

    while((p_obj = _p_finalizable_object_list->next()) != NULL) {
        orp_finalize_object(p_obj);
    }
}
//
// During a reclamation of an object that is live, perhaps during
// the top-level reclaim or the cheney scan of a contained space, 
// a pointer out of this generation into mature space was found.
// Let's try to be clever and capture only those pointers from young-to-
// old that are relevant to a subsequent incremental scan of mature space.
//
void 
Step_Generation::_update_into_mature_generation_ref(Java_java_lang_Object **pp_obj_ref, 
                                                    bool doing_mos_collection)
{
#ifdef GC_REWORK
    assert(0);
#else
    //
	// Be clever and record this reference only if it is into the 
	// focus car/train.
    //
	// RLH-TRAIN we only need to note the existance of the pointer. If it is
    // to the focus car it will be moved out of the focus train (and car).
    // If it is to the focus train but not the focus car then the train
    // must be kept alive. We need to note this fact here...
	if (doing_mos_collection) {
		if (((Mrl_Gc_V1 *)p_gc)->p_get_focus_car()->is_my_object(*pp_obj_ref)) {

            // We have a slot with a pointer into the focus car, evict the object.
            *pp_obj_ref = ((Mrl_Gc_V1 *)p_gc)->p_get_focus_car()->p_evict_out_of_mos_ref(pp_obj_ref);

			//
			// Also note that this focus train is alive.
			//
			_train_is_live = true;

		} else if (((Mrl_Gc_V1 *)p_gc)->p_get_focus_train()->is_my_object(*pp_obj_ref)){
#ifndef GC_TRAIN_V5
#ifdef GC_GEN_V3
            assert (0); // For GC_GEN_V3 there is only one car in the train so we
                        // should not be here.
#endif
#endif // GC_TRAIN_V5
			//
			// Record a boolean if it is a reference into the oldest (focus) train.
			//
			_train_is_live = true;
		}
    } else { 
        // Just doing a YOS collection, so remember ref it is to the focus car.
        if (((Mrl_Gc_V1 *)p_gc)->p_get_focus_car() != NULL) {
            if (((Mrl_Gc_V1 *)p_gc)->p_get_focus_car()->is_my_object(*pp_obj_ref)) {
                add_young_to_old_ref(pp_obj_ref);
    			_train_is_live = true;
            }
        }
    }
#endif // GC_REWORK
}
#if 0
// Moved to above out of Step_Generation.
void Step_Generation::enumerate_reference_queues ()
{
    if (_p_weak_object_list) {
        gc_add_root_set_entry((Java_java_lang_Object **)&_p_weak_object_list);
    }
    
    if (_p_soft_object_list) {
        gc_add_root_set_entry((Java_java_lang_Object **)&_p_soft_object_list);
    }
    
    if (_p_phantom_object_list) {
        gc_add_root_set_entry((Java_java_lang_Object **)&_p_phantom_object_list);
    }
#ifdef GC_TRACE_WEAK_REF
    orp_cout << "Step generation just enumerated the weak/soft/phantom reference queues" << endl;
#endif // GC_TRACE_WEAK_REF
}

// Because of race condition we use compare exchagne.
void Step_Generation::enqueue_soft_ref (java_lang_ref_Reference *soft_reference)
{
    assert(0);
}

void Step_Generation::enqueue_weak_ref (java_lang_ref_Reference *weak_reference)
{
//    weak_reference->next = _p_weak_object_list;
    gc_heap_slot_write_ref ((Java_java_lang_Object *)weak_reference,
        (Java_java_lang_Object **)&(weak_reference->next),
        (Java_java_lang_Object *)_p_weak_object_list);
	_p_weak_object_list = weak_reference; 
}

void Step_Generation::enqueue_phantom_ref (java_lang_ref_Reference *phantom_reference)
{ 
//    phantom_reference->next = _p_phantom_object_list;
    gc_heap_slot_write_ref ((Java_java_lang_Object *)phantom_reference,
        (Java_java_lang_Object **)&(phantom_reference->next),
        (Java_java_lang_Object *)_p_phantom_object_list);
	_p_phantom_object_list = phantom_reference;
}

//
// If a queue has been specified we need to move the reference into the queue.
// Similar code is in car.cpp, if there is a bug here there probable is one there.
//
void process_weak_reference (Java_java_lang_ref_Reference *p_ref_Reference)
{
    // If there is a queue enqueue the reference object.
    if (p_ref_Reference->queue) {
        // If the object has not already been enqueud do, if it has
        // been enqued don't enqueue it again.
        if (!p_ref_Reference->enqueued) {
            java_lang_ref_ReferenceQueue *the_queue = p_ref_Reference->queue;
            if (the_queue->which == 1){
                p_ref_Reference->next = the_queue->head2;
                the_queue->head2 = p_ref_Reference;
            } else {                
                assert ((the_queue->which == 2) || (the_queue->which == 0));
                p_ref_Reference->next = the_queue->head1;
                the_queue->head1 = p_ref_Reference;
            }
            orp_notify_reference_queue((Java_java_lang_Object *)the_queue);
            p_ref_Reference->enqueued = true;
        }
    }
    p_ref_Reference->referent = NULL; // Clear the referent.
#ifdef GC_TRACE_WEAK_REF
    orp_cout << "Weak Reference has to been processed." << endl;
#endif // GC_TRACE_WEAK_REF
    return;
}

void process_soft_reference (Java_java_lang_ref_Reference *p_ref_Reference)
{
    // If there is a queue, enqueue the reference object.
    if (p_ref_Reference->queue) {
        // If the object has not already been enqueued, do it, if it has
        // been enqueued don't enqueue it again.
        if (!p_ref_Reference->enqueued) {
            java_lang_ref_ReferenceQueue *the_queue = p_ref_Reference->queue;
            if (the_queue->which == 1){
                p_ref_Reference->next = the_queue->head2;
                the_queue->head2 = p_ref_Reference;
            } else {                
                assert ((the_queue->which == 2) || (the_queue->which == 0));
                p_ref_Reference->next = the_queue->head1;
                the_queue->head1 = p_ref_Reference;
            }
            orp_notify_reference_queue((Java_java_lang_Object *)the_queue);
            p_ref_Reference->enqueued = true;
        }
    }
    p_ref_Reference->referent = NULL; // Clear the referent.
#ifdef GC_TRACE_WEAK_REF
	orp_cout << "Soft Reference has been processed." << endl;
#endif // GC_TRACE_WEAK_REF
    return;
}

void process_phantom_reference (Java_java_lang_ref_Reference *p_ref_Reference)
{
    // If there is a queue, enqueue the reference object.
    if (p_ref_Reference->queue) {
        // If the object has not already been enqueued do it, if it has
        // been enqueued don't enqueue it again.
        if (!p_ref_Reference->enqueued) {
            java_lang_ref_ReferenceQueue *the_queue = p_ref_Reference->queue;
            if (the_queue->which == 1){
                p_ref_Reference->next = the_queue->head2;
                the_queue->head2 = p_ref_Reference;
            } else {                
                assert ((the_queue->which == 2) || (the_queue->which == 0));
                p_ref_Reference->next = the_queue->head1;
                the_queue->head1 = p_ref_Reference;
            }
            orp_notify_reference_queue((Java_java_lang_Object *)the_queue);
            p_ref_Reference->enqueued = true;
        }
    } 
#ifdef GC_TRACE_WEAK_REF
    // The referent is not cleared in the case of a phantom reference.
	orp_cout << "Phantom Reference has been processed." << endl;
#endif // GC_TRACE_WEAK_REF
    return;
}


// This is executed for all steps and cars at each collection.
//
// We have a list of java.lang.ref.referenece objects. They each have 
// a hidden field pointing to the referent. This field is only accessable 
// via the "get" method. If the referent was in a region that was being
// collected then either it was moved indicating that it is still alive
// or it was not moved indicating that the only references to it are 
// weak references. 
//
// If it was moved (and is alive) then the java.lang.ref.reference is 
//    dequeued from the queue associated with the old location of the object
//    and queued with the new location.
// If it was not moved (is unreachable) then the java.lang.ref.reference 
//    object will be places on the java.lang.ref.ReferenceQueue if on was associated 
//    with it when it was created.
//
//
void
Step_Generation::_update_weak_references(bool doing_mos_collection)
{
#ifndef GC_REWORK
	if (_p_weak_object_list) {
		java_lang_ref_Reference *p_ref_Reference = (java_lang_ref_Reference *)_p_weak_object_list;
		java_lang_ref_Reference *p_next = NULL;
		_p_weak_object_list = NULL; // This is about to be rebuilt.

	    while (p_ref_Reference != NULL) {
			p_next = p_ref_Reference->next;
		    Java_java_lang_Object *p_obj = p_ref_Reference->referent;
 
		    if (p_obj) {			
				Gc_Space *p_gc_space = p_global_bs->p_get_object_container(p_obj);
				if (p_gc_space->is_large_object_space()) {
		            if (is_object_unmarked(p_obj)) {
			            //
				        // An unmarked object in LOS is toast at the end of the
					    // gc cycle. 
						//
						// The object is only reachable via this pointer.
						// enqueue the object if that has been requested. 
						process_weak_reference (p_ref_Reference);
					}
					else {
							//LOS objects that are marked are put back on the _p_weak_ref_object_list;
						gc_register_weak_ref ((JavaObject *)p_ref_Reference, (JavaObject *)(p_get_already_forwarded_object(p_obj)));
					}
	            } else {	
                   
					if (is_object_forwarded(p_obj)) { 
						// gc_register_weak_ref will always add to the front of the list
						// so we won't have to reprocess objects that have been removed and
						// then reregistered with the step_generation.
						gc_register_weak_ref ((JavaObject *)p_ref_Reference, (JavaObject *)(p_get_already_forwarded_object(p_obj)));
					} else { 
						//
                        // The object is only reachable via this this pointer.
						// enqueue the object if that has been requested.
						//
						process_weak_reference (p_ref_Reference); 
                 	}
				}
	        }  else {
				// We have a reference with the referent cleared. We can ignore it.
			} 
			p_ref_Reference = p_next;
		}
	}
#endif
    // Cheney scan since we might have promoted a reference object.
//GC_REWORK...    Generation::execute_pending_cheney_scans(false);
} 

void
Step_Generation::_update_phantom_references(bool doing_mos_collection)
{
#ifndef GC_REWORK
	// loop through all the objects on the list. All the referents have been moved
	// to new cars if they are strongly reachable (still alive). If they aren't 
	// alive then the referents are enqueued. My reading of the spec is that we
	// don't clear the referent even though we can not retrieve the referent. I assume this
	// is done so that the objects that the referent's referents are kept
	// alive so that they can be used.

	if (_p_phantom_object_list) {
		java_lang_ref_Reference *p_ref_Reference = (java_lang_ref_Reference *)_p_phantom_object_list;
		java_lang_ref_Reference *p_next = NULL;

		// Clear _p_phantom_object_list since it will be rebuilt as needed.
		_p_phantom_object_list = NULL;

	    while (p_ref_Reference != NULL) {
		    Java_java_lang_Object *p_obj;
			p_obj = p_ref_Reference->referent;
		    if (p_obj) {			
				Gc_Space *p_gc_space = p_global_bs->p_get_object_container(p_obj);
				if (p_gc_space->is_large_object_space()) {
		            if (is_object_unmarked(p_obj)) {
			            //
				        // An unmarked object in LOS is toast at the end of the
					    // gc cycle. 
						//
						// The object is only reachable via this pointer.
						// enqueue the object if that has been requested. 
						process_phantom_reference (p_ref_Reference);
						// Keep the object alive.

						// Evict the referent, treating the object as if it 
						// was reachable from a root.
						Java_java_lang_Object *temp =
							_p_evict_object_or_update_forwarding(&p_ref_Reference->referent, doing_mos_collection); 

						// gc_register_soft_ref will always add to the front of the list
						// of some other car. These pointers are scanned, not remembered.
						gc_register_phantom_ref ((JavaObject *)p_ref_Reference, (JavaObject *)(p_obj));
					} else { // LOS objects that are marked (alive) are re registered
						gc_register_phantom_ref ((JavaObject *)p_ref_Reference, (JavaObject *)(p_obj));
					}
				} else { // It is not a large object
					if (is_object_forwarded(p_obj)) { // It been moved?
						p_next = p_ref_Reference->next;
						p_ref_Reference->next = NULL;
						// gc_register_weak_ref will always add to the front of the list
						// of some other car.
						gc_register_phantom_ref ((JavaObject *)p_ref_Reference, (JavaObject *)(p_get_already_forwarded_object(p_obj)));
					} else { // Object has died. Save it.
	    				// Assert that p_obj is in this generation
						p_next = p_ref_Reference->next;
						p_ref_Reference->next = NULL;
						// Evict the referent, treating the object as if it 
						// was reachable from a root.
						Java_java_lang_Object *temp =
							_p_evict_object_or_update_forwarding(&p_ref_Reference->referent, doing_mos_collection); 
#if (GC_DEBUG>0)
						assert (temp == p_ref_Reference->referent);
#endif
						//
						// The object is only reachable via this this pointer.
						// enqueue the object if that has been requested.
						//
						process_phantom_reference (p_ref_Reference);

#ifdef GC_TRACE_WEAK_REF
						orp_cout << "Moving phantom object." << endl;
#endif // GC_TRACE_WEAK_REF
					}
               	}
	        } else {
				// How can we have a ref.Reference with out a referent?
				// The application can clear the referent leaving us with a null referent.
				// In this case the ref.Reference object can be removed from the list.
				p_next = p_ref_Reference->next;
				p_ref_Reference->next = NULL; 
			}
			p_ref_Reference = p_next;
		}
	}
    // Cheney scan the spaces that might hold promoted objects.
#endif // not GC_REWORK.
//GC_REWORK... 	Generation::execute_pending_cheney_scans(false);
} 

void
Step_Generation::_update_soft_references(bool low_on_space, bool doing_mos_collection)
{

#ifndef GC_REWORK
    // loop through all the objects on the list. All the referents have been moved
	// if they are strongly reachable (still alive). If they aren't 
	// alive and update_soft_reference we are low on space then the referents are 
	// cleared and enqueued.
	// If we are not low on space then the object is copied to new space
	// and kept alive.

	if (_p_soft_object_list) {
		java_lang_ref_Reference *p_ref_Reference = (java_lang_ref_Reference *)_p_soft_object_list;
		java_lang_ref_Reference *p_next = NULL;

		// Clear _p_soft_object_list since it will be rebuilt as needed.
		_p_soft_object_list = NULL;

	    while (p_ref_Reference != NULL) {
		    Java_java_lang_Object *p_obj;
			p_obj = p_ref_Reference->referent;
		    if (p_obj) {
				if (is_object_forwarded(p_obj)) { // It has been moved.
					p_next = p_ref_Reference->next;
					p_ref_Reference->next = NULL;
					// gc_register_soft_ref will always add to the front of the list
					// of some other car.
					gc_register_soft_ref ((JavaObject *)p_ref_Reference, (JavaObject *)(p_get_already_forwarded_object(p_obj)));
				} else { // Object has died. Kill it if we are low_on_space
	    			// Assert that p_obj is in this generation

					if (low_on_space) {
						p_next = p_ref_Reference->next;
						p_ref_Reference->next = NULL;
						//
				        // The object is only reachable via this this pointer.
						// enqueue the object if that has been requested.
						//
						process_soft_reference (p_ref_Reference);
					} else {
						p_next = p_ref_Reference->next;
						p_ref_Reference->next = NULL;
						// Move the referent to another car, treating the object as if it 
						// was reachable from a root.				
						Java_java_lang_Object *temp =
							_p_evict_object_or_update_forwarding(&p_ref_Reference->referent, doing_mos_collection); 
#if (GC_DEBUG>0)
						assert (temp == p_ref_Reference->referent);
#endif

#ifdef GC_TRACE_WEAK_REF
						orp_cout << "Moving unreachable soft object." << endl;
#endif // GC_TRACE_WEAK_REF
					}
               	}
	        } else {
				// How can we have a ref.Reference with out a referent?
				// The application can clear the referent leaving us with a null referent.
				// In this case the ref.Reference object can be removed from the list.
				p_next = p_ref_Reference->next;
				p_ref_Reference->next = NULL; 
			}

			p_ref_Reference = p_next;
		}
	}
    // Cheney scan the spaces that might hold promoted objects.
#endif
//GC_REWORK... 	Generation::execute_pending_cheney_scans(false);
} 
#endif 
// end file step_generation.cpp
