// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/gc_header_format.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//



#ifndef _gc_header_format_H_
#define _gc_header_format_H_

//
// The information on the Gc Header.
//

#include "platform.h"
#include "orp_types.h"    
#include "object_layout.h"
//#include "remembered_set.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef POINTER64
#define FREE_BLOCK_HEADER 0xADDEADDEADDEADDE
#define UNIQUE_HEADER_PATTERN 0xDAEDECAFDAEDECAF
#else
#define FREE_BLOCK_HEADER 0xADDEADDE
#define UNIQUE_HEADER_PATTERN 0xDAEDECAF
#endif



// Layout of the GC header word

#define UNCONTESTED_HEADER_VALUE                0
#define BUSY_FORWARDING_BIT                     0x0000000000000001
#define BUSY_FORWARDING_BIT_OFFSET              0
#ifdef POINTER64
#define BUSY_FORWARDING_BIT_MASK                0xFFFFffffFFFFfffe
#else
#define BUSY_FORWARDING_BIT_MASK                0xFFFFfffe
#endif

#ifdef __cplusplus
}
#endif

#endif // \include\gc_header_format.h

