// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/ini.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

//
// ORP Internal Native Interface
//



#ifndef _INI_H_
#define _INI_H_

#include "orp_types.h"
#include "root_set_enum.h"


//////////////////////////////////////////////////////////////////////
// begin invoking Java methods from native code


typedef union {
    J_Boolean   z;
    J_Byte      b;
    J_Char      c;
    J_Short     s;
    J_Int       i;
    J_Long      j;
    J_Float     f;
    J_Double    d;
    J_Reference r;
} J_Value;


void
orp_execute_java_method_array(Method   *meth,
                              void     *return_value,
                              J_Value   args[]);

void
orp_execute_java_method_array_rethrow(Method   *meth,
                                      void     *return_value,
                                      J_Value   args[]);

ORPExport void
orp_execute_java_method(Method *meth, void *return_value, ...);

// end invoking Java methods from native code
//////////////////////////////////////////////////////////////////////



ORPExport Method *object_lookup_method(void *obj,
                                       const char *name,
                                       const char *descr);




//////////////////////////////////////////////////////////////////////
// GC-protect arguments to a Java method.

void
orp_pop_gc_frames1(Method *meth,
                   uint32 *args,
                   GC_Frame *gc_frames
                   );

void
orp_push_gc_frames1(Method *meth,
                    unsigned num_arg_words,
                    uint32 *args,
                    GC_Frame *gc_frames
                    );


#endif
