// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/orp_utils.h,v 1.12 2001/12/19 09:35:11 gwu2 Exp $
//




#ifndef _ORP_UTILS_H_
#define _ORP_UTILS_H_


#include "String_Pool.h"
#include "Class.h"
#include "object_layout.h"
#include "orp_threads.h"


unsigned get_utf8_length_of_unicode(const uint16 *str, unsigned unicode_length);
unsigned get_unicode_length_of_utf8(const char *utf8);
void pack_utf8(char *utf8_string, const uint16 *unicode, unsigned unicode_length);
void unpack_utf8(uint16 *unicode, const char *utf8);

#ifdef USE_GC_DLL
__declspec(dllexport)
#endif
unsigned orp_array_size(Class *vector_class, int length);

JavaArrayOfChar *create_array_of_chars(int length);
JavaArrayOfChar *create_array_of_chars_from_C_string(const char *str);

ORPExport Java_java_lang_String *create_java_lang_String_from_C_string(const char *str);

ORPExport Java_java_lang_String *orp_instantiate_cp_string_resolved(String *str);
JavaArrayOfObject *orp_anewarray_resolved_array_type(Class *arr_clss, int length);
JavaArray *orp_multianewarray_resolved(Class *cc, unsigned dims, ...);

Java_java_lang_Object *class_alloc_new_object_and_run_default_constructor(Class *clss);
Java_java_lang_Object *class_alloc_new_object_and_run_constructor(Class *clss,
                                                                  Method *constructor,
                                                                  uint8 *constructor_args);

JavaArray *orp_pinned_java_array(Java_Type elem_type, int length);
Java_java_lang_Object *orp_pinned_java_object(Class *c);


unsigned sizeof_java_lang_class();


class Global_Env;

class ORP_Global_State {
public:
    ORPExport static Global_Env *loader_env;
}; //ORP_Global_State


extern const struct JNIEnv_ *jni_native_intf;


ORPExport void orp_exit(int exit_code);


////////////////////////////////////////////////////////////////////////////
// Runtime support functions exported directly, because they may be called
// from native code.
////////////////////////////////////////////////////////////////////////////

ORPExport JavaArrayOfObject *orp_anewarray_resolved(Class *cc, int length);
ORPExport JavaArray *orp_newarray(unsigned atype, int length);
JavaArray *orp_new_array_from_class(Class *clss, int length);
ORP_Vector *orp_new_vector(Class *arr_clss, int length);

// The coexistence of those two functions is temporary.  Eventually only
// one of them will remain.
ORPExport Boolean orp_instanceof_class(Class *s, Class *t);
ORPExport void *getaddress__orp_instanceof_class();


#if (GC_DEBUG>0)
void __stdcall orp_dump_object_and_return_ip(void *obj, void *eip);
#endif


JavaArrayOfString *orp_create_array_of_strings(char **p_str, int length);

//:M
ORPExport ORP_thread *get_p_TLS_orpthread();


// These two critical section helper fucntions are for conveniently use of 
// criticalsection, but by now only used in InetAddress for thread safety
class CriticalSection
{
public:
	CriticalSection(){
		InitializeCriticalSection(&m_cs);
	}
	~CriticalSection(){
		DeleteCriticalSection(&m_cs);
	}
	void lock(){
		EnterCriticalSection(&m_cs);
	}
	void unlock(){
		LeaveCriticalSection(&m_cs);
	}
	operator LPCRITICAL_SECTION(){
		return &m_cs;
	}
private:
	CRITICAL_SECTION m_cs;
};

class CriticalSectionHelper
{
public:
	CriticalSectionHelper(LPCRITICAL_SECTION pcs):m_pcs(pcs){
		EnterCriticalSection(m_pcs);
	}
	~CriticalSectionHelper(){
		LeaveCriticalSection(m_pcs);
	}
private:
	LPCRITICAL_SECTION m_pcs;
};

class ExpandableMemBlock
{
public:
	ExpandableMemBlock(long nBlockLen = 2000, long nInc = 1000)
			: m_nBlockLen(nBlockLen), m_nCurPos(0), m_nInc(nInc){
		assert(nInc > 0);
		m_pBlock = malloc(m_nBlockLen);
		assert(m_pBlock);
	}
	~ExpandableMemBlock(){
		if(m_pBlock)
			free(m_pBlock);
	}
	void AppendBlock(char *szBlock, long nLen = -1){
		if(!szBlock)return;
		if(nLen <= 0)nLen = strlen(szBlock);
        if(!nLen)return;
		long nOweSpace = (m_nCurPos + nLen) - m_nBlockLen;
        if(nOweSpace >= 0){ //change > 0 to >= 0, prevents assert in free(m_pBlock)
			m_nBlockLen += (nOweSpace / m_nInc + 1)*m_nInc;
			m_pBlock = realloc(m_pBlock, m_nBlockLen);
			assert(m_pBlock);
		}
		memmove((char*)m_pBlock + m_nCurPos, szBlock, nLen);
		m_nCurPos += nLen;
	}
	void AppendFormatBlock(char *szfmt, ... ){
		va_list arg;
		//char *buf = (char*)calloc(1024, 1);
		char buf[1024];
		va_start( arg, szfmt );
		vsprintf(buf, szfmt, arg );
		va_end( arg );
		AppendBlock(buf);
		//free(buf);
	}
	void SetIncrement(long nInc){
		assert(nInc > 0);
		m_nInc = nInc;
	}
	void SetCurrentPos(long nPos){
		assert((nPos >= 0) && (nPos < m_nBlockLen));
		m_nCurPos = nPos;
	}
	long GetCurrentPos(){
		return m_nCurPos;
	}
	const void *AccessBlock(){
		return m_pBlock;
	}
    const char *toString(){
        *((char*)m_pBlock + m_nCurPos) = '\0';
        return (const char*)m_pBlock;
    }
    void EnsureCapacity(long capacity){
		long nOweSpace = capacity - m_nBlockLen;
        if(nOweSpace >= 0){ //change > 0 to >= 0, prevents assert in free(m_pBlock)
			m_nBlockLen += (nOweSpace / m_nInc + 1)*m_nInc;
			m_pBlock = realloc(m_pBlock, m_nBlockLen);
			assert(m_pBlock);
		}
	}
	void CopyTo(ExpandableMemBlock &mb, long len = -1){
		if(len == -1)
			len = m_nBlockLen;
		mb.SetCurrentPos(0);
		mb.AppendBlock((char*)m_pBlock, len);
	}
protected:
	void *m_pBlock;
	long m_nBlockLen;
	long m_nCurPos;
	long m_nInc;
};

#endif


