// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/jit_utils/include/Dlink.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//



#ifndef _DLINK_H
#define _DLINK_H

class Dlink {
public:
    Dlink() {_next = _prev = this;}
    //
    // routines for manipulating double linked list
    //
    void unlink(){_prev->_next=_next;_next->_prev=_prev;_next=_prev=this;}
    // insert "this" after "prev_link"
    void insert_after(Dlink *prev_link) {
        _prev = prev_link;
        _next = prev_link->_next;
        prev_link->_next = this;
        _next->_prev = this;
    }
    void insert_before(Dlink *next_link) {
        _next = next_link;
        _prev = next_link->_prev;
        next_link->_prev = this;
        _prev->_next = this;
    }
    // move all elements in the list except for this one
    // into another list
    void move_to(Dlink *head) {
        if (_prev == this) 
            return;
        _next->_prev = head->_prev;
        _prev->_next = head;
        head->_prev->_next = _next;
        head->_prev = _prev;
        _prev=_next=this;
    }
    Dlink *get_next() {return _next;}
    Dlink *get_prev() {return _prev;}
protected:
    Dlink *_next, *_prev;
};

#endif // _DLINK_H
