// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/jit_utils/include/mtable.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//



#ifndef _MTABLE_H
#define _MTABLE_H

#include "jit_intf.h"  // for things relating to Method_Handle

class O3_Method_Table
{
public:
    O3_Method_Table(const char *default_envvar, const char *envvarname, bool accept_by_default);
    ~O3_Method_Table() {}
    bool accept_this_method(Method_Handle mh);
    enum Decision
    {
        mt_rejected,
        mt_undecided,
        mt_accepted
    };
    struct method_record
    {
        char *class_name;
        char *method_name;
        char *signature;
        Decision decision;
    };

    
private:
    struct method_record *_method_table;
    int _mrec_size, _mrec_capacity;
    struct method_record *_decision_table;
    int _dtable_size, _dtable_capacity;
    Decision _default_decision;
    bool _accept_all;
    bool _dump_to_file;
    char *_method_file;
    bool _accept_by_default;
    CRITICAL_SECTION _file_lock;

    void init(const char *default_envvar, const char *envvarname);
    void make_filename(char *str, int len);
    bool read_method_table();
};

#endif _MTABLE_H
