// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/interface/internal_jit_intf.h,v 1.2 2001/07/25 03:02:28 xli18 Exp $
//


#ifndef _INTERNAL_JIT_INTF_H_
#define _INTERNAL_JIT_INTF_H_
#include "orp_types.h"

ORPExport void *get_addr_of_read_counter(Field_Handle f);
ORPExport void *get_addr_of_write_counter(Field_Handle f);

class JIT;
//
// static variables that are set by ORP
// JITs needs them to generate code
//
extern ORPExport bool jvmdi_support;
extern ORPExport bool recompilation_thread;// indicate if we use a separate for recompilation
extern ORPExport bool jvmdi_support;
extern ORPExport bool collect_hotfield_stats;
extern ORPExport bool split_object_fields_randomly;
extern ORPExport bool instrumenting;
extern ORPExport JIT  *o1_jit;
extern ORPExport JIT  *o3_jit;

ORPExport JIT_Result method_recompile(Method_Handle m, JIT_Handle j);
ORPExport char *gen_setup_j2n_frame(char *s);
ORPExport char *gen_pop_j2n_frame(char *s);

ORPExport char *dis_bc(const Byte    *bc_start,
                       unsigned      *bc_ip,
                       char          *buf,
                       Method_Handle jm);

ORPExport char *x86_disasm(char *x86_code, 
                           char *ascii_buf,
                           bool addr_and_bytes, 
                           bool instructions);

#endif // _INTERNAL_JIT_INTF_H_

