/*
 *	MMU.h
 */

#include <stdio.h>
#include <setjmp.h>

#ifdef __THINK__
/*
 *	This was the state in 5.0; newer versions may have fixed this problem
 */
#include <gestaltEqu.h>
#endif

typedef unsigned long	u32;
typedef void (*CacheEmitterFuncPtr) (u32 attributes);
#define MAX_MAPPINGS		100
#define NOT_MAPPED		(0xFFFFFFFFUL)
enum
{
	MMU_CACHE_CODE		= 1,
	MMU_DATA,
	MMU_IO
};

struct Log2Phys
{
	u32	 logical;
	u32	 physical;
	u32	 length;
	u32	 attr;
};
typedef struct Log2Phys Log2Phys;

struct MemoryMappings
{
	u32			 index;
	CacheEmitterFuncPtr	 cacheEmitter; 
	Log2Phys		 log2phys[MAX_MAPPINGS];
};
typedef struct MemoryMappings MemoryMappings;

struct MemoryReads
{
	u32		 addr;
	u32		 data;
	unsigned char /* Boolean */table;
};
typedef struct MemoryReads MemoryReads;

struct MemoryReadHdr
{
	u32		 numReads;
	u32		 maxReads;
	u32		 minAddr;
	u32		 maxAddr;
	MemoryReads	*data;
};
typedef struct MemoryReadHdr MemoryReadHdr;


/* MMU030.c */
void			init030Mmu (void);
int				isCpu030 (void);
void			calculate030MmuMappings (void);

/* MMU040.c */
void			init040Mmu (void);
int				isCpu040 (void);
void			calculate040MmuMappings (void);

/* mmu_support.c */
void			Unsupported (char *);
void			UnsupportedNum (char *, unsigned long n);
void			Error (char *);
void			ErrorNum (char *, unsigned long n);
void			ErrorNumNum (char *, unsigned long n1, unsigned long n2);
unsigned long	findLogicalAddrSize (void);
void			printLog2PhysTable (void);
void			findRAM (u32 *num_memory, struct mem_info *memory);
void			check020_kernel_pos (u32 num_memory, struct mem_info *memory);
unsigned long	LogicalToPhysical (unsigned long logAddr);
unsigned long	PhysicalToLogical (unsigned long physAddr);
void			addReadData (void *addr, u32 data);
void			tableReadData (void *addr);

/* MMUmappings.c */
extern MemoryMappings	gMemoryMappings;
void					recordMemoryMapping (u32 logAddr, u32 physAddr, u32 length, u32 attr);

#ifdef __MWERKS__
#define ASMFUNC(funcname, param1)			\
		asm 					\
		funcname (param1)			
#define ASMFUNC2(funcname, param1, param2)		\
		asm 					\
		funcname (param1, param2)			
#define BEGINASM					\
		fralloc					
#define ENDASM						\
		frfree ;				\
		rts					
#endif


#ifdef __THINK__
#define ASMFUNC(funcname, param1)			\
		funcname (param1)			\
		{					\
				asm			
#define ASMFUNC2(funcname, param1, param2)		\
		funcname (param1, param2)		\
		{					\
				asm			
#define BEGINASM					\
		/* empty */				
#define ENDASM						\
			}				
#endif


