"[[.ggobi" <-
#
# Extracts a subset of the data in the specified
# ggobi
#
# Example:
#  g <- ggobi(mtcars)
#  g[[1]][1:20,]
#   .... # make selections
#  setMode.ggobi("brush")     # or programmatically
#  setBrushSize.ggobi(300,300)
#  g[[1]][isObservationSelected.ggobi(g),]
#
function(x, ...,drop=FALSE)
{
  idx = sapply(list(...), function(x) 
                            if(mode(x) == "numeric") 
                              as.integer(x)
                            else
                              as.character(x)
              )

  if(is.list(idx))
    stop("incorrect type for indexing a GGobi dataset")

  if(length(idx) != 1)
    stop("only one element allowed")

  v <- getDatasetReference.ggobi(idx, .gobi = x, simplify = FALSE)[[1]]

  if(length(v) == 0)
    stop("No such dataset in this ggobi instance.")

   # Mmm. This shouldn't occur anymore.
  if(!inherits(v, "ggobiDataset") && is.list(v)) 
    stop("attempt to select more than one GGobi dataset")

   v
}

"[.ggobi" <-
# This should be fixed up to return a list at all times
# and not a dataset or a list of datasets.
function(x, ...,drop=FALSE)
{
  getDatasetReference.ggobi(sapply(list(...), function(x) 
                                     if(mode(x) == "numeric") 
                                       as.integer(x)
                                     else
                                       as.character(x)
                                  ), .gobi = x, simplify = FALSE)

}


"[<-.ggobiDataset" <-
function(x, i, j, value)
{
 tmp <- x
 x <- getData.ggobi(.data=x)

  x <- do.call("[<-",list(x,i,j,value))
  idx <- 1:nrow(x)
  for(i in 1:ncol(x)) {
    setVariableValues.ggobi(x[,i], i, idx, .data = tmp)
  }
 tmp
}


"[[<-.ggobiDataset" <-
function(x, i, j, value)
{
  if(is.character(j))
    vars <- getVariableIndex.ggobi(j, .data=x)
  else
    vars <- j

  val <- rep(value, length = length(i))
  for(v in vars) {
    setVariableValues.ggobi(val, v, i, .data = x)
  } 

  x
}

"[.ggobiDataset" <-
#
# Allows the internal dataset to be
# subsetted as if it were local.
# Actually, this currently pulls the entire dataset
# across into R and then subsets. This can be made
# more intelligent if needed.
function(x, ..., drop=FALSE)
{
 x <- getData.ggobi(.data = x)
 NextMethod("[", getData.ggobi(.data = x))
 
# NextMethod("[", x, ..., drop = drop)
}


getRecordIds =
function(.data = 1, .gobi = getDefaultGGobi())
{
  df = getDatasetReference(.data, .gobi)  
  .GGobiCall("getDatasetRecordIds", df, .gobi = .gobi)
}  

getData.ggobi <-
function(.data = 1, .gobi = getDefaultGGobi())
{
  df = getDatasetReference(.data, .gobi)
 
  ans = as.data.frame(.GGobiCall("getData", df, .gobi=.gobi))

   # Ensure unique record names if there are any.
   # Get the record ids. If these aren't present,
   # look in the rownames and ensure that they
   # are unique.
  tmp = getRecordIds(df)
  if(length(tmp) == 0) {
    tmp = rownames(df)
    if(length(unique(tmp)) != length(tmp))
      tmp = NULL
  }

  if(length(tmp))
    rownames(ans) = tmp

  ans
}

nrow.ggobiDataset <-
function(d)
{
 dim(d)[1]
}

ncol.ggobiDataset <-
function(d)
{
 dim(d)[1]
}

names.ggobiDataset <-
function(x)
{
 getVariableNames.ggobi(FALSE, x, .gobi = x[["ggobi"]])
}

dimnames.ggobiDataset <-
function(d)
{
  list(getRowNames.ggobi(d, .gobi=d[["ggobi"]]), names(d))
}

dim.ggobiDataset <-
#
# Gets the dimensions of the specified dataset reference.
#  
function(d)
{
  .Call(.ggobi.symbol("datasetDim"), d, PACKAGE = "Rggobi")  # d[["data"]])
}


names.ggobi <-
function(x)
{
 getDatasetNames.ggobi(x)
#  getVariableNames.ggobi(.gobi=x)
}


if(FALSE) {

  dim.ggobi <-
  function(x) {
     d <- getDescription.ggobi(.gobi = x)
     d[[3]]
  }

  nrow.ggobi <-
  function(x) {
    dim(x)[1]
  }

  ncol.ggobi <-
  function(x) {
    dim(x)[1]
  }

  dimnames.ggobi <-
  function(x)  {
    list (getRowNames.ggobi(.gobi=x), names(x))
  }

  "[<-.ggobi" <-
  function(x, ...,drop=FALSE)  {
    g <- getData.ggobi(.gobi=x)
    UseMethod("[",...)
  }

}
