/*
  R & S routines for retrieving the current settings
 */

#include "RSGGobi.h"

#include <gtk/gtk.h>

#include "vars.h"

#include "RUtils.h"


/*
  Returns the names of the datasets within the specified
  ggobid object.
 */
USER_OBJECT_
RS_GGOBI(getDatasetNames)(USER_OBJECT_ gobiId)
{
  USER_OBJECT_ ans;
  ggobid *gg = GetGGobi(gobiId);  
  int i;
  datad *d;
  GSList *tmp = gg->d;
  int n = g_slist_length(gg->d);

  PROTECT(ans = NEW_CHARACTER(n));
  for(i = 0; i < n ; i++) {
    d =(datad *) tmp->data;
    SET_STRING_ELT(ans, i, COPY_TO_USER_STRING(d->name));
    tmp = tmp->next;
  }

  UNPROTECT(1);
  return(ans);
}


USER_OBJECT_
RS_GGOBI(getVariableNames)(USER_OBJECT_ transformed, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  datad *d = NULL;

  d = resolveDatad(datasetId, ggobiId, NULL);

  if(d)
    return(RS_INTERNAL_GGOBI(getVariableNames)(d));
  else
    return(NULL_USER_OBJECT);
}

USER_OBJECT_
RS_INTERNAL_GGOBI(getVariableNames)(datad *d)
{
  USER_OBJECT_ ans;
  gint n, i;
  vartabled *vt;

  n =  d->ncols;
  PROTECT(ans = NEW_CHARACTER(n));

  for (i = 0; i < n ; i++) {
    vt = vartable_element_get(i, d);
    SET_STRING_ELT(ans, i, COPY_TO_USER_STRING(vt->collab));
  }

  UNPROTECT(1);

  return(ans);
}


USER_OBJECT_
createFactor(USER_OBJECT_ vals, vartabled *vt, datad *d, int which)
{
  USER_OBJECT_ labels, levels, ans, e;
  int i;

  PROTECT(levels = NEW_INTEGER(vt->nlevels));
  PROTECT(labels = NEW_CHARACTER(vt->nlevels));
  for(i = 0; i < vt->nlevels; i++) {
     INTEGER_DATA(levels)[i] = vt->level_values[i];
     SET_STRING_ELT(labels, i, COPY_TO_USER_STRING(vt->level_names[i]));
  }

  PROTECT(e = allocVector(LANGSXP, 4));
  SETCAR(e, Rf_install("factor"));
  SETCAR(CDR(e), vals);
  SETCAR(CDR(CDR(e)), levels);
  SETCAR(CDR(CDR(CDR(e))), labels);

  ans = eval(e, R_GlobalEnv);

  UNPROTECT(3);
 
  return(ans);
}

#if 0
USER_OBJECT_
RS_GGOBI(getData)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
 datad *d;
 USER_OBJECT_ ans, rownames, colnames, dims;
 gint nr, nc;
 gint i, j;
 vartabled *vt;

 d = resolveDatad(datasetId, ggobiId, NULL);
 if(d) {

   nr = d->nrows;
   nc = d->ncols;
 
   if(nr == 0 || nc == 0)
       return(NULL_USER_OBJECT);

    PROTECT(ans = allocMatrix(REALSXP, nr, nc));
    PROTECT(dims = NEW_LIST(2));
   
    PROTECT(rownames = NEW_CHARACTER(nr));
    PROTECT(colnames = NEW_CHARACTER(nc));
    SET_VECTOR_ELT(dims, 0, rownames);
    SET_VECTOR_ELT(dims, 1, colnames);
   
    for (i =0; i < nr; i++) {
      SET_STRING_ELT(rownames, i, 
   	COPY_TO_USER_STRING ((gchar *) g_array_index (d->rowlab, gchar *, i)));
   
      for (j =0; j < nc; j++) {
   	if (i == 0) {
          vt = vartable_element_get(j, d);
   	  SET_STRING_ELT(colnames, j, COPY_TO_USER_STRING(vt->collab));
   	}
        if(d->missing.vals && d->missing.vals[i][j])
  	   NUMERIC_DATA(ans)[i + j*nr] = NA_REAL;
        else
      	   NUMERIC_DATA(ans)[i + j*nr] = d->raw.vals[i][j];
      }
    }
     
    SET_DIMNAMES(ans, dims);
   
    UNPROTECT(4);
 } else
   ans = NULL_USER_OBJECT;

 return (ans);
}
#else
USER_OBJECT_
RS_GGOBI(getData)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
 datad *d;
 USER_OBJECT_ ans, colnames, el;
 gint nr, nc;
 gint i, j, m;
 vartabled *vt;

 ans = NULL_USER_OBJECT;

 d = resolveDatad(datasetId, ggobiId, NULL);

 if(d) {
   nr = d->nrows_in_plot;
   nc = d->ncols;
 
   if(nr == 0 || nc == 0)
       return(NULL_USER_OBJECT);

#if 0
   PROTECT(rownames = NEW_CHARACTER(nr));
#endif
   PROTECT(colnames = NEW_CHARACTER(nc));

   PROTECT(ans = NEW_LIST(nc));

   for(j = 0; j < nc; j++) {
      vt = vartable_element_get(j, d);
      SET_STRING_ELT(colnames, j, COPY_TO_USER_STRING(vt->collab));

      PROTECT(el= NEW_NUMERIC(nr));
      for (m = 0; m < nr; m++) {
	i = d->rows_in_plot.els[m];
        if(d->missing.vals && d->missing.vals[i][j])
  	   NUMERIC_DATA(el)[m] = NA_REAL;
        else
      	   NUMERIC_DATA(el)[m] = d->raw.vals[i][j];
      }
      if(vt->vartype == categorical) {
        PROTECT(el = createFactor(el, vt, d, j));
      }
      SET_VECTOR_ELT(ans, j, el);
      UNPROTECT(1 + (vt->vartype == categorical));
   }

#if 0
   for (m =0; m < nr; m++) {
     i = d->rows_in_plot.els[m];
      SET_STRING_ELT(rownames, m, 
   	COPY_TO_USER_STRING ((gchar *) g_array_index (d->rowlab, gchar *, i)));

   }
   SET_ATTRIB(ans, R_RowNamesSymbol, rownames);

#endif
   SET_NAMES(ans, colnames);

   UNPROTECT(2);
 }
   return(ans);
}
#endif

USER_OBJECT_
RS_GGOBI(getDatasetRecordIds)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
 datad *d;
 USER_OBJECT_ ans;
 int i, n, m;

 d = resolveDatad(datasetId, ggobiId, NULL);

 if(!d) {
  PROBLEM "No such dataset"
  ERROR;
 }

 if(!d->rowIds) {
    return(NULL_USER_OBJECT);
 }


 n = d->nrows_in_plot;

 PROTECT(ans = NEW_CHARACTER(n));
 for(m = 0; m < n ; m++) {
   i = d->rows_in_plot.els[m];
    if(d->rowIds[i])
     SET_STRING_ELT(ans, m, COPY_TO_USER_STRING(d->rowIds[i]));
 }

 UNPROTECT(1);

 return(ans);
}





USER_OBJECT_
RS_GGOBI(getSelectedIndices)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
 datad *d;
 USER_OBJECT_ ans, names;

  d = resolveDatad(datasetId, ggobiId, NULL);
  if(d) {
    gint nr, i, m, ctr;
   gchar *name;
       nr = d->npts_under_brush;
       
       if (nr < 1)
      	 return(NULL_USER_OBJECT);
      	
       PROTECT(ans = NEW_INTEGER(nr));
       PROTECT(names = NEW_CHARACTER(nr));
       ctr = 0;
       for(m = 0 ; m < d->nrows ; m++) {
         i = d->rows_in_plot.els[m];
      	 if (d->pts_under_brush.els[i]) {
           INTEGER_DATA(ans)[ctr] = i + 1; /* Make these 1 based */
           name = (gchar *) g_array_index (d->rowlab, gchar *, i);
           if(name && name[0]) 
             SET_STRING_ELT(names, ctr, COPY_TO_USER_STRING (name));
           ctr++;
      	 }
       }
       
       SET_NAMES(ans, names);
       UNPROTECT(2);
   } else 
     ans = NULL_USER_OBJECT;

 return (ans);
}

USER_OBJECT_
RS_GGOBI(getRowNames)(USER_OBJECT_ data, USER_OBJECT_ ggobiId)
{
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  gint nr, i, m;
  datad *d;
  if(R_IS(data, "ggobiDataset") || R_IS(data, "GtkGGobiData")) {
    d = GetDatad(data);
  } else if(IS_INTEGER(data)) {
    ggobid *gg = GetGGobi(ggobiId);
    if(gg) {
      d = (datad *) g_slist_nth_data (gg->d, INTEGER_DATA(data)[0]);
    }
  }

  if(d) {
    nr = d->nrows_in_plot;
    PROTECT(ans = NEW_CHARACTER(nr));

    for (m = 0 ; m < nr ; m++) {
      i = d->rows_in_plot.els[m];
      SET_STRING_ELT(ans, m,
      COPY_TO_USER_STRING ((gchar *) g_array_index (d->rowlab, gchar *, i)));
    }
    UNPROTECT(1);
  }

  return (ans);
}

USER_OBJECT_
RS_GGOBI(getRowColors)(USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);
  datad *d;
  USER_OBJECT_ ans;
  gint nr, i, m;

  if (g_slist_length (gg->d) == 1)
    d = (datad *) g_slist_nth_data (gg->d, 0);
  nr = d->nrows_in_plot;

  PROTECT(ans = NEW_INTEGER(nr));

  for (m = 0; m < nr ; m++) {
    i = d->rows_in_plot.els[i];
    INTEGER_DATA(ans)[m] = d->color_now.els[i];
  }

  UNPROTECT(1);

  return (ans);
}


USER_OBJECT_
RS_GGOBI(getSelectedVariables)(USER_OBJECT_ ggobiId)
{
  /*ggobid *gg = GetGGobi(ggobiId);*/
  USER_OBJECT_ ans, names;
  gint numVars; /* Depends on the type of plot currently active. */
  gint i;

  numVars = 1;

  PROTECT(ans = NEW_CHARACTER(numVars));
  PROTECT(names = NEW_CHARACTER(numVars));

  for (i = 0; i < numVars; i++) {

  }

  UNPROTECT(2);

  return (ans);
}


USER_OBJECT_
RS_GGOBI(getSymbolicEdges)(USER_OBJECT_ edgesetId, USER_OBJECT_ ggobiId)
{
 datad *e = resolveDatad(edgesetId, ggobiId, NULL);
 USER_OBJECT_ ans, dim;
 gint i, ctr, n;

 n = e->edge.n;

 if(!e) {
   PROBLEM "Invalid ggobi dataset identifier(s)"
   ERROR;
 }

 PROTECT(ans = NEW_CHARACTER(n * 2));

 ctr = 0;
 for(i = 0; i < n; i++) {
   SET_STRING_ELT(ans, ctr, COPY_TO_USER_STRING(e->edge.sym_endpoints[i].a));
   SET_STRING_ELT(ans, ctr+n, COPY_TO_USER_STRING(e->edge.sym_endpoints[i].b));
   ctr++;
 }

 /* Now set the dim() on this vector to make it a matrix. 
    The S code will put the dimnames on it.
  */
 PROTECT(dim = NEW_INTEGER(2));
  INTEGER_DATA(dim)[0] = n;
  INTEGER_DATA(dim)[1] = 2;
  SET_DIM(ans, dim);
 UNPROTECT(2);

 return(ans); 
}


USER_OBJECT_
RS_GGOBI(getConnectedEdges)(USER_OBJECT_ edgesetId, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
 datad *d = resolveDatad(datasetId, ggobiId, NULL);
 datad *e = resolveDatad(edgesetId, ggobiId, NULL);
 gint ctr; 
 USER_OBJECT_ ans, dim;
 gint i, n;
 endpointsd *endpoints;

 if(!d || !e) {
   PROBLEM "Invalid ggobi dataset identifier(s)"
   ERROR;
 }

 n = e->edge.n;

 endpoints = resolveEdgePoints(e, d);
 if(!endpoints) 
    return(NULL_USER_OBJECT);

 PROTECT(ans = NEW_INTEGER(n * 2));

 ctr = 0;
 for(i = 0; i < n; i++) {
   INTEGER_DATA(ans)[ctr] = endpoints[i].a;  
   INTEGER_DATA(ans)[ctr+n] = endpoints[i].b; 
   ctr++;
 }

 /* Now set the dim() on this vector to make it a matrix. 
    The S code will put the dimnames on it.
  */
 PROTECT(dim = NEW_INTEGER(2));
  INTEGER_DATA(dim)[0] = n;
  INTEGER_DATA(dim)[1] = 2;
  SET_DIM(ans, dim);
 UNPROTECT(2);

 return(ans);
}


USER_OBJECT_
RS_GGOBI(getRowsInPlot)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  datad *d;
 
  d = resolveDatad(datasetId, ggobiId, NULL);

  if(d) {
    gint i;

    PROTECT(ans = NEW_INTEGER(d->nrows_in_plot));

    for(i = 0; i < d->nrows_in_plot ; i++) {
      INTEGER_DATA(ans)[i] = d->rows_in_plot.els[i];
    }

    UNPROTECT(1);
  }

  return (ans);
}


USER_OBJECT_
RS_GGOBI(getDataAttribute)(vector_b v)
{
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  datad *d;
 
  if(d) {
    gint i;
    PROTECT(ans = NEW_LOGICAL(v.nels));

    for(i = 0; i < v.nels; i++) {
       LOGICAL_DATA(ans)[i] = v.els[i];
    }

    UNPROTECT(1);
  }

  return (ans);
}


void
RS_GGOBI(setDataAttribute)(vector_b *v, USER_OBJECT_ vals, datad *d)
{
  USER_OBJECT_ ans = NULL_USER_OBJECT;
 
  if(v) {
    gint i, n;
    n = GET_LENGTH(vals);
    if(n != d->nrows) {
	 PROBLEM "number of values must be the same as the number of records in the GGobi dataset"
	 ERROR;
    }
    vectorb_realloc(v, n);
    for(i = 0; i < n; i++) {
       v->els[i] = LOGICAL_DATA(ans)[i];
    }
  }
}


USER_OBJECT_
RS_GGOBI(getSampledIndices)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  datad *d = resolveDatad(datasetId, ggobiId, NULL);
  return(RS_GGOBI(getDataAttribute)(d->sampled));
}

USER_OBJECT_
RS_GGOBI(setSampledIndices)(USER_OBJECT_ vals, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  datad *d = resolveDatad(datasetId, ggobiId, NULL);
  RS_GGOBI(setDataAttribute)(&(d->sampled), vals, d);
  rows_in_plot_set(d, d->gg);
  return(NULL_USER_OBJECT);
}

USER_OBJECT_
RS_GGOBI(getExcludedIndices)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  datad *d = resolveDatad(datasetId, ggobiId, NULL);
  return(RS_GGOBI(getDataAttribute)(d->excluded));
}

USER_OBJECT_
RS_GGOBI(setExcludedIndices)(USER_OBJECT_ vals, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  datad *d = resolveDatad(datasetId, ggobiId, NULL);
  RS_GGOBI(setDataAttribute)(&(d->excluded), vals, d);
  rows_in_plot_set(d, d->gg);
  return(NULL_USER_OBJECT);
}





USER_OBJECT_
RS_GGOBI(setMode)(USER_OBJECT_ name, USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);
  if(gg) {
    GGOBI(setMode)((const gchar *) CHAR_DEREF(STRING_ELT(name,0)), gg);
    /* Trying to get the main window updated so that the changes to the control
       panel are visible without having to move the mouse into the window to generate
       another event. */
    gtk_widget_queue_draw(gg->main_window);
    gtk_widget_queue_draw(gg->control_panel[IDENT]);
/*    gtk_widget_draw(gg->main_window); */
  }
  
  gdk_flush();

  return(NULL_USER_OBJECT);
}

USER_OBJECT_
RS_GGOBI(getModeName)(USER_OBJECT_ ggobiId)
{
  USER_OBJECT_ ans;
  const gchar *tmp;
  ggobid *gg = GetGGobi(ggobiId);
  tmp = GGOBI(getModeName)(viewmode_get(gg));

  PROTECT(ans = NEW_CHARACTER(1));
  if(tmp && tmp[0])
    SET_STRING_ELT(ans, 0, COPY_TO_USER_STRING(tmp));
  UNPROTECT(1);
  return(ans);
}

USER_OBJECT_
RS_GGOBI(setBrushColor)(USER_OBJECT_ cid, USER_OBJECT_ ggobiId)
{
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  ggobid *gg = GetGGobi(ggobiId);
  if(gg) {
   ans = RS_GGOBI(getBrushColor)(ggobiId);
   (void) GGOBI(setBrushColor)(INTEGER_DATA(cid)[0], gg);
   brush_reset(gg, 0);
   gdk_flush();
  }

 return(ans);
}

USER_OBJECT_
RS_GGOBI(getBrushColor)(USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);
  if(gg) {
    USER_OBJECT_ ans;
    gint cid;

     cid =  GGOBI(getBrushColor)(gg);
     PROTECT(ans = NEW_INTEGER(1));
     INTEGER_DATA(ans)[0] = cid;
     SET_NAMES(ans, RS_INTERNAL_GGOBI(getColorName)(cid, gg));
     UNPROTECT(1);
    return(ans);
  } else
    return(NULL);
}

USER_OBJECT_
RS_INTERNAL_GGOBI(getColorName)(gint cid, ggobid *gg)
{
  USER_OBJECT_ name;
  const gchar *colName;
    PROTECT(name = NEW_CHARACTER(1));
    colName = GGOBI(getColorName)(cid, gg, false);
    if(colName)
      SET_STRING_ELT(name, 0, COPY_TO_USER_STRING(colName));
    UNPROTECT(1);
  return(name);
}

USER_OBJECT_
RS_GGOBI(setBrushGlyph)(USER_OBJECT_ vals, USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);
  if(gg) {
    GGOBI(setBrushGlyph)(INTEGER_DATA(vals)[0], INTEGER_DATA(vals)[1], gg);
    brush_reset(gg, 0);
    gdk_flush();
  }
 return(NULL_USER_OBJECT);
}


USER_OBJECT_
RS_GGOBI(getBrushGlyph)(USER_OBJECT_ ggobiId)
{
  gint t, s;
  ggobid *gg;
  USER_OBJECT_ ans;
  gg = GetGGobi(ggobiId);
  if(gg) {
   GGOBI(getBrushGlyph)(&t, &s, gg);
   ans = NEW_INTEGER(2);
   INTEGER_DATA(ans)[0] = t;
   INTEGER_DATA(ans)[1] = s;
  } else
    ans = NULL_USER_OBJECT;

  return(ans);
}


USER_OBJECT_
RS_GGOBI(setCasesHidden)(USER_OBJECT_ vals, USER_OBJECT_ which, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  gint i;
  ggobid *gg;
  datad *d;
  USER_OBJECT_ ans = NEW_LOGICAL(1);
  d = resolveDatad(datasetId, ggobiId, &gg);
  if(d) {
    int num = GET_LENGTH(vals);
    for (i = 0; i < num; i++) {
      GGOBI(setCaseHidden)(INTEGER_DATA(which)[i], LOGICAL_DATA(vals)[i], d, gg);
    }

   displays_plot (NULL, FULL, gg);
   gdk_flush();
   LOGICAL_DATA(ans)[0] = TRUE;
  }

  return(ans);
}



USER_OBJECT_
RS_GGOBI(getCasesHidden)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  ggobid *gg;
  datad *d;
  d = resolveDatad(datasetId, ggobiId,  &gg);
    if(d) {
      gint num = d->nrows_in_plot, i, m;

      PROTECT(ans = NEW_LOGICAL(num));
      for(m = 0; m < num; m++) {
        i = d->rows_in_plot.els[m];
        LOGICAL_DATA(ans)[m] = GGOBI(getCaseHidden)(i, d, gg);
      }

      UNPROTECT(1);
    }

  return(ans);
}




/*
 This allows us to add a variable to the existing dataset.
 If there are no variables currently in the dataset, the first
 one added will induce a call to GGOBI(setData) and
 datad_init() which will create the relevant tab in the
 notebook. However, it will also slight mess up with the
 addition of the variables into the control panel
 (e.g. create X, Y and Z buttons for no good reason.)

 We might want to inhibit this and wait until the end.
*/
USER_OBJECT_
RS_GGOBI(addVariable)(USER_OBJECT_ vals, USER_OBJECT_ name, USER_OBJECT_ levels,
		      USER_OBJECT_ values, 
                      USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  datad *d;
  ggobid *gg;
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  d = resolveDatad(datasetId, ggobiId, &gg);


  if(d) {
    int i;
    PROTECT(ans = NEW_INTEGER(1));
    if(GET_LENGTH(levels)) {
     USER_OBJECT_ names;
     int n = GET_LENGTH(levels);
     char **levelValues;

     names = GET_NAMES(levels);
     levelValues = (char **) S_alloc(n, sizeof(char *));
     for(i = 0; i < n ; i++) {
         levelValues[i] = CHAR_DEREF(STRING_ELT(names, i));
     }

     INTEGER_DATA(ans)[0] = GGOBI(addCategoricalVariable)(NUMERIC_DATA(vals),
							      GET_LENGTH(vals), 
							      CHAR_DEREF(STRING_ELT(name,0)), 
							      levelValues, 
 	 						      INTEGER_DATA(values), INTEGER_DATA(levels),
							      n,
							      true, d, gg);
    } else {
         INTEGER_DATA(ans)[0] = GGOBI(addVariable)(NUMERIC_DATA(vals),
					       GET_LENGTH(vals), 
					       CHAR_DEREF(STRING_ELT(name,0)), 
					       true, d, gg);
    }
    UNPROTECT(1);
  } else {
    PROBLEM "Cannot resolve dataset in GGobi"
    ERROR;
  }

  return(ans);
}

USER_OBJECT_
RS_GGOBI(datad_init)(USER_OBJECT_ cleanup, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  datad *d;
  ggobid *gg;

  d = resolveDatad(datasetId, ggobiId, &gg);

  if(d) {
     datad_init(d, gg, LOGICAL_DATA(cleanup)[0]);
  }

  return(NULL_USER_OBJECT);
}

USER_OBJECT_
RS_GGOBI(varpanel_populate)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  datad *d;
  ggobid *gg;

  d = resolveDatad(datasetId, ggobiId, &gg);

  if(d) {
     varpanel_populate(d, gg);
  }

  return(NULL_USER_OBJECT);
}


USER_OBJECT_
RS_GGOBI(setVariableValues)(USER_OBJECT_ vals, USER_OBJECT_ rowIds,
                             USER_OBJECT_ colId, USER_OBJECT_ update, 
                               USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  ggobid *gg;
  datad *d;
  gint i, num, var, row;
  
  d = resolveDatad(datasetId, ggobiId, &gg);

  num = GET_LENGTH(rowIds);
  var = INTEGER_DATA(colId)[0];
  for (i=0;i < num; i++) {
    row = INTEGER_DATA(rowIds)[i];
    d->raw.vals[row][var] = d->tform.vals[row][var] = NUMERIC_DATA(vals)[i];
  }

/*  splot_reverse_pipeline (gg->current_splot, row, &gg->movepts.eps, true, true, gg); */
  /*
   * This call does too much. Need to find a routine that does
   * just what is needed.

  pipeline_init (d, gg);
  displays_plot(NULL, FULL, gg);

  */
  if(LOGICAL_DATA(update)[0]) {
      tform_to_world (d, gg);
      displays_tailpipe (FULL, gg);
      gdk_flush();
  }

  return(NULL_USER_OBJECT);
}


USER_OBJECT_
RS_GGOBI(setVariableNames)(USER_OBJECT_ vars, USER_OBJECT_ names, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  gint i, which;
  ggobid *gg;
  datad *d;
  int num = GET_LENGTH(vars);
  gchar **curNames; 
  USER_OBJECT_ ans;

  d = resolveDatad(datasetId, ggobiId, &gg);
  if(d == NULL)
    return(NULL_USER_OBJECT);

  PROTECT(ans = NEW_CHARACTER(num));
  curNames = GGOBI(getVariableNames)(false, d, gg);
  for (i = 0; i < num; i++) {
    which = INTEGER_DATA(vars)[i];
    SET_STRING_ELT(ans, i, COPY_TO_USER_STRING(curNames[which]));
    GGOBI(setVariableName)(which, CHAR_DEREF(STRING_ELT(names,i)), false, d, gg);
    GGOBI(setVariableName)(which, CHAR_DEREF(STRING_ELT(names,i)), true, d, gg);
  }

  UNPROTECT(1);
  return(ans);
}

USER_OBJECT_
RS_GGOBI(raiseOrLowerDisplays)(USER_OBJECT_ displays, USER_OBJECT_ iconify, USER_OBJECT_ raise, USER_OBJECT_ ggobiId)
{
    USER_OBJECT_ ans;
    int numDisplays = GET_LENGTH(displays), i;

    if(numDisplays == 0)
	return(NULL_USER_OBJECT);

    PROTECT(ans = NEW_LOGICAL(numDisplays));

    for(i = 0; i < numDisplays; i++) {
      displayd *display;
      windowDisplayd *wdpy;
      display = GetDisplay(VECTOR_ELT(displays, i), ggobiId, NULL);
      if(display == NULL || GTK_IS_GGOBI_WINDOW_DISPLAY(display) == false)
	  continue;

      wdpy = GTK_GGOBI_WINDOW_DISPLAY(display);

      if(LOGICAL_DATA(iconify)[0] == FALSE) {
        if(LOGICAL_DATA(raise)[0]) 
          gdk_window_raise(wdpy->window->window); 
        else
          gdk_window_lower(wdpy->window->window); 
      } else {
          /* This doesn't seem to iconify things, just kill them! 
             XIconifyWindow(GDK_WINDOW_XDISPLAY(GTK_WIDGET(window)->window),
                             GDK_WINDOW_XWINDOW(GTK_WIDGET(window)->window),
                             DefaultScreen (GDK_DISPLAY ()));             
           */
        if(LOGICAL_DATA(raise)[0]) 
          gtk_widget_show_all(wdpy->window); 
        else
          gtk_widget_hide_all(wdpy->window); 
      }

      LOGICAL_DATA(ans)[i] = TRUE;
    }

    UNPROTECT(1);

    gdk_flush();
    return(ans);
}

/**
 Probably should be deprecated.
 */
void
RS_GGOBI(raiseDisplay)(glong *plotId, glong *numEls, glong *raiseOrIcon,
  glong *up, glong *ggobiId)
{
  ggobid *gg = ggobi_get(*ggobiId);
  gint i;

  for (i = 0; i < *numEls; i++) {
    plotId[i] = GGOBI(raiseWindow)(plotId[i], raiseOrIcon[0], up[0], gg);
  }
}


USER_OBJECT_
RS_GGOBI(getVariable)(int which, datad *d)
{
  int nr = d->nrows_in_plot, i, m;
  float f;
    USER_OBJECT_ ans;
    vartabled *vt;
     vt = vartable_element_get (which, d);

     if(vt->vartype == categorical) {
       PROTECT(ans = NEW_INTEGER(nr));
     } else {
       PROTECT(ans = NEW_NUMERIC(nr));
     }
    for(m = 0; m < nr; m++) {
      i = d->rows_in_plot.els[m];
      f = d->raw.vals[i][which];
      if(vt->vartype == categorical)
	    INTEGER_DATA(ans)[m] = f;
      else
	    NUMERIC_DATA(ans)[m] = f;
    }
    if(vt->vartype == categorical) {
        USER_OBJECT_ levs;
        nr = vt->nlevels;
        PROTECT(levs = NEW_CHARACTER(nr));
	for(m = 0; m < nr; m++) {
          gchar* tmp;
          i = d->rows_in_plot.els[m];
          tmp = (gchar *) vt->level_names[i];
	  SET_STRING_ELT(levs, m, COPY_TO_USER_STRING(tmp));
	}
        SET_LEVELS(ans, levs);
        PROTECT(levs = NEW_CHARACTER(1));
        SET_STRING_ELT(levs, 0, COPY_TO_USER_STRING("factor"));
        SET_CLASS(ans, levs);
	UNPROTECT(2);
    }

    UNPROTECT(1);
    return(ans);
}

USER_OBJECT_
RS_GGOBI(getVariables)(USER_OBJECT_ which, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{

  datad *d = NULL;
  USER_OBJECT_ ans = NULL_USER_OBJECT;

  d = resolveDatad(datasetId, ggobiId, NULL);

  if(d) {
      int n = GET_LENGTH(which), i;
 
      PROTECT(ans = NEW_LIST(n));

      for(i = 0; i < n; i++) {
	  SET_VECTOR_ELT(ans, i, RS_GGOBI(getVariable)(INTEGER_DATA(which)[i]-1, d));
      }
      UNPROTECT(1);
  } else {
   PROBLEM "Cannot identify dataset in GGobi"
   ERROR;
  }

  return(ans);
}


USER_OBJECT_
RS_GGOBI(getMainWindow)(USER_OBJECT_ gobiId)
{
  ggobid *gg = GetGGobi(gobiId);
  USER_OBJECT_ ans;

  ans = R_MakeExternalPtr(gg->main_window, Rf_install("GtkWindow"), NULL_USER_OBJECT);

  return(ans);
}

USER_OBJECT_
RS_GGOBI(getCurrentDisplay)(USER_OBJECT_ gobiId)
{
  ggobid *gg = GetGGobi(gobiId);
  USER_OBJECT_ ans;

  ans = R_MakeExternalPtr(gg->current_display, Rf_install("GtkWidget"), NULL_USER_OBJECT);

  return(ans);
}



#include "plugin.h"

USER_OBJECT_
RS_GGOBI(getPlugins)(USER_OBJECT_ gobiId)
{

  ggobid *gg = GetGGobi(gobiId);
  USER_OBJECT_ ans, names;
  GList *tmp;
  gint n, i;

  n = g_list_length(gg->pluginInstances);

  PROTECT(ans = NEW_LIST(n));
  PROTECT(names = NEW_CHARACTER(n));
  for(i = 0, tmp = gg->pluginInstances; i < n; tmp=tmp->next, i++) {
     PluginInstance *inst = tmp->data;
     SET_VECTOR_ELT(ans, i, R_MakeExternalPtr(tmp->data, Rf_install("GGobiPluginInstance"), NULL_USER_OBJECT));
     SET_STRING_ELT(names, i, COPY_TO_USER_STRING(inst->info->details->name));
  }
  SET_NAMES(ans, names);
  UNPROTECT(2);

  return(ans);
}


static USER_OBJECT_
R_getPluginInfo(GGobiPluginInfo *info)
{
  SEXP klass = MAKE_CLASS("GGobiPluginInfo");
  USER_OBJECT_ ans;

  PROTECT(ans = NEW(klass));
  SET_SLOT(ans, Rf_install("dll"), mkString(info->details->dllName));
  SET_SLOT(ans, Rf_install("name"), mkString(info->details->name));
  SET_SLOT(ans, Rf_install("description"), mkString(info->details->description));
  SET_SLOT(ans, Rf_install("author"), mkString(info->details->author));

  UNPROTECT(1);

  return(ans);
}


USER_OBJECT_
RS_GGOBI(getPluginInfo)(USER_OBJECT_ gobiId)
{
  USER_OBJECT_ ans, names;
  GList *tmp, *plugins;
  gint n, i;
  plugins = GGOBI_getSessionOptions()->info->plugins;
  n = g_list_length(plugins);

  PROTECT(ans = NEW_LIST(n));
  PROTECT(names = NEW_CHARACTER(n));
  for(i = 0, tmp = plugins; i < n; tmp=tmp->next, i++) {
     GGobiPluginInfo *inst = tmp->data;
     SET_VECTOR_ELT(ans, i, R_getPluginInfo(inst));
     SET_STRING_ELT(names, i, COPY_TO_USER_STRING(inst->details->name));
  }
  SET_NAMES(ans, names);
  UNPROTECT(2);

  return(ans);
}


