/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel;

import java.io.IOException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.SyntheticRepository;

public abstract class Repository {
    private static org.apache.bcel.util.Repository _repository = SyntheticRepository.getInstance();

    public static org.apache.bcel.util.Repository getRepository() {
        return _repository;
    }

    public static void setRepository(org.apache.bcel.util.Repository repository) {
        _repository = repository;
    }

    public static JavaClass lookupClass(String string) throws ClassNotFoundException {
        return _repository.loadClass(string);
    }

    public static JavaClass lookupClass(Class clazz) throws ClassNotFoundException {
        return _repository.loadClass(clazz);
    }

    public static ClassPath.ClassFile lookupClassFile(String string) {
        try {
            ClassPath classPath = _repository.getClassPath();
            if (classPath == null) {
                return null;
            }
            return classPath.getClassFile(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void clearCache() {
        _repository.clear();
    }

    public static JavaClass addClass(JavaClass javaClass) {
        JavaClass javaClass2 = _repository.findClass(javaClass.getClassName());
        _repository.storeClass(javaClass);
        return javaClass2;
    }

    public static void removeClass(String string) {
        _repository.removeClass(_repository.findClass(string));
    }

    public static void removeClass(JavaClass javaClass) {
        _repository.removeClass(javaClass);
    }

    public static JavaClass[] getSuperClasses(JavaClass javaClass) throws ClassNotFoundException {
        return javaClass.getSuperClasses();
    }

    public static JavaClass[] getSuperClasses(String string) throws ClassNotFoundException {
        JavaClass javaClass = Repository.lookupClass(string);
        return Repository.getSuperClasses(javaClass);
    }

    public static JavaClass[] getInterfaces(JavaClass javaClass) throws ClassNotFoundException {
        return javaClass.getAllInterfaces();
    }

    public static JavaClass[] getInterfaces(String string) throws ClassNotFoundException {
        return Repository.getInterfaces(Repository.lookupClass(string));
    }

    public static boolean instanceOf(JavaClass javaClass, JavaClass javaClass2) throws ClassNotFoundException {
        return javaClass.instanceOf(javaClass2);
    }

    public static boolean instanceOf(String string, String string2) throws ClassNotFoundException {
        return Repository.instanceOf(Repository.lookupClass(string), Repository.lookupClass(string2));
    }

    public static boolean instanceOf(JavaClass javaClass, String string) throws ClassNotFoundException {
        return Repository.instanceOf(javaClass, Repository.lookupClass(string));
    }

    public static boolean instanceOf(String string, JavaClass javaClass) throws ClassNotFoundException {
        return Repository.instanceOf(Repository.lookupClass(string), javaClass);
    }

    public static boolean implementationOf(JavaClass javaClass, JavaClass javaClass2) throws ClassNotFoundException {
        return javaClass.implementationOf(javaClass2);
    }

    public static boolean implementationOf(String string, String string2) throws ClassNotFoundException {
        return Repository.implementationOf(Repository.lookupClass(string), Repository.lookupClass(string2));
    }

    public static boolean implementationOf(JavaClass javaClass, String string) throws ClassNotFoundException {
        return Repository.implementationOf(javaClass, Repository.lookupClass(string));
    }

    public static boolean implementationOf(String string, JavaClass javaClass) throws ClassNotFoundException {
        return Repository.implementationOf(Repository.lookupClass(string), javaClass);
    }
}

