#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "../src/picture.h"

#define MAXR	15
#define MAXD	(MAXR+MAXR+1)

int color(float f)
{
	if(f < 0.0) return 0;
	if(f > 1.275) return 255;
	return (int)(200.0*f);
}

void computestar(double mag, double col, double c, double base)
{
        double peak;
        double grid[MAXD][MAXD];
        double a, v, sum;
        int i, j, k, minrad;
        struct picture pic;
        char filename[100];
	static int num=0;

        pic.data = (unsigned char *)malloc(MAXD*MAXD*3);

        peak = c/pow(base, mag);
        if(peak < 1.0)
        {
                printf("  %d %3d %3d\n", 
			color(peak+col),
                        color(peak), 
			color(peak-col));
                return;
        }
        for(a = 0.8; a < 12.0; a+=0.05)
        {
                sum = 0.0;
                minrad = -999;
                for(j = 0; j < MAXD; j++) for(i = 0; i < MAXD; i++)
                {
                        v = 1.0-((i-MAXR)*(i-MAXR) + (j-MAXR)*(j-MAXR))/(a*a);
                        if(v  <= 0.1) grid[j][i] = 0.0;
                        else
                        {
                                if(minrad == -999) minrad=MAXR-j;
                                v = sqrt(v);
                                grid[j][i] = v;
                                sum += v;
                        }
                }
                if(sum > peak) break;
        }
        sprintf(filename, "star.%d.pic", num++);
        printf("%s\n", filename);
        pic.w = pic.h = 2*minrad+1;
        pic.hotx = pic.hoty = minrad;
        k = 0;
        for(j = MAXR-minrad; j <= MAXR+minrad; j++)
                for(i = MAXR-minrad; i <= MAXR+minrad; i++)
                {

			if(grid[j][i] == 0.0)
			{
				pic.data[k++] = 0;
				pic.data[k++] = 0;
				pic.data[k++] = 0;
			}
			else
			{
				pic.data[k++] = color(grid[j][i]+col);
				pic.data[k++] = color(grid[j][i]);
				pic.data[k++] = color(grid[j][i]-col);
			}
                }
        savepicture(&pic, filename);
}

int main()
{
	double m, c;

	for(m = -2.0; m < 15.0; m+=0.5) 
		for(c = -0.26; c <= 0.26001; c += 0.065)
			computestar(m, c, 121.0, 1.75);

	return 0;
}

