/* ===================================================
 * JCommon : a free general purpose Java class library
 * ===================================================
 *
 * Project Info:  http://www.object-refinery.com/jcommon/index.html
 * Project Lead:  David Gilbert (david.gilbert@object-refinery.com);
 *
 * (C) Copyright 2000-2002, by Simba Management Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * ----------------
 * ProjectInfo.java
 * ----------------
 * (C) Copyright 2001, 2002, by Simba Management Limited.
 *
 * Original Author:  David Gilbert (for Simba Management Limited);
 * Contributor(s):   -;
 *
 * $Id: ProjectInfo.java,v 1.2 2002/06/27 12:43:31 mungady Exp $
 *
 * Changes (since 27-Jun-2002)
 * ---------------------------
 * 27-Jun-2002 : Added logo, updated source header and Javadocs (DG);
 *
 */

package com.jrefinery.ui.about;

import java.awt.Image;
import java.util.List;
import java.util.Iterator;

/**
 * A class for recording the basic information about a free or open source software project.
 */
public class ProjectInfo {

    /** The project name. */
    protected String name;

    /** The project version. */
    protected String version;

    /** The project copyright statement. */
    protected String copyright;

    /** Further info about the project (typically a URL for the project's web page). */
    protected String info;

    /** An optional project logo. */
    protected Image logo;

    /** The name of the licence. */
    protected String licenceName;

    /** The licence text. */
    protected String licenceText;

    /** A list of contributors. */
    protected List contributors;

    /** A list of libraries used by the project. */
    protected List libraries;

    /**
     * Constructs an empty project info object.
     */
    public ProjectInfo() {
    }

    /**
     * Constructs a project info object.
     *
     * @param name The name of the project.
     * @param version The version.
     * @param info Other info (usually a URL).
     * @param logo The project logo.
     * @param copyright A copyright statement.
     * @param licenceName The name of the licence that applies to the project.
     */
    public ProjectInfo(String name,
                       String version,
                       String info,
                       Image logo,
                       String copyright,
                       String licenceName,
                       String licenceText) {

        this.name = name;
        this.version = version;
        this.info = info;
        this.logo = logo;
        this.copyright = copyright;
        this.licenceName = licenceName;
        this.licenceText = licenceText;

    }

    /**
     * Returns the project name.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Returns the project version.
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * Returns other information about the project (typically a URL for the project home page).
     */
    public String getInfo() {
        return this.info;
    }

    /**
     * Returns the logo.
     */
    public Image getLogo() {
        return this.logo;
    }

    /**
     * Returns the copyright statement.
     */
    public String getCopyright() {
        return this.copyright;
    }

    /**
     * Returns the licence name.
     */
    public String getLicenceName() {
        return this.licenceName;
    }

    /**
     * Returns the licence text.
     */
    public String getLicenceText() {
        return this.licenceText;
    }

    /**
     * Returns a list of contributors.
     */
    public List getContributors() {
        return this.contributors;
    }

    /**
     * Returns a list of libraries used.
     */
    public List getLibraries() {
        return this.libraries;
    }

    /**
     * Returns a string describing the project.
     */
    public String toString() {

        String result = this.getName()+" version "+this.getVersion()+".\n";
        result = result+this.getCopyright()+".\n";
        result = result+"\n";
        result = result+"For terms of use, see the licence below.\n";
        result = result+"\n";
        result = result+"FURTHER INFORMATION:";
        result = result+this.getInfo();
        result = result+"\n";
        result = result+"CONTRIBUTORS:";
        List contributors = this.getContributors();
        if (contributors!=null) {
            Iterator iterator = this.getContributors().iterator();
            while (iterator.hasNext()) {
                Contributor contributor = (Contributor)(iterator.next());
                result = result+contributor.getName()+" ("+contributor.getEmail()+").";
            }
        }
        else {
            result = result+"None";
        }

        result = result+"\n";
        result = result+"OTHER LIBRARIES USED BY JCOMMON:";
        List libraries = this.getLibraries();
        if (libraries!=null) {
            Iterator iterator = this.getLibraries().iterator();
            while (iterator.hasNext()) {
                Library lib = (Library)(iterator.next());
                result = result+lib.getName()+" "+lib.getVersion()+" ("+lib.getInfo()+").";
            }
        }
        else {
            result = result+"None";
        }
        result = result+"\n";
        result = result+"JCOMMON LICENCE TERMS:";
        result = result+"\n";
        result = result+this.getLicenceText();

        return result;

    }

}