-- `Topal': GPG/Pine integration
--
-- Copyright (C) 2001,2002  Phillip J. Brooke
--
--     This program is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
--
--     This program is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with this program; if not, write to the Free Software
--     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

with Globals; use Globals;

package Command_Line_Wrapper is
   
   Argument_Overrun : exception;
   
   -- Three functions for working through the command line.
   -- The first only advances the pointer if the test was true.
   -- Two forms, one taking a string, one taking a UBS_Array.
   function Match (A : in String) return Boolean;
   
   function Match (A : in UBS_Array) return Boolean;

   -- This second function always advances.
   function Eat return UBS;
   
   -- This last function returns true if there is still something to read.
   function More (Needed : Positive := 1) return Boolean;
   
   -- Given J, the index of the first command line argument to drop into an
   -- array, drop J, J+1, etc. into an array and return it.
   function Eat_Remaining_Arguments return UBS_Array_Pointer;

   -- Display the current argument.
   function Current return String;

end Command_Line_Wrapper;
