-- `Topal': GPG/Pine integration
--
-- Copyright (C) 2001,2002  Phillip J. Brooke
--
--     This program is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
--
--     This program is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with this program; if not, write to the Free Software
--     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package Externals.Simple is

   -- Equivalent of `cat D'.
   procedure Cat (D : in String);

   -- Equivalent of `cat D1 > D2'.
   procedure Cat_Out (D1 : in String;
                      D2 : in String);

   -- Equivalent of `cat > D'.
   procedure Cat_Stdin_Out (D : in String);

   -- Equivalent of `cat D1 >> D2'.
   procedure Cat_Append (D1 : in String;
                         D2 : in String);

   -- Equivalent of `chmod P D'.
   procedure Chmod (P : in String;
                    D : in String);

   -- Equivalent of `clear'.
   procedure Clear;

   -- Equivalent of `date >> D'.
   procedure Date_Append (D : in String);

   -- Date string YmdHMS.
   function Date_String return String;

   -- Diff --brief.  Returns true for `there are changes', false for
   -- `no changes'.
   function Diff_Brief (F1 : in String;
                        F2 : in String) return Boolean;

   -- Equivalent of `dos2unix -u D'.
   procedure Dos2Unix_U (D : in String);

   -- Equivalent of `dos2unix D'.
   procedure Dos2Unix (D : in String);

   -- Equivalent of `echo E >> D'.
   procedure Echo_Append (E : in String;
                          D : in String);

   -- Equivalent of `echo E > D'.
   procedure Echo_Out (E : in String;
                       D : in String);

   -- Equivalent of `echo -n E > D'.
   procedure Echo_Out_N (E : in String;
                         D : in String);

   -- Equivalent of `grep -i T <D1 >D2'.
   function Grep_I_InOut (T : in String;
                          D1 : in String;
                          D2 : in String) return Integer;

   -- Equivalent of `mkdir -p D'
   procedure Mkdir_P (D : in String);

   -- Equivalent of `mv -f D1 D2'
   procedure Mv_F (D1 : in String;
                   D2 : in String);

   -- View a file with a pager.
   procedure Pager (F : in String);

   -- Remove a specified file (rm -f F).
   procedure Rm_File (F : in String);

   -- Remove all the temporary files.
   procedure Rm_Tempfiles;

   -- Remove temporary files for this run.
   procedure Rm_Tempfiles_PID;

   -- Remove all the cache files.
   procedure Rm_Cachefiles;

   -- General sed invocation.  Only accepts a SINGLE argument.
   procedure Sed_InOut (A      : in String;
                        Source : in String;
                        Target : in String);

   -- Equivelant of `stty sane'.
   procedure Stty_Sane;

   -- Equivalent of `test -d D'
   function Test_D (D : in String) return Boolean;

   -- Equivalent of `test -f D'
   function Test_F (D : in String) return Boolean;

   -- Equivalent of `test -r D'
   function Test_R (D : in String) return Boolean;

   -- Equivalent of `test -s D'
   function Test_S (D : in String) return Boolean;

   -- View a MIME file.
   procedure View_MIME (F : String);

end Externals.Simple;
