/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.DataSet;
import com.workingdogs.village.DataSetException;
import com.workingdogs.village.KeyDef;
import com.workingdogs.village.Record;
import com.workingdogs.village.Schema;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;

public class TableDataSet
extends DataSet {
    private String optimisticLockingCol;
    private String where = null;
    private String order = null;
    private String other = null;
    private boolean refreshOnSave = false;

    public TableDataSet() throws SQLException, DataSetException {
    }

    public TableDataSet(Connection connection, Schema schema, KeyDef keyDef) throws SQLException, DataSetException {
        super(connection, schema, keyDef);
    }

    public TableDataSet(Connection connection, String string) throws SQLException, DataSetException {
        super(connection, string);
    }

    public TableDataSet(Connection connection, String string, KeyDef keyDef) throws SQLException, DataSetException {
        super(connection, string, keyDef);
    }

    public TableDataSet(Connection connection, String string, String string2) throws SQLException, DataSetException {
        super(connection, string, string2);
    }

    public TableDataSet(Connection connection, String string, String string2, KeyDef keyDef) throws SQLException, DataSetException {
        super(connection, string, string2, keyDef);
    }

    public String attributes() {
        return super.getColumns();
    }

    private void buildSelectString() throws DataSetException {
        if (this.selectString == null) {
            this.selectString = new StringBuffer(256);
        } else {
            this.selectString.setLength(0);
        }
        this.selectString.append("SELECT ");
        this.selectString.append(this.schema().attributes());
        this.selectString.append(" FROM ");
        this.selectString.append(this.schema().tableName());
        if (this.where != null && this.where.length() > 0) {
            this.selectString.append(" WHERE " + this.where);
        }
        if (this.order != null && this.order.length() > 0) {
            this.selectString.append(" ORDER BY " + this.order);
        }
        if (this.other != null && this.other.length() > 0) {
            this.selectString.append(this.other);
        }
    }

    public String debugInfo() {
        return "Not yet implemented!";
    }

    public DataSet fetchRecords() throws SQLException, DataSetException {
        return this.fetchRecords(-1);
    }

    public DataSet fetchRecords(int n) throws SQLException, DataSetException {
        return this.fetchRecords(0, n);
    }

    public DataSet fetchRecords(int n, int n2) throws SQLException, DataSetException {
        this.buildSelectString();
        return super.fetchRecords(n, n2);
    }

    String getOrder() {
        return this.order;
    }

    String getOther() {
        return this.other;
    }

    public String getSelectString() throws DataSetException {
        this.buildSelectString();
        return this.selectString.toString();
    }

    String getWhere() {
        return this.where;
    }

    public KeyDef keydef() {
        return super.keydef();
    }

    public String optimisticLockingCol() {
        return this.optimisticLockingCol;
    }

    public TableDataSet order(String string) throws DataSetException {
        if (string == null) {
            throw new DataSetException("null not allowed for order clause");
        }
        this.order = string;
        return this;
    }

    public TableDataSet other(String string) throws DataSetException {
        if (string == null) {
            throw new DataSetException("null not allowed for other clause");
        }
        this.other = string;
        return this;
    }

    public void refresh(Connection connection) throws SQLException, DataSetException {
        Enumeration enumeration = this.records.elements();
        while (enumeration.hasMoreElements()) {
            Record record = (Record)enumeration.nextElement();
            record.refresh(connection);
        }
    }

    public boolean refreshOnSave() {
        return this.refreshOnSave;
    }

    public void removeDeletedRecords() throws DataSetException {
        Enumeration enumeration = this.records.elements();
        while (enumeration.hasMoreElements()) {
            Record record = (Record)enumeration.nextElement();
            if (!record.isAZombie()) continue;
            this.removeRecord(record);
        }
    }

    public ResultSet resultSet() throws SQLException, DataSetException {
        return super.resultSet();
    }

    public int save() throws SQLException, DataSetException {
        return this.save(this.connection(), false);
    }

    public int save(Connection connection, boolean bl) throws SQLException, DataSetException {
        int n = 0;
        Enumeration enumeration = this.records.elements();
        while (enumeration.hasMoreElements()) {
            Record record = (Record)enumeration.nextElement();
            record.save(connection);
            ++n;
        }
        this.removeDeletedRecords();
        return n;
    }

    public int save(boolean bl) throws SQLException, DataSetException {
        return this.save(this.connection(), bl);
    }

    public int saveWithoutStatusUpdate(Connection connection) throws SQLException, DataSetException {
        throw new DataSetException("Not yet implemented!");
    }

    public Schema schema() {
        return super.schema();
    }

    public void setOptimisticLockingColumn(String string) {
        this.optimisticLockingCol = string;
    }

    public void setRefreshOnSave(boolean bl) {
        this.refreshOnSave = bl;
    }

    public String tableName() throws DataSetException {
        return super.tableName();
    }

    public TableDataSet tableQualifier(String string) {
        this.schema().appendTableName(string);
        return this;
    }

    public void updateStatus() throws SQLException, DataSetException {
        throw new DataSetException("Not yet implemented!");
    }

    public TableDataSet where(String string) throws DataSetException {
        if (string == null) {
            throw new DataSetException("null not allowed for where clause");
        }
        this.where = string;
        return this;
    }
}

