/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.ContextException;
import org.webmacro.FastWriter;
import org.webmacro.Template;
import org.webmacro.TemplateException;
import org.webmacro.engine.Block;
import org.webmacro.engine.BlockBuilder;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Engine;
import org.webmacro.engine.Parser;
import org.webmacro.util.Log;

public abstract class WMTemplate
implements Template {
    private Broker _broker;
    private Block _content;
    private String _parserName;
    private static Log _log = new Log("tmpl", "Template Processing");
    private Map _parameters;
    private String _encoding;

    protected WMTemplate(Broker broker, String string) {
        this(broker, "wm", string);
    }

    protected WMTemplate(Broker broker, String string, String string2) {
        this._broker = broker;
        this._parserName = string;
        this._encoding = string2;
    }

    protected abstract Reader getReader() throws IOException;

    public abstract String toString();

    protected Parser getParser() throws TemplateException {
        try {
            return (Parser)this._broker.getValue("parser", "wm");
        }
        catch (Exception exception) {
            Engine.log.exception(exception);
            throw new TemplateException("Could not load parser type \"" + this._parserName + "\": " + exception);
        }
    }

    /*
     * Loose catch block
     */
    public final void parse() throws IOException, TemplateException {
        Block block = null;
        Map map = null;
        Reader reader = null;
        Parser parser = this.getParser();
        reader = this.getReader();
        BlockBuilder blockBuilder = parser.parseBlock(this.toString(), reader);
        reader.close();
        BuildContext buildContext = new BuildContext(this._broker, this._encoding);
        map = buildContext.getGlobalVariables();
        block = (Block)blockBuilder.build(buildContext);
        Object var8_9 = null;
        try {
            reader.close();
        }
        catch (Exception object) {
            // empty catch block
        }
        object = this;
        synchronized (object) {
            this._parameters = map;
            this._content = block;
        }
        {
            catch (BuildException buildException) {
                block = null;
                _log.error("Template contained invalid data: " + buildException);
                throw buildException;
            }
            catch (IOException iOException) {
                block = null;
                _log.error("Template: Could not read template: " + this);
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                reader.close();
            }
            catch (Exception object) {
                // empty catch block
            }
            object = this;
            synchronized (object) {
                this._parameters = map;
                this._content = block;
            }
            throw throwable;
        }
    }

    public final Object evaluate(Context context) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            FastWriter fastWriter = new FastWriter(byteArrayOutputStream, this._encoding);
            this.write(fastWriter, context);
            fastWriter.flush();
            return byteArrayOutputStream.toString(this._encoding);
        }
        catch (IOException iOException) {
            _log.exception(iOException);
            _log.error("Template: Could not write to ByteArrayOutputStream!");
            return null;
        }
    }

    public final void write(FastWriter fastWriter, Context context) throws IOException {
        Block block = this._content;
        Context context2 = context;
        synchronized (context2) {
        }
        if (block == null) {
            try {
                WMTemplate wMTemplate = this;
                synchronized (wMTemplate) {
                    if (this._content == null) {
                        this.parse();
                    }
                    block = this._content;
                }
            }
            catch (Exception exception) {
                _log.exception(exception);
                _log.error("Template: Unable to read template: " + this);
                fastWriter.write("<!--\n Template failed to read. Reason: ");
                fastWriter.write(exception.toString());
                fastWriter.write(" \n-->");
            }
        }
        try {
            block.write(fastWriter, context);
        }
        catch (ContextException contextException) {
            _log.exception(contextException);
            String string = "Template: Missing data in Map passed to template " + this;
            _log.warning(string);
            fastWriter.write("<!--\n Could not interpret template. Reason: ");
            fastWriter.write(string);
            fastWriter.write(contextException.toString());
            fastWriter.write(" \n-->");
        }
    }

    public Object getParam(String string) throws IOException, TemplateException {
        try {
            return this._parameters.get(string);
        }
        catch (NullPointerException nullPointerException) {
            WMTemplate wMTemplate = this;
            synchronized (wMTemplate) {
                this.parse();
                Object v = this._parameters.get(string);
                return v;
            }
        }
    }

    public Map getParameters() {
        return this._parameters;
    }
}

