/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.io.File;
import java.util.StringTokenizer;
import org.webmacro.Broker;
import org.webmacro.NotFoundException;
import org.webmacro.Template;
import org.webmacro.broker.CreateResourceEvent;
import org.webmacro.broker.RequestResourceEvent;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceInitException;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.engine.FileTemplate;
import org.webmacro.util.Log;

public final class TemplateProvider
implements ResourceProvider {
    private static String pathSeparator_ = ";";
    private String[] templateDirectory_ = null;
    private ResourceBroker _broker = null;
    private int cacheDuration = 600000;
    public static final String TYPE = "template";
    private static final boolean _debug = false;
    public static final Log _log;
    private static final String[] _types;

    public void init(ResourceBroker resourceBroker) throws ResourceInitException {
        this._broker = resourceBroker;
        try {
            String string;
            try {
                string = (String)resourceBroker.getValue("config", "TemplateExpireTime");
                this.cacheDuration = Integer.valueOf(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = (String)resourceBroker.getValue("config", "TemplatePath");
            StringTokenizer stringTokenizer = new StringTokenizer(string, pathSeparator_);
            this.templateDirectory_ = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (n < this.templateDirectory_.length) {
                String string2;
                this.templateDirectory_[n] = string2 = stringTokenizer.nextToken();
                ++n;
            }
        }
        catch (Exception exception) {
            _log.exception(exception);
            throw new ResourceInitException("Could not initialize");
        }
    }

    public final String[] getTypes() {
        return _types;
    }

    public final int resourceExpireTime() {
        return this.cacheDuration;
    }

    public final int resourceThreads() {
        return 1;
    }

    public final void resourceRequest(RequestResourceEvent requestResourceEvent) throws NotFoundException, InterruptedException {
        Template template;
        String string = requestResourceEvent.getName();
        String string2 = "UTF8";
        if (string.charAt(0) == ':') {
            int n = string.indexOf(58, 1);
            string2 = string.substring(1, n);
            string = string.substring(n + 1);
        }
        if ((template = this.get(string, string2)) == null) {
            return;
        }
        try {
            requestResourceEvent.set(template);
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void resourceCreate(CreateResourceEvent createResourceEvent) {
    }

    public final boolean resourceSave(ResourceEvent resourceEvent) {
        return false;
    }

    public final boolean resourceDelete(ResourceEvent resourceEvent) {
        return false;
    }

    public final void destroy() {
    }

    public final Template get(String string, String string2) {
        int n = 0;
        while (n < this.templateDirectory_.length) {
            String string3 = this.templateDirectory_[n];
            File file = new File(string3, string);
            if (file.canRead()) {
                try {
                    FileTemplate fileTemplate = new FileTemplate((Broker)this._broker, file, string2);
                    fileTemplate.parse();
                    return fileTemplate;
                }
                catch (Exception exception) {
                    _log.exception(exception);
                    _log.warning("TemplateProvider: Could not load template: " + file);
                }
            }
            ++n;
        }
        return null;
    }

    public final String toString() {
        return "TemplateProvider(" + this.getPath() + ")";
    }

    public final String getPath() {
        StringBuffer stringBuffer = new StringBuffer(200);
        int n = 0;
        while (n < this.templateDirectory_.length) {
            if (n != 0) {
                stringBuffer.append(pathSeparator_);
            }
            stringBuffer.append(this.templateDirectory_[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        try {
            pathSeparator_ = System.getProperty("path.separator");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _log = new Log(TYPE, "Template storage resource");
        _types = new String[]{TYPE};
    }
}

