
#define MAXNUM_HELPLINES 405

static char *helpText[MAXNUM_HELPLINES] = {
" ",
"@t@b@l  User Interface General Information.",
"@-",
"  When started, xisp displays a form with four buttons, three menus and a",
"  drop-choice list. Normally, in order to commence dialing, an ISP must be",
"  selected. The one selected by default right after startup is the first entry",
"  in the list of ISP's, or the one set as \"Default ISP\" from within the \"Account",
"  Information\" form. All defined ISP's appear in the drop list for quick selection.",
"  The \"Quit\" button is always activated. The other button activated at this",
"  time is the \"Connect\" button. After a connection is initiated, and up until",
"  a PPP link is established, \"Connect\" is deactivated while \"Interrupt\" is",
"  activated. After a link is established, \"Interrupt\" is deactivated and",
"  \"Disconnect\" is activated. The \"Help\" menu selection is self explanatory,",
"  I guess... The \"Options\" menu contains five items, \"Account Information\",",
"  \"Dialing and Login\", \"Communication Options\", \"TCP/IP Options\" and",
"  \"Paths Setup\".",
" ",
"@-",
"@b@m  \"Account Information\"",
"@-",
"     Brings up a list of ISP accounts to choose from, allowing editing of their",
"     properties. It also contains five input fields, one set of check buttons,",
"     one set of radio buttons, and four push buttons. The first time xisp is",
"     executed all ISP names will be blank. One can add an ISP entry by pres-",
"     sing the \"Add\" button. You can also create new entries by selecting",
"     existing entries, copying them by pressing the \"Copy\" button, and",
"     pasting them by pressing the \"Paste\" button. When adding or pasting",
"     entries, the new entry is always appended to the existing list of ISPs.",
"     Edit the ISP name by double-clicking on an entry in the list. The selected",
"     ISP can be set as the default selection upon xisp startup, by enabling the",
"     \"Default ISP\" check-button. If you want xisp to dial this ISP entry auto-",
"     matically after it starts up, enable the \"Auto-dial upon startup\" check-",
"     button. If you desire automatic re-dialing of dropped PPP connections to",
"     the selected ISP, enable the \"Re-dial dropped links\" check-button. Note",
"     that, contrary to the default ISP selection, auto-dialing and re-dialing of",
"     dropped links are per-ISP attributes. The first of five input fields contains",
"     the list of phone numbers to dial for the selected ISP, the second is the",
"     user account name to use, and the third is the password. The radio buttons",
"     enable use of password authentication via PAP or CHAP, both via the pap-",
"     secrets and chap-secrets pppd files. PAP without using the pap-secrets",
"     file, i.e. via the +ua option is supported only for pppd version 2.2. Since this",
"     option was removed starting with pppd version 2.3, this selection will be",
"     marked as unavailable when using xisp with pppd version 2.3 or later. The",
"     fourth input field contains the argument to the 'user' or 'name' argument to",
"     pppd, and the fifth contains the argument to the 'remotename' pppd option.",
"     Note that when any one of two available authentication methods is selected,",
"     any user script lines entered via the \"Dialing and Login\" menu, are ignored.",
"     In the phone number input field, more than one telephone numbers, and up",
"     to a total of 8 can be entered by separating them with the semicolon (';')",
"     character. The total length of each phone number is currently limited to 32",
"     characters.",
"     A brief note on password security is in order here. The plaintext password",
"     entered in the \"Password\" input field is encoded using encrypt(3) with a key",
"     saved in the xisp executable. This key is itself scrambled so that it is not",
"     visible in the xisp binary. Since any one having access to the source can",
"     can eventually come up with the key used, and potentially decode users' ",
"     .xisprc entries yielding the plaintext ISP passwords, system administrators",
"     installing xisp are urged to change the key employed. For more details read",
"     the SECURITY file included with the xisp distribution.",
" ",
"@-",
"@b@m  \"Dialing and Login\"",
"@-",
"     Brings up a window with fields for entering the three dialing parameters,",
"     namely the number of dialing tries, the inter-dialing delay and the maximum",
"     time to wait for modem connection,  as well as up to 16 user customizable",
"     script lines. It also enables the launching of a manual login window after a",
"     connection is established, the size of which can be specified via the",
"     \"Terminal columns:\" and \"rows:\" input fields, or enables ISP server call-",
"     back and editing of up to sixteen user customizable call-back script lines.",
"     In xisp version 2.6 and later, a manual login terminal window can be en-",
"     abled for the call-back connection, independently of the one selected for",
"     the dial-in phase. All numeric input fields are straight forward; the default",
"     values should be adequate for most cases. The sub-form for for editing the",
"     call-back script is activated by pressing the \"Call-back Options\" button,",
"     which is enabled only if you specify that the \"ISP server will call back\" via",
"     the corresponding radio button. This form also includes a field for entering",
"     the time to wait for the call-back connection, a terminal size if a manual",
"     terminal login is selected for the call-back phase, or a telephone number",
"     (that is, our phone number) to be called by an NT-RAS call-back server",
"     (this last option requires a patched version of the pppd daemon -- check",
"     section \"NT-RAS call-back support\" for details). The script section, both",
"     for dial-in and call-back, is divided into \"Expect:\" and \"Send:\" sections,",
"     as used by the call to the chat(8) command. Here the user must enter the",
"     script lines used by chat to successfully negotiate a login for the particular",
"     ISP. Dial-in/call-back script lines are not used when manual login or",
"     authenticated (PAP,CHAP) login is selected. However, it is possible to use",
"     call-back with authenticated login. For detailed script-line syntax and",
"     various examples please read the chat(8) manual page. The following",
"     simple example should give you an idea. Let us assume that the ISP of",
"     interest employs a terminal server which prompts the user with 'Username:',",
"     then with 'Password:' and then gives the server prompt, a single '>', at",
"     which point the user must type 'ppp' and press enter. The user",
"     customizable expect-send pairs for the above procedure would be:",
" ",
"         Expect:		Send:",
" ",
"@b         ername:--ername:	%U",
"@b         ssword:		%P",
"@b         >-->		ppp",
" ",
"     Note the special \"%U\" and \"%P\" variables in the script lines. \"%U\" is",
"     (quite obviously) replaced by your user account name (by the xisp program",
"     when it creates the dialing environment file), and \"%P\" by your password.",
"     A maximum of one \"%U\" and one \"%P\" can exist in either section (expect",
"     or send) of each script line. Entering more will make xisp print a message",
"     and abort the dial. The script employed by xispdial for the connection is the",
"     concatenation of its internal script, and the user customizable script lines",
"     entered via \"Dialing Data\". The internal script used is the following:",
" ",
"@b         TIMEOUT		3",
"@b         ABORT		BUSY",
"@b         ABORT		'NO CARRIER'",
"@b         ABORT		'NO DIALTONE'",
"@b         ABORT		enied",
"@b         ABORT		imeout",
"@b         ''			'AT <dial extras>D<dial method> <phone number>'",
"@b         TIMEOUT		<maximum wait for connection>",
"@b         <connect str>	\\c ",
"@b         TIMEOUT		5",
"@b         \\r			\\c",
" ",
"     The \"connect str\" is the string returned by your modem upon connection",
"     (it's \"CONNECT\" for a US Robotics Sportster, but it might be the word",
"     \"CARRIER\" for your modem; please consult with your modem's user manual).",
"     As seen above, the timeout value after connection is set to 5 seconds. If for",
"     some reason it takes more than that to log into a system, one could specify a",
"     new timeout value in the in the user script lines. For instance, in the example",
"     given above , if it takes 6 seconds for a prompt from the terminal server in",
"     question, the user customizable expect-send pairs could be:",
" ",
"         Expect:		Send:",
" ",
"@b         ername:--ername:	%U",
"@b         ssword:		%P",
"@b         TIMEOUT		10",
"@b         >-->		ppp",
" ",
"     allowing 10 (6 + an extra 4) seconds for receiving the '>' character. All",
"     special escape characters supported by chat(8) (e.g. \\n, \\r etc.) can be",
"     entered in either the the \"expect\" or the \"send\" portion of a script line.",
"     In xisp versions prior to 2.5p3, any such special characters would have to",
"     be escaped by preceding them with an extra '\\'. This is no longer needed",
"     as all characters beginning with '\\' are now automatically handled by",
"     xispdial. Note that since xisp version 1.9, when the script lines were",
"     divided into \"Expect:\" and \"Send:\" sections, you no longer need to",
"     enclose commands including spaces with single quotes. As an example,",
"     if at the end of the login session you start PPP using the command:",
" ",
"@c\"ppp /compress\"",
" ",
"     in versions prior to 1.9 you would need to enclose the command in single",
"     quotes and enter your script line as:",
" ",
"@c\">--> 'ppp /compress'\"",
" ",
"     in the above example. For versions 1.9 and later this is not necessary, as",
"     expect-send pairs are automatically quoted before being passed on to",
"     chat. If call-back is selected, the following script is appended to the",
"     concatenation of user customizable script lines and modified internal script:",
" ",
"@b         TIMEOUT		<delay for call-back connection>",
"@b         RING		ATA",
"@b         TIMEOUT		30",
"@b         <connect str>	\\c",
"@b         TIMEOUT		5",
"@b         \\r			\\c",
" ",
"     And following that, the user call-back script lines are appended to it.",
"     This instructs chat to wait the user-specified delay time for a \"RING\"",
"     from the modem, to make it pick up the phone and try to connect to the",
"     server dialing back, waiting at most 30 seconds for the modems to",
"     negotiate connection speed, and then to use the login procedure",
"     specified in the call-back script. The dial-in internal script is modified",
"     by deleting the",
" ",
"@b         ABORT		'NO CARRIER'",
" ",
"     expect-send pair, since the carrier drops when the remote side hangs-",
"     up prior to calling back.",
" ",
"@-",
"@b@m  \"Communication Options\"",
"@-",
"     Brings up a window with eight input fields and five sets of radio buttons.",
"     The \"Device\" input field is for selecting the special device file refer-",
"     ring to the modem port, /dev/modem being the default. The input field",
"     named \"Reset\" contains the modem reset string, the field named \"Init\"",
"     enables customization of the modem initialization string (before dialing),",
"     and the \"Connect String\" field allows modification of the string by which",
"     the modem employed reports the connection speed. The default reset",
"     string is \"ATZ\" which should work with most modems. The default",
"     initialization string is a simple \"AT\" command, to which you could add,",
"     e.g. when using a USR modem, an \"M0\" to disable the speaker during",
"     modem operation. Note that xispdial appends an \"H0\" to the user",
"     defined initialization string. Note here that you can use command",
"     sequences which begin with '\' in the modem \"Reset\" and/or \"Init\"",
"     strings, but you have to prepend them with an extra '\': e.g. if you want to",
"     enter \"AT \\N2\" in the modem init string, you need to enter \"AT \\\\N2\" in",
"     the \"Init:\" input field. The string used for modem connection speed",
"     reporting is by default assumed to be \"CONNECT\". The sets of radio",
"     buttons enable selection of modem port (i.e. DCE<->DTE interface)",
"     speed, port flow control used (hardware or software), dialing mode (tone,",
"     pulse, ISDN) and type of software compression. The \"Dialing extras\"",
"     input field allows defining extra command characters (up to 8 in total)",
"     to be inserted between \"AT\" and \"D\" when dialing. The \"SW",
"     Compression\" section allows you to choose one of two compression",
"     methods available, or to turn compression off completely. Note that",
"     \"BSD\" compression will only work of your PPP subsystem was built to",
"     support it; on ix86 Linux systems this happens if you build PPP support",
"     as a kernel module. The \"Level\" input field is the transmit and receive",
"     compression level as explained in the pppd(8) manual page, having a",
"     default value of 12. The last two input fields enable selection of the",
"     asyncmap and escape options provided by pppd; see the pppd(8)",
"     manual page for details on their function. The vast majority of dialup",
"     setups won't need the escape parameter, and that is the reason why it",
"     is off by default. The value of asyncmap, on the other hand, is auto-",
"     matically adjusted by your selection of flow control, i.e. whenever you",
"     change flow control type, the default value for asyncmap is inserted in",
"     the input field. Although the two default values should be adequate for",
"     general use, you can modify them further, to suit your needs.",
" ",
"@-",
"@b@m  \"TCP/IP Options\"",
"@-",
"     Brings up a window with seven input fields and four sets of radio",
"     buttons. With the exception of the primary and secondary DNS server",
"     entries, all remaining fields in this form are options which should",
"     only be changed if you understand their function; the default values",
"     are what you would need for your typical ISP connection. Please",
"     refer to the pppd(8) manual page for reading details on the function",
"     of these parameters, when you need to change their values. The last",
"     set of radio buttons enables DNS support via the ip-up and ip-down",
"     scripts, allowing  the user to enter IP addresses for a primary and",
"     (possibly) a secondary DNS server. The ip-up and ip-down scripts",
"     normally reside in /etc/ppp, and are automatically invoked by pppd",
"     when the link is set-up and torn-down respectively. Enabling this",
"     option will instruct xisp to do two things. Firstly, to call pppd with",
"     the extra option 'ipparam', passing a string as a sixth argument to",
"     ip-up and ip-down; this string contains the name of the pipe node",
"     from which xisp reads xispdial output, the description string entered",
"     via the \"Account Information\" form, and the primary (and possibly",
"     secondary) DNS server IP addresses entered via the corresponding",
"     input fields. Secondly, to read extra input from the named pipe node,",
"     after xispdial terminates, effectively writing any output from ip-up",
"     and ip-down to the xisp browser. The ip-up and ip-down scripts",
"     provided with xisp, must be installed in /etc/ppp for the xisp DNS",
"     settings to have any effect. Both ip-up and ip-down include user",
"     customizable sections for performing tasks like, for example,",
"     downloading mail or news, on a per ISP basis.",
" ",
"@-",
"@b@m  \"Paths Setup\"",
"@-",
"     Enables editing the paths to a) the pppd daemon, b) the location",
"     where pppd saves its process ID files, c) the chat utility, d) the",
"     xispdial and xispterm utilities and e) the location where xisp shall",
"     create/maintain the named pipe node used for communicating with",
"     its components. All five paths are entered in corresponding input",
"     fields. For the first 4, the \"Default\" button restores the path to its",
"     built-in default value specified during compilation. The \"Status:\"",
"     field beside each one of the first 4 entries will contain \"OK\" if the",
"     program binaries are indeed found in the specified path, or \"Error\"",
"     otherwise.",
"     IMPORTANT NOTE: the last path, i.e. the path to the named-pipe",
"     node, should NOT be on an NFS mounted filesystem.",
" ",
"  The \"Logging\" menu contains two items, \"Logging Options\" and",
"  \"Statistics\".",
" ",
"@-",
"@b@m  \"Logging Options\"",
"@-",
"     Brings up a window with  two sets of radio buttons, two drop choice",
"     lists, three buttons for phone company (PTT) manipulation, and an",
"     information display browser. The radio button set for the \"OnLine",
"     Counter\", enables selection of either \"time in seconds\" or \"call",
"     charge\" in local currency, as display option on the main program",
"     window. The other set of radio buttons enables selection of the",
"     logging period, affecting the file names of log files in the xisp logging",
"     directory $HOME/.xisplogs. Unless \"None\" is selected, two logging ",
"     files are kept. One keeps track of the total time (in seconds) spent",
"     online as well as the total number of units charged (in the case when",
"     the chosen phone company charging method is \"per minute\" rather",
"     than \"in units\", this number is the total cost instead). The other log",
"     file keeps ISP connection logs for the desired logging period. The first",
"     file has the base name \"xispcost\" and suffixes of \".W<week number>\",",
"     \".<abbr. month>\" or \".B<month-pair number>\", depending on",
"     whether \"Weekly\", \"Monthly\" or \"Bimonthly\" logging is selected.",
"     The second log file has base name \"xisplog\" and the same suffix as",
"      the first one. As an example, for date:",
" ",
"@c \"Fri Sep 26 17:08:39 EET DST 1997\"",
" ",
"     the suffixes would be \".W39\", \".Sep\" or \".B5\" corresponding to",
"     \"Weekly\", \"Monthly\" or \"Bimonthly\" logging periods. Whenever the",
"     phone company and/or the logging period is changed, the old log file",
"     is renamed to <the old name>.bak, and a new one is created. The two",
"     drop choice lists are for selecting one of the supported phone",
"     companies and the charging zone from the zones defined for each",
"     company. The \"Edit PTT\" button brings up the PTT editor form",
"     for the selected PTT. This editor has its own help text, describing",
"     the usage of all supported PTT information fields, and explaining",
"     how user information is employed by the PTT tarrif calculations.",
"     The \"Add PTT\" button creates a new phone company entry in file",
"     $HOME/.xisplogs/xispPTTs, prompting the user for the new PTT name,",
"     and then starting the PTT editor. The \"Remove PTT\" button removes",
"     the PTT entry currently selected. The information browser displays",
"     charging method and costs for all zones and time-of-day categories",
"     defined for the currently selected PTT. These categories are simply",
"     different charging tariffs used by the phone company for different",
"     times of day and night.",
" ",
"@-",
"@b@m  \"Statistics\"",
"@-",
"     Displays time/cost information collected in the xispcost.* files,",
"     according to the logging period selected. It displays the number of",
"     online seconds and total cost for each period on a text browser,",
"     and also displays a bar chart of costs for each corresponding period,",
"     and a pie chart with the yearly cost breakdown per period. The bar",
"     chart uses yellow color for the periods prior to the current one, white",
"     for the current period and dark cyan for the remaining periods up to",
"     the end of the current year. These remaining periods are assumed to",
"     belong to cost information collected during the previous year. For",
"     this reason, two different total time and cost values are calculated",
"     and displayed on the text browser, one for the periods up to and",
"     including the current one, and one for the remaining periods to the",
"     end of the year. The pie chart employs alternating yellow and dark",
"     cyan colors for clarity; the slice corresponding to the current period",
"     is white. Note that this menu option is active only if connection logs",
"     have been enabled from \"Logging Options\".",
" ",
"@-",
"@b@m  Main (top level) window",
"@-",
"  The main window includes one status and three connection indicators.",
"  The status indicator appears below the program icon, indicating the",
"  current interface state. There are three distinct states: \"OFF-LINE\"",
"  for \"disconnected\", \"XISPDIAL\" indicating that dialing is in progress",
"  and \"ON-LINE\". The \"Assigned IP Address:\" indicator prints the IP",
"  address assigned to your PPP interface after successfully establishing",
"  a link. The \"Modem Speed:\" indicator prints the speed as returned by the",
"  modem connection-speed string, and the \"Time On-Line\"/\"Call Charges\"",
"  indicator measures your connection time or charges with a resolution",
"  of five seconds. The measured time (or sum of charges) will remain",
"  there after disconnection, until a new dialing sequence is initiated.",
"  The IP address can be selected for later pasting in some other window",
"  by clicking the left mouse button on the IP readout. Clicking again",
"  deselects it.",
" ",
"@-",
"@b@m  NT-RAS call-back support",
"@-",
"  In order for NT-RAS call-back to work you need:",
" ",
"  1. To have a patched version of pppd which includes support for",
"     NT-RAS call-back. Patches exist for relatively old (e.g. 2.2.0f), as",
"     well as for recent (e.g. 2.3.8) versions of pppd. The xisp source",
"     distribution includes a patch for pppd-2.2.0f in subdirectory ./contrib;",
"     the patch for version 2.3.x is included in the official pppd source",
"     distribution (files README.cbcp and README.mschap80 include all",
"     necessary information/instructions).",
" ",
"  2. If the NT box is part of a domain and your account is a domain",
"     (as opposed to a local) account, then the user name both in xisp's",
"     \"User/Name:\" input field (\"Account Information\" form), and in the",
"     /etc/ppp/chap-secrets file, must include the domain name. Assuming",
"     for example that the domain name is \"MYDOMAIN\" and the user",
"     name is \"dbouras\", the \"User/Name:\" input field must contain:",
" ",
"@cMYDOMAIN\\dbouras",
" ",
"     while the \"Remotename:\" input field may contain the word:",
" ",
"@cras",
" ",
"     In such a case, the /etc/ppp/chap-secrets file must contain the",
"     following two entries:",
" ",
"@cMYDOMAIN\\\\dbouras  ras  my_password",
"@cras  MYDOMAIN\\\\dbouras  my_password",
" ",
"    NOTES: - the double backslash between NT domain name and user",
"                   account name above is NOT a typographical mistake; it needs",
"                   to be that way in file /etc/ppp/chap-secrets. Contrary to this,",
"                   in the \"User/Name:\" input field you need only one backslash",
" ",
"                - the remote name \"ras\" can be anything you choose since",
"                   it is ignored at the NT side. However, it must be the same",
"                   in the \"Remotename:\" input field in the \"Account Information\"",
"                   form, and in the two lines in file /etc/ppp/chap-secrets.",
" ",
"  3. If your NT account is local to the RAS server and it has dial-in",
"     privileges, then you don't need to specify the domain name in xisp's",
"     \"User/Name:\" input field, nor in file /etc/ppp/chap-secrets. In such a",
"     case, and for the above example, the entries in file /etc/ppp/chap-secrets",
"     would be:",
" ",
"@cdbouras  ras  my_password",
"@cras  dbouras  my_password",
" ",
"     while the \"User/Name:\" input field should contain simply the account",
"     name \"dbouras\"",
" "
};

