/* $XFree86: xc/programs/Xserver/hw/xfree86/drivers/ivtv/ivtv.c,v 1.42 2002/10/10 01:35:20 dawes Exp $ */

/*
 * Authors:  Alan Hourihane, <alanh@fairlite.demon.co.uk>
 *	     Michel Dnzer, <michdaen@iiic.ethz.ch>
 */

#include "config.h"
#include "ivtvhw.h"
#include "ivtvdev.h"
/* all driver need this */
#include "xf86.h"
#include "xf86_OSproc.h"
#include "xf86_ansic.h"

#include "mipointer.h"
#include "mibstore.h"
#include "micmap.h"
#include "colormapst.h"
#include "xf86cmap.h"
#include "shadow.h"

/* for visuals */
#include "fb.h"

#include "xf86Resources.h"
#include "xf86RAC.h"

#ifdef XvExtension
#include "xf86xv.h"
#endif
enum HAUPAGE_CHIPTAGS {
	PVR_UNKNOWN = 0,
	PVR_350,
	PVR_LAST
};
#define PCI_CHIP_PVR350         0x0803

static SymTabRec IVTVChipsets[] = {
	{PVR_350, "PVR-350"},
	{-1, NULL}
};

/* This table maps a PCI device ID to a chipset family identifier. */
static PciChipsets IVTVPciChipsets[] = {
	{PVR_350, PCI_CHIP_PVR350, RES_SHARED_VGA},
	{-1, -1, RES_UNDEFINED}
};

#define DEBUG 0

#if DEBUG
# define TRACE_ENTER(str)       ErrorF("ivtv: " str " %d\n",pScrn->scrnIndex)
# define TRACE_EXIT(str)        ErrorF("ivtv: " str " done\n")
# define TRACE(str)             ErrorF("ivtv trace: " str "\n")
#else
# define TRACE_ENTER(str)
# define TRACE_EXIT(str)
# define TRACE(str)
#endif

/* -------------------------------------------------------------------- */
/* prototypes                                                           */

static const OptionInfoRec *IVTVDevAvailableOptions(int chipid, int busid);
static void IVTVDevIdentify(int flags);
static Bool IVTVDevProbe(DriverPtr drv, int flags);
static Bool IVTVDevPreInit(ScrnInfoPtr pScrn, int flags);
static Bool IVTVDevScreenInit(int Index, ScreenPtr pScreen, int argc,
			      char **argv);
static Bool IVTVDevCloseScreen(int scrnIndex, ScreenPtr pScreen);

/* -------------------------------------------------------------------- */

/*
 * This is intentionally screen-independent.  It indicates the binding
 * choice made in the first PreInit.
 */
static int pix24bpp = 0;

#define VERSION			4000
#define IVTVDEV_NAME		"IVTVDEV_TST"
#define IVTVDEV_DRIVER_NAME	"ivtvdev"
#define IVTVDEV_MAJOR_VERSION	0
#define IVTVDEV_MINOR_VERSION	10

DriverRec IVTVDEV = {
	VERSION,
	IVTVDEV_DRIVER_NAME,
#if 0
	"driver for linux framebuffer devices",
#endif
	IVTVDevIdentify,
	IVTVDevProbe,
	IVTVDevAvailableOptions,
	NULL,
	0
};

/* Supported options */
typedef enum {
	OPTION_IVTVDEV
} IVTVDevOpts;

static const OptionInfoRec IVTVDevOptions[] = {
	{OPTION_IVTVDEV, "ivtv", OPTV_STRING, {0}, FALSE},
	{-1, NULL, OPTV_NONE, {0}, FALSE}
};

/* -------------------------------------------------------------------- */

static const char *fbSymbols[] = {
	"fbScreenInit",
	"fbPictureInit",
	NULL
};

static const char *shadowSymbols[] = {
	"shadowAdd",
	"shadowAlloc",
	"shadowInit",
	"shadowSetup",
	"shadowUpdatePacked",
	"shadowUpdateRotatePacked",
	NULL
};

#ifdef XFree86LOADER

MODULESETUPPROTO(IVTVDevSetup);

static XF86ModuleVersionInfo IVTVDevVersRec = {
	"ivtv",
	MODULEVENDORSTRING,
	MODINFOSTRING1,
	MODINFOSTRING2,
	XF86_VERSION_CURRENT,
	IVTVDEV_MAJOR_VERSION, IVTVDEV_MINOR_VERSION, 6,
	ABI_CLASS_VIDEODRV,
	ABI_VIDEODRV_VERSION,
	NULL,
	{0, 0, 0, 0}
};

XF86ModuleData ivtvdevModuleData = { &IVTVDevVersRec, IVTVDevSetup, NULL };

pointer IVTVDevSetup(pointer module, pointer opts, int *errmaj, int *errmin)
{
	static Bool setupDone = FALSE;

	if (!setupDone) {
		setupDone = TRUE;
		xf86AddDriver(&IVTVDEV, module, 0);
		LoaderRefSymLists(fbSymbols, shadowSymbols, NULL);
		return (pointer) 1;
	} else {
		if (errmaj)
			*errmaj = LDR_ONCEONLY;
		return NULL;
	}
}

#endif				/* XFree86LOADER */

void FBshadowUpdatePacked(ScreenPtr pScreen, shadowBufPtr pBuf)
{

	RegionPtr damage = &pBuf->damage;
	int nbox = REGION_NUM_RECTS(damage);
	BoxPtr pbox = REGION_RECTS(damage);

	ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
	IVTVDevPtr fPtr = IVTVDEVPTR(pScrn);
	int x1 = pScrn->virtualX;
	int x2 = 0;
	int y1 = pScrn->virtualY;
	int y2 = 0;
	while (nbox--) {
		if (pbox->x1 < x1)
			x1 = pbox->x1;
		if (pbox->x2 > x2)
			x2 = pbox->x2;
		if (pbox->y1 < y1)
			y1 = pbox->y1;
		if (pbox->y2 > y2)
			y2 = pbox->y2;
		pbox++;
	};

	ivtvHWSendDMA(pScrn, fPtr->shadowmem, x1, x2, y1, y2);
}

static Bool IVTVDevGetRec(ScrnInfoPtr pScrn)
{
	if (pScrn->driverPrivate != NULL)
		return TRUE;

	pScrn->driverPrivate = xnfcalloc(sizeof(IVTVDevRec), 1);
	return TRUE;
}

static void IVTVDevFreeRec(ScrnInfoPtr pScrn)
{
	if (pScrn->driverPrivate == NULL)
		return;
	xfree(pScrn->driverPrivate);
	pScrn->driverPrivate = NULL;
}

/* -------------------------------------------------------------------- */

static const OptionInfoRec *IVTVDevAvailableOptions(int chipid, int busid)
{
	return IVTVDevOptions;
}

static void IVTVDevIdentify(int flags)
{
	xf86PrintChipsets(IVTVDEV_NAME, "driver for framebuffer", IVTVChipsets);
}

static Bool IVTVDevProbe(DriverPtr drv, int flags)
{
	int i;
	ScrnInfoPtr pScrn;
	GDevPtr *devSections;
	int numDevSections;
	int bus, device, func;
	char *dev;
	Bool foundScreen = FALSE;
	int *usedChips;
	int numUsed;
	TRACE("probe start");

	/* For now, just bail out for PROBE_DETECT. */
	if (flags & PROBE_DETECT)
		return FALSE;

	/* sanity checks */
	if ((numDevSections =
	     xf86MatchDevice(IVTVDEV_DRIVER_NAME, &devSections)) <= 0)
		return FALSE;

	if (xf86GetPciVideoInfo() == NULL)
		return FALSE;

	numUsed = xf86MatchPciInstances(IVTVDEV_DRIVER_NAME,
					PCI_HAUPAGGE_VENDOR_ID,
					IVTVChipsets,
					IVTVPciChipsets,
					devSections,
					numDevSections, drv, &usedChips);

	if (numUsed <= 0)
		return FALSE;

	if (flags & PROBE_DETECT) {
		foundScreen = TRUE;
	} else {
		for (i = 0; i < numUsed; i++) {
			ScrnInfoPtr pScrn = xf86AllocateScreen(drv, 0);
			EntityInfoPtr pEnt;
			dev =
			    xf86FindOptionValue(devSections[i]->options,
						"fbdev");
			if (ivtvHWProbe(NULL, dev, NULL)) {
				pScrn =
				    xf86ConfigPciEntity(pScrn, 0, usedChips[i],
							IVTVPciChipsets, 0, 0,
							0, 0, 0);

				/* xf86DrvMsg() can't be called without setting these */
				pScrn->driverName = IVTVDEV_DRIVER_NAME;
				pScrn->name = IVTVDEV_NAME;

				if (pScrn) {
					foundScreen = TRUE;

					pScrn->driverVersion = VERSION;
					pScrn->driverName = IVTVDEV_DRIVER_NAME;
					pScrn->name = IVTVDEV_NAME;
					pScrn->Probe = IVTVDevProbe;
					pScrn->PreInit = IVTVDevPreInit;
					pScrn->ScreenInit = IVTVDevScreenInit;
					pScrn->SwitchMode = ivtvHWSwitchMode;
					pScrn->AdjustFrame = ivtvHWAdjustFrame;
					pScrn->EnterVT = ivtvHWEnterVT;
					pScrn->LeaveVT = ivtvHWLeaveVT;
					pScrn->ValidMode = ivtvHWValidMode;

					xf86DrvMsg(pScrn->scrnIndex, X_INFO,
						   "using %s\n",
						   dev ? dev :
						   "default device");
				}
			}
		}
	}
	xfree(devSections);
	TRACE("probe done");
	return foundScreen;
}

static Bool IVTVDevPreInit(ScrnInfoPtr pScrn, int flags)
{
	IVTVDevPtr fPtr;
	int default_depth, fbbpp;
	const char *mod = NULL;
	const char **syms = NULL;

	if (flags & PROBE_DETECT)
		return FALSE;

	TRACE_ENTER("PreInit");

	/* Check the number of entities, and fail if it isn't one. */
	if (pScrn->numEntities != 1)
		return FALSE;

	pScrn->monitor = pScrn->confScreen->monitor;

	IVTVDevGetRec(pScrn);
	fPtr = IVTVDEVPTR(pScrn);

	fPtr->pEnt = xf86GetEntityInfo(pScrn->entityList[0]);

	pScrn->racMemFlags = RAC_FB | RAC_COLORMAP | RAC_CURSOR | RAC_VIEWPORT;
	/* XXX Is this right?  Can probably remove RAC_FB */
	pScrn->racIoFlags = RAC_FB | RAC_COLORMAP | RAC_CURSOR | RAC_VIEWPORT;

	if (fPtr->pEnt->location.type == BUS_PCI &&
	    xf86RegisterResources(fPtr->pEnt->index, NULL, ResExclusive)) {
		xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
			   "xf86RegisterResources() found resource conflicts\n");
		return FALSE;
	}

	/* open device */
	if (!ivtvHWInit
	    (pScrn, NULL,
	     xf86FindOptionValue(fPtr->pEnt->device->options, "fbdev")))
		return FALSE;
	default_depth = ivtvHWGetDepth(pScrn, &fbbpp);
	if (!xf86SetDepthBpp(pScrn, default_depth, default_depth, fbbpp, 0))
		return FALSE;
	xf86PrintDepthBpp(pScrn);

	/* Get the depth24 pixmap format */
	if (pScrn->depth == 24 && pix24bpp == 0)
		pix24bpp = xf86GetBppFromDepth(pScrn, 24);

	/* color weight */
	if (pScrn->depth > 8) {
		rgb zeros = { 0, 0, 0 };
		if (!xf86SetWeight(pScrn, zeros, zeros))
			return FALSE;
	}

	/* visual init */
	if (!xf86SetDefaultVisual(pScrn, -1))
		return FALSE;

	/* We don't currently support DirectColor at > 8bpp */
	if (pScrn->depth > 8 && pScrn->defaultVisual != TrueColor) {
		xf86DrvMsg(pScrn->scrnIndex, X_ERROR, "Given default visual"
			   " (%s) is not supported at depth %d\n",
			   xf86GetVisualName(pScrn->defaultVisual),
			   pScrn->depth);
		return FALSE;
	}

	{
		Gamma zeros = { 0.0, 0.0, 0.0 };

		if (!xf86SetGamma(pScrn, zeros)) {
			return FALSE;
		}
	}

	pScrn->progClock = TRUE;
	pScrn->rgbBits = 8;
	pScrn->chipset = "ivtvdev";
	pScrn->videoRam = ivtvHWGetVidmem(pScrn);

	xf86DrvMsg(pScrn->scrnIndex, X_INFO, "Hardware: %s (vidmem: %dk)\n",
		   ivtvHWGetName(pScrn), pScrn->videoRam / 1024);

	/* handle options */
	xf86CollectOptions(pScrn, NULL);
	if (!(fPtr->Options = xalloc(sizeof(IVTVDevOptions))))
		return FALSE;
	memcpy(fPtr->Options, IVTVDevOptions, sizeof(IVTVDevOptions));
	xf86ProcessOptions(pScrn->scrnIndex, fPtr->pEnt->device->options,
			   fPtr->Options);

	/* select video modes */

	xf86DrvMsg(pScrn->scrnIndex, X_INFO,
		   "Checking Modes against framebuffer device...\n");
	ivtvHWSetVideoModes(pScrn);

	xf86DrvMsg(pScrn->scrnIndex, X_INFO,
		   "Checking Modes against monitor...\n");
	{
		DisplayModePtr mode, first = mode = pScrn->modes;

		if (mode != NULL)
			do {
				mode->status =
				    xf86CheckModeForMonitor(mode,
							    pScrn->monitor);
				mode = mode->next;
			} while (mode != NULL && mode != first);

		xf86PruneDriverModes(pScrn);
	}

	if (NULL == pScrn->modes)
		ivtvHWUseBuildinMode(pScrn);
	pScrn->currentMode = pScrn->modes;

	pScrn->displayWidth = pScrn->virtualX;	/* ShadowFB handles this correctly */

	xf86PrintModes(pScrn);

	/* Set display resolution */
	xf86SetDpi(pScrn, 0, 0);

	/* Load bpp-specific modules */
	mod = "fb";
	syms = fbSymbols;

	if (mod && xf86LoadSubModule(pScrn, mod) == NULL) {
		IVTVDevFreeRec(pScrn);
		return FALSE;
	}
	if (mod && syms) {
		xf86LoaderReqSymLists(syms, NULL);
	}

	/* Load shadow */
	xf86DrvMsg(pScrn->scrnIndex, X_CONFIG,
		   "Using \"Shadow Framebuffer\"\n");
	if (!xf86LoadSubModule(pScrn, "shadow")) {
		IVTVDevFreeRec(pScrn);
		return FALSE;
	}
	xf86LoaderReqSymLists(shadowSymbols, NULL);

	TRACE_EXIT("PreInit");
	return TRUE;
}

void IvtvInitVideo(ScreenPtr pScreen);

static Bool
IVTVDevScreenInit(int scrnIndex, ScreenPtr pScreen, int argc, char **argv)
{
	ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
	IVTVDevPtr fPtr = IVTVDEVPTR(pScrn);
	VisualPtr visual;
	int init_picture = 0;
	int ret, flags, width, height;

	TRACE_ENTER("IVTVDevScreenInit");

	ErrorF("\tbitsPerPixel=%d, depth=%d, defaultVisual=%s\n"
	       "\tmask: %x,%x,%x, offset: %d,%d,%d\n",
	       pScrn->bitsPerPixel,
	       pScrn->depth,
	       xf86GetVisualName(pScrn->defaultVisual),
	       pScrn->mask.red, pScrn->mask.green, pScrn->mask.blue,
	       pScrn->offset.red, pScrn->offset.green, pScrn->offset.blue);

	ivtvHWSave(pScrn);

	if (!ivtvHWModeInit(pScrn, pScrn->currentMode)) {
		xf86DrvMsg(scrnIndex, X_ERROR, "Mode init failed\n");
		return FALSE;
	}
	ivtvHWSaveScreen(pScreen, SCREEN_SAVER_ON);
	ivtvHWAdjustFrame(scrnIndex, 0, 0, 0);

	/* mi layer */
	miClearVisualTypes();
	if (pScrn->bitsPerPixel > 8) {
		if (!miSetVisualTypes
		    (pScrn->depth, TrueColorMask, pScrn->rgbBits, TrueColor)) {
			xf86DrvMsg(scrnIndex, X_ERROR,
				   "Set visual types failed\n");
			return FALSE;
		}
	} else {
		if (!miSetVisualTypes(pScrn->depth,
				      miGetDefaultVisualMask(pScrn->depth),
				      pScrn->rgbBits, pScrn->defaultVisual)) {
			xf86DrvMsg(scrnIndex, X_ERROR,
				   "Set visual types failed\n");
			return FALSE;
		}
	}
	if (!miSetPixmapDepths()) {
		xf86DrvMsg(scrnIndex, X_ERROR, "Set pixmap depths failed\n");
		return FALSE;
	}

	height = pScrn->virtualY;
	width = pScrn->virtualX;

	/* shadowfb */
	if ((fPtr->shadowmem = shadowAlloc(width, height,
					   pScrn->bitsPerPixel)) == NULL) {
		xf86DrvMsg(scrnIndex, X_ERROR,
			   "Allocation of shadow memory failed\n");
		return FALSE;
	}

	ret = fbScreenInit(pScreen, fPtr->shadowmem, width, height,
			   pScrn->xDpi, pScrn->yDpi, pScrn->displayWidth,
			   pScrn->bitsPerPixel);
	init_picture = 1;

	if (!ret)
		return FALSE;

	if (pScrn->bitsPerPixel > 8) {
		/* Fixup RGB ordering */
		visual = pScreen->visuals + pScreen->numVisuals;
		while (--visual >= pScreen->visuals) {
			if ((visual->class | DynamicClass) == DirectColor) {
				visual->offsetRed = pScrn->offset.red;
				visual->offsetGreen = pScrn->offset.green;
				visual->offsetBlue = pScrn->offset.blue;
				visual->redMask = pScrn->mask.red;
				visual->greenMask = pScrn->mask.green;
				visual->blueMask = pScrn->mask.blue;
			}
		}
	}

	/* must be after RGB ordering fixed */
	if (init_picture && !fbPictureInit(pScreen, NULL, 0))
		xf86DrvMsg(pScrn->scrnIndex, X_WARNING,
			   "RENDER extension initialisation failed.\n");

	if (!shadowSetup(pScreen) || !shadowAdd(pScreen, NULL,
						FBshadowUpdatePacked,
						NULL, 0, NULL)) {
		xf86DrvMsg(scrnIndex, X_ERROR,
			   "Shadow framebuffer initialization failed.\n");
		return FALSE;
	}

	/*      IVTVDGAInit(pScreen);
	 */

	if (pScrn->bitsPerPixel == 24)
		xf86DrvMsg(scrnIndex, X_WARNING,
			   "Rotation might be broken in 24 bpp\n");

	xf86SetBlackWhitePixels(pScreen);
	miInitializeBackingStore(pScreen);
	xf86SetBackingStore(pScreen);

	/* software cursor */
	miDCInitialize(pScreen, xf86GetPointerScreenFuncs());

	/* XXX It would be simpler to use miCreateDefColormap() in all cases. */
	if (!miCreateDefColormap(pScreen))
		return FALSE;

	flags = CMAP_PALETTED_TRUECOLOR;
	if (!xf86HandleColormaps
	    (pScreen, 256, 8, ivtvHWLoadPalette, NULL, flags))
		return FALSE;

	xf86DPMSInit(pScreen, ivtvHWDPMSSet, 0);

	pScreen->SaveScreen = ivtvHWSaveScreen;

	/* Wrap the current CloseScreen function */
	fPtr->CloseScreen = pScreen->CloseScreen;
	pScreen->CloseScreen = IVTVDevCloseScreen;

	{
            ErrorF("Init Video\n");
		IvtvInitVideo(pScreen);
	}

	TRACE_EXIT("IVTVDevScreenInit");

	return TRUE;
}

static Bool IVTVDevCloseScreen(int scrnIndex, ScreenPtr pScreen)
{
	ScrnInfoPtr pScrn = xf86Screens[scrnIndex];
	IVTVDevPtr fPtr = IVTVDEVPTR(pScrn);

	ivtvHWRestore(pScrn);
	xfree(fPtr->shadowmem);
	pScrn->vtSema = FALSE;

	pScreen->CloseScreen = fPtr->CloseScreen;
	return (*pScreen->CloseScreen) (scrnIndex, pScreen);
}
