/* $XFree86: xc/programs/Xserver/hw/xfree86/ivtvhw/ivtvhw.c,v 1.30 2002/11/25 14:05:00 eich Exp $ */

#include "config.h"
#include <asm/page.h>		/* #define for PAGE_* */

#include "ivtvhw.h"

/* all driver need this */
#include "xf86.h"
#include "xf86_OSproc.h"
#include "xf86_ansic.h"

/* pci stuff */
#include "xf86PciInfo.h"
#include "xf86Pci.h"

#include "xf86cmap.h"

#include <linux/fb.h>

#include "globals.h"
#define DPMS_SERVER
#include <X11/extensions/dpms.h>

#define DEBUG 0

#if DEBUG
# define TRACE_ENTER(str)	ErrorF("ivtvHW: " str " %d\n",pScrn->scrnIndex)
#else
# define TRACE_ENTER(str)
#endif

/* -------------------------------------------------------------------- */

#ifdef XFree86LOADER

static MODULESETUPPROTO(ivtvhwSetup);

static XF86ModuleVersionInfo ivtvHWVersRec = {
	"ivtvhw",
	MODULEVENDORSTRING,
	MODINFOSTRING1,
	MODINFOSTRING2,
	XF86_VERSION_CURRENT,
	0, 0, 2,
	ABI_CLASS_VIDEODRV,
	ABI_VIDEODRV_VERSION,
	MOD_CLASS_NONE,
	{0, 0, 0, 0}
};

XF86ModuleData ivtvhwModuleData = { &ivtvHWVersRec, ivtvhwSetup, NULL };

static pointer
ivtvhwSetup(pointer module, pointer opts, int *errmaj, int *errmin)
{
	const char *osname;

	/* Check that we're being loaded on a Linux system */
	LoaderGetOS(&osname, NULL, NULL, NULL);
	if (!osname || strcmp(osname, "linux") != 0) {
		if (errmaj)
			*errmaj = LDR_BADOS;
		if (errmin)
			*errmin = 0;
		return NULL;
	} else {
		/* OK */
		return (pointer) 1;
	}
}

#else				/* XFree86LOADER */

#include <fcntl.h>
#include <errno.h>
#include <sys/mman.h>

#endif				/* XFree86LOADER */

/* -------------------------------------------------------------------- */
/* our private data, and two functions to allocate/free this            */

int ivtvHWPrivateIndex = -1;

Bool ivtvHWGetRec(ScrnInfoPtr pScrn)
{
	ivtvHWPtr fPtr;

	if (ivtvHWPrivateIndex < 0)
		ivtvHWPrivateIndex = xf86AllocateScrnInfoPrivateIndex();

	if (FBDEVHWPTR(pScrn) != NULL)
		return TRUE;

	fPtr = FBDEVHWPTRLVAL(pScrn) = xnfcalloc(sizeof(ivtvHWRec), 1);
	return TRUE;
}

void ivtvHWFreeRec(ScrnInfoPtr pScrn)
{
	if (ivtvHWPrivateIndex < 0)
		return;
	if (FBDEVHWPTR(pScrn) == NULL)
		return;
	xfree(FBDEVHWPTR(pScrn));
	FBDEVHWPTRLVAL(pScrn) = NULL;
}

/* -------------------------------------------------------------------- */
/* some helpers for printing debug informations                         */

#if DEBUG
static void print_ivtv_mode(char *txt, struct fb_var_screeninfo *var)
{
	ErrorF("ivtv %s mode:\t%d   %d %d %d %d   %d %d %d %d   %d %d:%d:%d\n",
	       txt, var->pixclock,
	       var->xres, var->right_margin, var->hsync_len, var->left_margin,
	       var->yres, var->lower_margin, var->vsync_len, var->upper_margin,
	       var->bits_per_pixel,
	       var->red.length, var->green.length, var->blue.length);
}

static void print_xfree_mode(char *txt, DisplayModePtr mode)
{
	ErrorF("xfree %s mode:\t%d   %d %d %d %d   %d %d %d %d\n",
	       txt, mode->Clock,
	       mode->HDisplay, mode->HSyncStart, mode->HSyncEnd, mode->HTotal,
	       mode->VDisplay, mode->VSyncStart, mode->VSyncEnd, mode->VTotal);
}
#endif

/* -------------------------------------------------------------------- */
/* Convert timings between the XFree and the Frame Buffer Device        */

static void
xfree2ivtv_fblayout(ScrnInfoPtr pScrn, struct fb_var_screeninfo *var)
{
	var->xres_virtual = pScrn->virtualX;
	var->yres_virtual = pScrn->virtualY;
	var->bits_per_pixel = pScrn->bitsPerPixel;
	var->red.length = pScrn->weight.red;
	var->green.length = pScrn->weight.green;
	var->blue.length = pScrn->weight.blue;
}

static void
xfree2ivtv_timing(DisplayModePtr mode, struct fb_var_screeninfo *var)
{
	var->xres = mode->HDisplay;
	var->yres = mode->VDisplay;
	if (var->xres_virtual < var->xres)
		var->xres_virtual = var->xres;
	if (var->yres_virtual < var->yres)
		var->yres_virtual = var->yres;
	var->xoffset = var->yoffset = 0;
	var->pixclock = mode->Clock ? 1000000000 / mode->Clock : 0;
	var->right_margin = mode->HSyncStart - mode->HDisplay;
	var->hsync_len = mode->HSyncEnd - mode->HSyncStart;
	var->left_margin = mode->HTotal - mode->HSyncEnd;
	var->lower_margin = mode->VSyncStart - mode->VDisplay;
	var->vsync_len = mode->VSyncEnd - mode->VSyncStart;
	var->upper_margin = mode->VTotal - mode->VSyncEnd;
	var->sync = 0;
	if (mode->Flags & V_PHSYNC)
		var->sync |= FB_SYNC_HOR_HIGH_ACT;
	if (mode->Flags & V_PVSYNC)
		var->sync |= FB_SYNC_VERT_HIGH_ACT;
	if (mode->Flags & V_PCSYNC)
		var->sync |= FB_SYNC_COMP_HIGH_ACT;
#if 1				/* Badly needed for PAL/NTSC on Amiga (amifb)!! [geert] */
	if (mode->Flags & V_BCAST)
		var->sync |= FB_SYNC_BROADCAST;
#endif
	if (mode->Flags & V_INTERLACE)
		var->vmode = FB_VMODE_INTERLACED;
	else if (mode->Flags & V_DBLSCAN)
		var->vmode = FB_VMODE_DOUBLE;
	else
		var->vmode = FB_VMODE_NONINTERLACED;
}

static void
ivtv2xfree_timing(struct fb_var_screeninfo *var, DisplayModePtr mode)
{
	mode->Clock = var->pixclock ? 1000000000 / var->pixclock : 28000000;
	mode->HDisplay = var->xres;
	mode->HSyncStart = mode->HDisplay + var->right_margin;
	mode->HSyncEnd = mode->HSyncStart + var->hsync_len;
	mode->HTotal = mode->HSyncEnd + var->left_margin;
	mode->VDisplay = var->yres;
	mode->VSyncStart = mode->VDisplay + var->lower_margin;
	mode->VSyncEnd = mode->VSyncStart + var->vsync_len;
	mode->VTotal = mode->VSyncEnd + var->upper_margin;
	mode->Flags = 0;
	mode->Flags |= var->sync & FB_SYNC_HOR_HIGH_ACT ? V_PHSYNC : V_NHSYNC;
	mode->Flags |= var->sync & FB_SYNC_VERT_HIGH_ACT ? V_PVSYNC : V_NVSYNC;
	mode->Flags |= var->sync & FB_SYNC_COMP_HIGH_ACT ? V_PCSYNC : V_NCSYNC;
#if 1				/* Badly needed for PAL/NTSC on Amiga (amifb)!! [geert] */
	if (var->sync & FB_SYNC_BROADCAST)
		mode->Flags |= V_BCAST;
#endif
	if ((var->vmode & FB_VMODE_MASK) == FB_VMODE_INTERLACED)
		mode->Flags |= V_INTERLACE;
	else if ((var->vmode & FB_VMODE_MASK) == FB_VMODE_DOUBLE)
		mode->Flags |= V_DBLSCAN;
	mode->SynthClock = mode->Clock;
	mode->CrtcHDisplay = mode->HDisplay;
	mode->CrtcHSyncStart = mode->HSyncStart;
	mode->CrtcHSyncEnd = mode->HSyncEnd;
	mode->CrtcHTotal = mode->HTotal;
	mode->CrtcVDisplay = mode->VDisplay;
	mode->CrtcVSyncStart = mode->VSyncStart;
	mode->CrtcVSyncEnd = mode->VSyncEnd;
	mode->CrtcVTotal = mode->VTotal;
	mode->CrtcHAdjusted = FALSE;
	mode->CrtcVAdjusted = FALSE;
}

/* -------------------------------------------------------------------- */
/* open correct framebuffer device                                      */

/* try to find the framebuffer device for a given PCI device */
struct v4l2_capability {
	__u8 driver[16];	/* i.e. "bttv" */
	__u8 card[32];		/* i.e. "Hauppauge WinTV" */
	__u8 bus_info[32];	/* "PCI:" + pci_name(pci_dev) */
	__u32 version;		/* should use KERNEL_VERSION() */
	__u32 capabilities;	/* Device capabilities */
	__u32 reserved[4];
};
#define VIDIOC_QUERYCAP		_IOR  ('V',  0, struct v4l2_capability)

static int ivtv_open(int scrnIndex, char *dev, char **namep, ivtvHWPtr fPtr)
{
	struct fb_fix_screeninfo fix;
	int fd;

	/* try argument (from XF86Config) first */
	if (dev) {
		fd = open(dev, O_RDWR, 0);
	} else {
		/* second: environment variable */
		dev = getenv("FRAMEBUFFER");
		if ((NULL == dev) || ((fd = open(dev, O_RDWR, 0)) == -1)) {
			/* last try: default device */
			dev = "/dev/fb0";
			fd = open(dev, O_RDWR, 0);
		}
	}

	if (fd == -1) {
		xf86DrvMsg(scrnIndex, X_ERROR,
			   "open %s: %s\n", dev, strerror(errno));
		return -1;
	}

	if (namep) {
		if (-1 == ioctl(fd, FBIOGET_FSCREENINFO, (void *)(&fix))) {
			*namep = NULL;
			xf86DrvMsg(scrnIndex, X_ERROR,
				   "FBIOGET_FSCREENINFO: %s\n",
				   strerror(errno));
			return -1;
		} else {
			*namep = xnfalloc(16);
			strncpy(*namep, fix.id, 16);
		}
	}
	if (fd != -1 && fPtr) {
		int fbufId = 255;
		int yuvId;
                char *devid = dev+7;
                if (*devid == '/')
                    devid++;
		sscanf(devid, "%d", &fbufId);
                
                xf86DrvMsg(scrnIndex, X_ERROR,"Framebuffer id from dev %sis %d\n",dev, fbufId);

		for (yuvId = 48; yuvId < 64 && fPtr->yuvDevName == NULL;
		     yuvId++) {
			char yuvDev[20] = "/dev/video";
			char yuvDevFull[20];
			char yuvDevFull1[20];
			int yuvFd;
			sprintf(yuvDevFull, "%s%d", yuvDev, yuvId);
			yuvFd = open(yuvDevFull, O_RDONLY);
                        xf86DrvMsg(scrnIndex, X_ERROR,"open %s returned  %d\n",yuvDevFull, yuvFd);

			if (yuvFd == -1 && errno == ENODEV) {
				sprintf(yuvDevFull1, "%s%d", yuvDev,
					yuvId - 48);
				yuvFd = open(yuvDevFull1, O_RDONLY);
                                xf86DrvMsg(scrnIndex, X_ERROR,"2nd open %s returned  %d\n",yuvDevFull, yuvFd);
			}

			if (yuvFd != -1) {
				int yuvFbId=-1;
                                int ret = ioctl(yuvFd, IVTV_IOC_GET_FB, &yuvFbId);
                                xf86DrvMsg(scrnIndex, X_ERROR,"get_fb returned  %d fbid %d\n",ret, yuvFbId);
				if (ret != -1 && yuvFbId == fbufId) {
					struct v4l2_capability vcap;
					memset(&vcap, 0, sizeof(vcap));
					if (ioctl(yuvFd, VIDIOC_QUERYCAP, &vcap)
					    < 0) {
						ErrorF
						    ("Can't query driver version so not adding Xv support on %s\n",
						     yuvDevFull);
					} else {
						if (vcap.version >= 0x306) {
							fPtr->yuvDevName =
							    strdup(yuvDevFull);
						} else {
							ErrorF
							    ("Version of ivtv is too old to support Xv\n");
						}

					}
				}
				close(yuvFd);
			}

		}
	}
	return fd;
}

/* -------------------------------------------------------------------- */

Bool ivtvHWProbe(pciVideoPtr pPci, char *device, char **namep)
{
	int fd;
	Bool retVal = TRUE;
	struct ivtvfb_ioctl_state_info state;
	fd = ivtv_open(-1, device, namep, NULL);

	if (-1 == fd)
		return FALSE;

	if (0 != ioctl(fd, IVTVFB_IOCTL_GET_STATE, (void *)&state)) {
		xf86DrvMsg(0, X_ERROR,
			   "ivtvHWProvbe failed to do IVTVFB_IOCTL_GET_STATE for device %s\n",
			   device);

		retVal = FALSE;
	}
	close(fd);
	return retVal;
}

Bool ivtvHWInit(ScrnInfoPtr pScrn, pciVideoPtr pPci, char *device)
{
	ivtvHWPtr fPtr;

	TRACE_ENTER("Init");
	ivtvHWGetRec(pScrn);
	fPtr = FBDEVHWPTR(pScrn);
	fPtr->fd_yuv = -1;
	fPtr->yuvDevName = NULL;
	/* open device */

	fPtr->fd = ivtv_open(pScrn->scrnIndex, device, NULL, fPtr);

	if (-1 == fPtr->fd) {
		xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
			   "Failed to open framebuffer device, consult warnings"
			   " and/or errors above for possible reasons\n"
			   "\t(you may have to look at the server log to see"
			   " warnings)\n");
		return FALSE;
	}

	/* get current fb device settings */
	if (-1 == ioctl(fPtr->fd, FBIOGET_FSCREENINFO, (void *)(&fPtr->fix))) {
		xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
			   "ioctl FBIOGET_FSCREENINFO: %s\n", strerror(errno));
		return FALSE;
	}
	if (-1 == ioctl(fPtr->fd, FBIOGET_VSCREENINFO, (void *)(&fPtr->var))) {
		xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
			   "ioctl FBIOGET_VSCREENINFO: %s\n", strerror(errno));
		return FALSE;
	}

	/* we can use the current settings as "buildin mode" */
	ivtv2xfree_timing(&fPtr->var, &fPtr->buildin);
	fPtr->buildin.name = "current";
	fPtr->buildin.next = &fPtr->buildin;
	fPtr->buildin.prev = &fPtr->buildin;
	fPtr->buildin.type |= M_T_BUILTIN;

	return TRUE;
}

char *ivtvHWGetName(ScrnInfoPtr pScrn)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);
	return fPtr->fix.id;
}

int ivtvHWGetDepth(ScrnInfoPtr pScrn, int *fbbpp)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);

	if (fbbpp)
		*fbbpp = fPtr->var.bits_per_pixel;

	if (fPtr->fix.visual == FB_VISUAL_TRUECOLOR ||
	    fPtr->fix.visual == FB_VISUAL_DIRECTCOLOR)
		return fPtr->var.red.length + fPtr->var.green.length +
		    fPtr->var.blue.length;
	else
		return fPtr->var.bits_per_pixel;
}

int ivtvHWGetLineLength(ScrnInfoPtr pScrn)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);

	if (fPtr->fix.line_length)
		return fPtr->fix.line_length;
	else
		return fPtr->var.xres_virtual * fPtr->var.bits_per_pixel / 8;
}

int ivtvHWGetType(ScrnInfoPtr pScrn)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);
	return fPtr->fix.type;
}

int ivtvHWGetVidmem(ScrnInfoPtr pScrn)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);
	return fPtr->fix.smem_len;
}

void ivtvHWSetVideoModes(ScrnInfoPtr pScrn)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);
	int virtX = pScrn->display->virtualX;
	int virtY = pScrn->display->virtualY;
	struct fb_var_screeninfo var;
	char **modename;
	DisplayModePtr mode, this, last = NULL;

	TRACE_ENTER("VerifyModes");
	if (NULL == pScrn->display->modes)
		return;

	for (modename = pScrn->display->modes; *modename != NULL; modename++) {
		for (mode = pScrn->monitor->Modes; mode != NULL;
		     mode = mode->next)
			if (0 == strcmp(mode->name, *modename))
				break;
		if (NULL == mode) {
			xf86DrvMsg(pScrn->scrnIndex, X_INFO,
				   "\tmode \"%s\" not found\n", *modename);
			continue;
		}
		memset(&var, 0, sizeof(var));
		xfree2ivtv_timing(mode, &var);
		var.xres_virtual = virtX;
		var.yres_virtual = virtY;
		var.bits_per_pixel = pScrn->bitsPerPixel;
		var.red.length = pScrn->weight.red;
		var.green.length = pScrn->weight.green;
		var.blue.length = pScrn->weight.blue;

		var.activate = FB_ACTIVATE_TEST;
		if (var.xres_virtual < var.xres)
			var.xres_virtual = var.xres;
		if (var.yres_virtual < var.yres)
			var.yres_virtual = var.yres;
		if (-1 == ioctl(fPtr->fd, FBIOPUT_VSCREENINFO, (void *)(&var))) {
			xf86DrvMsg(pScrn->scrnIndex, X_INFO,
				   "\tmode \"%s\" test failed\n", *modename);
			continue;
		}
		xf86DrvMsg(pScrn->scrnIndex, X_INFO,
			   "\tmode \"%s\" ok\n", *modename);
		if (virtX < var.xres)
			virtX = var.xres;
		if (virtY < var.yres)
			virtY = var.yres;
		if (NULL == pScrn->modes) {
			pScrn->modes = xnfalloc(sizeof(DisplayModeRec));
			this = pScrn->modes;
			memcpy(this, mode, sizeof(DisplayModeRec));
			this->next = this;
			this->prev = this;
		} else {
			this = xnfalloc(sizeof(DisplayModeRec));
			memcpy(this, mode, sizeof(DisplayModeRec));
			this->next = pScrn->modes;
			this->prev = last;
			last->next = this;
			pScrn->modes->prev = this;
		}
		last = this;
	}
	pScrn->virtualX = virtX;
	pScrn->virtualY = virtY;
}

DisplayModePtr ivtvHWGetBuildinMode(ScrnInfoPtr pScrn)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);
	return &fPtr->buildin;
}

void ivtvHWUseBuildinMode(ScrnInfoPtr pScrn)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);

	TRACE_ENTER("UseBuildinMode");
	pScrn->modes = &fPtr->buildin;
	pScrn->virtualX = pScrn->display->virtualX;
	pScrn->virtualY = pScrn->display->virtualY;
	if (pScrn->virtualX < fPtr->buildin.HDisplay)
		pScrn->virtualX = fPtr->buildin.HDisplay;
	if (pScrn->virtualY < fPtr->buildin.VDisplay)
		pScrn->virtualY = fPtr->buildin.VDisplay;
}

/* -------------------------------------------------------------------- */

void ivtvcalculateFbmem_len(ivtvHWPtr fPtr)
{
	fPtr->fboff = (unsigned long)fPtr->fix.smem_start & ~PAGE_MASK;
	fPtr->fbmem_len = (fPtr->fboff + fPtr->fix.smem_len + ~PAGE_MASK) &
	    PAGE_MASK;
}

int ivtvHWLinearOffset(ScrnInfoPtr pScrn)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);

	TRACE_ENTER("LinearOffset");
	return fPtr->fboff;
}

/* -------------------------------------------------------------------- */

Bool ivtvHWModeInit(ScrnInfoPtr pScrn, DisplayModePtr mode)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);

	TRACE_ENTER("ModeInit");
	xfree2ivtv_fblayout(pScrn, &fPtr->var);
	xfree2ivtv_timing(mode, &fPtr->var);
#if DEBUG
	print_xfree_mode("init", mode);
	print_ivtv_mode("init", &fPtr->var);
#endif
	pScrn->vtSema = TRUE;

	/* set */
	if (0 != ioctl(fPtr->fd, FBIOPUT_VSCREENINFO, (void *)(&fPtr->var))) {
		xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
			   "FBIOPUT_VSCREENINFO: %s\n", strerror(errno));
		return FALSE;
	}
	/* read back */
	if (0 != ioctl(fPtr->fd, FBIOGET_FSCREENINFO, (void *)(&fPtr->fix))) {
		xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
			   "FBIOGET_FSCREENINFO: %s\n", strerror(errno));
		return FALSE;
	}
	if (0 != ioctl(fPtr->fd, FBIOGET_VSCREENINFO, (void *)(&fPtr->var))) {
		xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
			   "FBIOGET_VSCREENINFO: %s\n", strerror(errno));
		return FALSE;
	}
	return TRUE;
}

/* -------------------------------------------------------------------- */
/* video mode save/restore                                              */

/* TODO: colormap */
void ivtvHWSave(ScrnInfoPtr pScrn)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);

	TRACE_ENTER("Save");
	if (0 !=
	    ioctl(fPtr->fd, FBIOGET_VSCREENINFO, (void *)(&fPtr->saved_var)))
		xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
			   "FBIOGET_VSCREENINFO: %s\n", strerror(errno));
}

void ivtvHWRestore(ScrnInfoPtr pScrn)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);

	TRACE_ENTER("Restore");
	if (0 !=
	    ioctl(fPtr->fd, FBIOPUT_VSCREENINFO, (void *)(&fPtr->saved_var)))
		xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
			   "FBIOPUT_VSCREENINFO: %s\n", strerror(errno));
}

/* -------------------------------------------------------------------- */
/* callback for xf86HandleColormaps                                     */

void
ivtvHWLoadPalette(ScrnInfoPtr pScrn, int numColors, int *indices,
		  LOCO * colors, VisualPtr pVisual)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);
	struct fb_cmap cmap;
	unsigned short red, green, blue;
	int i;

	TRACE_ENTER("ModeInit");
	cmap.len = 1;
	cmap.red = &red;
	cmap.green = &green;
	cmap.blue = &blue;
	cmap.transp = NULL;
	for (i = 0; i < numColors; i++) {
		cmap.start = indices[i];
		red = (colors[indices[i]].red << 8) | colors[indices[i]].red;
		green = (colors[indices[i]].green << 8) |
		    colors[indices[i]].green;
		blue = (colors[indices[i]].blue << 8) | colors[indices[i]].blue;
		if (-1 == ioctl(fPtr->fd, FBIOPUTCMAP, (void *)&cmap))
			xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
				   "FBIOPUTCMAP: %s\n", strerror(errno));
	}
}

/* -------------------------------------------------------------------- */
/* these can be hooked directly into ScrnInfoRec                        */

int ivtvHWValidMode(int scrnIndex, DisplayModePtr mode, Bool verbose, int flags)
{
	ScrnInfoPtr pScrn = xf86Screens[scrnIndex];
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);
	struct fb_var_screeninfo var;

	TRACE_ENTER("ValidMode");
	memcpy(&var, &fPtr->var, sizeof(var));
	xfree2ivtv_timing(mode, &var);
	var.activate = FB_ACTIVATE_TEST;
	if (0 != ioctl(fPtr->fd, FBIOPUT_VSCREENINFO, (void *)(&fPtr->var))) {
		xf86DrvMsg(scrnIndex, X_ERROR,
			   "FBIOPUT_VSCREENINFO: %s\n", strerror(errno));
		return MODE_BAD;
	}
	return MODE_OK;
}

Bool ivtvHWSwitchMode(int scrnIndex, DisplayModePtr mode, int flags)
{
	ScrnInfoPtr pScrn = xf86Screens[scrnIndex];
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);

	TRACE_ENTER("SwitchMode");
	xfree2ivtv_timing(mode, &fPtr->var);
	if (0 != ioctl(fPtr->fd, FBIOPUT_VSCREENINFO, (void *)(&fPtr->var))) {
		xf86DrvMsg(scrnIndex, X_ERROR,
			   "FBIOPUT_VSCREENINFO: %s\n", strerror(errno));
		return FALSE;
	}
	return TRUE;
}

void ivtvHWAdjustFrame(int scrnIndex, int x, int y, int flags)
{
	ScrnInfoPtr pScrn = xf86Screens[scrnIndex];
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);

	TRACE_ENTER("AdjustFrame");
#ifdef JOHN
	fPtr->var.xoffset = x;
	fPtr->var.yoffset = y;
	if (-1 == ioctl(fPtr->fd, FBIOPAN_DISPLAY, (void *)&fPtr->var))
		xf86DrvMsgVerb(scrnIndex, 5, X_WARNING,
			       "FBIOPAN_DISPLAY: %s\n", strerror(errno));
#endif
}

Bool ivtvHWEnterVT(int scrnIndex, int flags)
{
	ScrnInfoPtr pScrn = xf86Screens[scrnIndex];

	TRACE_ENTER("EnterVT");
	if (!ivtvHWModeInit(pScrn, pScrn->currentMode))
		return FALSE;
	ivtvHWAdjustFrame(scrnIndex, pScrn->frameX0, pScrn->frameY0, 0);
	return TRUE;
}

void ivtvHWLeaveVT(int scrnIndex, int flags)
{
	ScrnInfoPtr pScrn = xf86Screens[scrnIndex];

	TRACE_ENTER("LeaveVT");
	ivtvHWRestore(pScrn);
}

void ivtvHWDPMSSet(ScrnInfoPtr pScrn, int mode, int flags)
{
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);
	unsigned long fbmode;

	if (!pScrn->vtSema)
		return;

	switch (mode) {
	case DPMSModeOn:
		fbmode = 0;
		break;
	case DPMSModeStandby:
		fbmode = 2;
		break;
	case DPMSModeSuspend:
		fbmode = 3;
		break;
	case DPMSModeOff:
		fbmode = 4;
		break;
	default:
		return;
	}

#ifdef JOHN
	if (-1 == ioctl(fPtr->fd, FBIOBLANK, (void *)fbmode))
		xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
			   "FBIOBLANK: %s\n", strerror(errno));
#endif
}

Bool ivtvHWSaveScreen(ScreenPtr pScreen, int mode)
{
	ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);
	unsigned long unblank;

	if (!pScrn->vtSema)
		return TRUE;

	unblank = xf86IsUnblank(mode);

#ifdef JOHN
	if (-1 == ioctl(fPtr->fd, FBIOBLANK, (void *)(1 - unblank))) {
		xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
			   "FBIOBLANK: %s\n", strerror(errno));
		return FALSE;
	}
#endif
	return TRUE;
}

#define MAX_RETRY_DMA 10
char *lastScreen = NULL;

Bool ivtvHWSendDMA(ScrnInfoPtr pScrn, void *ptr, int x1, int x2, int y1, int y2)
{
	int totalScreenSize =
	    pScrn->virtualX * pScrn->virtualY * pScrn->bitsPerPixel / 8;
	int secondOffset = 0;

	ivtvHWPtr fPtr = FBDEVHWPTR(pScrn);
	struct ivtvfb_ioctl_dma_host_to_ivtv_args args;
	int cpt = MAX_RETRY_DMA;

	int startOffset =
	    (((y1) * pScrn->virtualX) + x1) * pScrn->bitsPerPixel / 8;
	int endOffset =
	    (((y2 - 1) * pScrn->virtualX) + x2) * pScrn->bitsPerPixel / 8;

	unsigned long totalData = endOffset - startOffset;

	if (totalData > 64 * 1024 * 4) {
		/* This is a bigger lump so send in 2 bits */
		totalData /= 2;
		totalData = (totalData + 65535) & ~65535;
		secondOffset = endOffset - totalData;
	} else
	{
		totalData = (totalData + 65535) & ~65535;

		if ((startOffset + totalData) > totalScreenSize) {
			startOffset -=
			    (startOffset + totalData) - totalScreenSize;
		}
	}

	args.source = ((char *)ptr + startOffset);
	args.dest_offset = startOffset;
	args.count = totalData;

	if (0 != ioctl(fPtr->fd, IVTVFB_IOCTL_PREP_FRAME, (void *)(&args))) {
		while (cpt--) {
			if (0 == ioctl(fPtr->fd,
				       IVTVFB_IOCTL_PREP_FRAME,
				       (void *)(&args)))
				break;
		}
	}
	if (secondOffset) {
		args.source = ((char *)ptr + secondOffset);
		args.dest_offset = secondOffset;
		args.count = totalData;

		if (0 != ioctl(fPtr->fd,
			       IVTVFB_IOCTL_PREP_FRAME, (void *)(&args))) {
			while (cpt--) {
				if (0 == ioctl(fPtr->fd,
					       IVTVFB_IOCTL_PREP_FRAME,
					       (void *)(&args)))
					break;
			}
		}
	}

	return TRUE;
}
