/* ------------------------------------------------------------------------
 * $Id: Guard.hh,v 1.3 2001/06/29 15:00:38 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-04-29 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _Guard_hh_
#define _Guard_hh_

// -- Class Declarations

/**
 * Guard template class used for enforcing mutual exclusion of
 * critical areas in a code segment. This class is designed to use any
 * class that supports the lock()/unlock() methods to effect mutual
 * exclusion in the scope of the Guard object. 
 **/
template <class T>
class Guard {
public:
    
    /**
     * Constructor. This will lock the passed mutex or semaphore.
     * 
     * @param t entity to use to protect the section.
     **/
    Guard(T &t) : _t(t) {
	_t.lock();
    }
    
    /**
     * Destructor. This will unlock the mutual exclusion entity (from
     * before).
     **/
    ~Guard() {
	_t.unlock();
    }

private:
    Guard(const Guard<T> &s);
    Guard &operator = (const Guard &);
    
    T &_t;
};

#endif /* Guard.hh */
