/* ------------------------------------------------------------------------
 * debug.hh
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-10-25 by Steve Houston.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _debug_hh_
#define _debug_hh_

#ifdef DEBUG /* Debugging turned on? */

#include <stdio.h>
//#include <iostream>
//#include "Nobel/Geometry.hh"

//#define DPRINT(x) cout << x << endl;

#define DPRINT(x) fprintf(stdout, x); fflush(stdout);
#define DPRINTF(x, y) fprintf(stdout, x, y); fflush(stdout);
#define DUMPMEM(x, y) for (int i = 0; i < y; i++) { \
                          fprintf(stdout, "%.2x", (*(((char*)x)+i) & 0xFF)); } fflush(stdout); 
#define DPRINTVERT(v) fprintf(stdout, "x: %f, y: %f, z: %f\n", v.x, v.y, v.z);

#else /* Debugging off */

#define DPRINT(x)
#define DPRINTF(x, y)
#define DUMPMEM(x, y)
#define DPRINTVERT(v)

#endif

#endif /* debug.hh */
