/* ------------------------------------------------------------------------
 * $Id: EventManager.hh,v 1.4 2001/06/29 15:00:38 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-11-28 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _EventManager_hh_
#define _EventManager_hh_

// -- 3Dwm Includes
#include "Celsius/Runnable.hh"
#include "Zorn/Zorn.hh"

// -- Class Declarations

/**
 * Event managing entity.
 **/
class EventManager : public Runnable {
    
public:

    /**
     * Constructor.
     **/
    EventManager();

    /**
     * Destructor.
     **/
    ~EventManager();

    /**
     * Enter the main event loop. This call will not return (except
     * when the manager is terminated).
     **/
    void run();

    /**
     * Terminate the event manager.
     **/
    void terminate() {
	_quit = true;
    }

    /**
     * Add event mapping functions to the internal Zorn interpreter
     * used for event mapping.
     *
     * @param fobj function object containing event mappers.
     **/
    void addEventMappingFunctions(Zorn::FunctionObject *fobj);

    /**
     * Load event mapping rules from a given rule file to the internal
     * Zorn interpreter used for event mapping.
     * 
     * @param filename name of Zorn rule file.
     **/
    void loadEventMappingRuleFile(const std::string &filename);

private:

    bool _quit;
    Zorn::Interpreter *_interpreter;
};

#endif /* EventManager.hh */
