/* ------------------------------------------------------------------------
 * ImageLoader.hh
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-09-19 by Steve Houston.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _ImageLoader_hh_
#define _ImageLoader_hh_

// -- System Includes
#include <png.h>

// -- 3Dwm includes
#include "Nobel/Image.hh"

// -- Definitions
#define FILE_PNG 1
#define RAW_RGB888 2
#define RAW_RGB565 3

namespace Nobelxx {
    
    class ImageLoader {
	
    public:
	
	/**
	 * Constructor.
	 **/
	ImageLoader();
	
	/**
	 * Destructor.
	 **/
	virtual ~ImageLoader();

	/**
	 * PNG image loading method.
	 * 
	 * @param filename name of PNG file to load.
	 * @return true if successful, false otherwise.
	 **/
	bool loadPNG(const char *filename);
	
	/**
	 * Retrieve the binary data of the image as a Nobel binary
	 * sequence. 
	 *
	 * @return raw binary data as a Nobel binary sequence.
	 **/
	const Nobel::BinaryData &rawData(void);

	/**
	 * Retrieve the width of the image last loaded.
	 *
	 * @return width of the last image loaded.
	 **/
	CORBA::Long width() const { return _width; }

	/**
	 * Retrieve the height of the image last loaded.
	 *
	 * @return height of the last image loaded.
	 **/
	CORBA::Long height() const { return _height; }

	/**
	 * Return the pixel type of the image last loaded.
	 *
	 * @return pixel type of the last image loaded.
	 **/
	Nobel::PixelType pixelType() const { return _pixelType; }

    private:
	// Information on the last image loaded 
	CORBA::Long  _width;       
	CORBA::Long  _height;
	Nobel::PixelType _pixelType;
	int          _bufferSize;
	
	// Pointer to the raw image data
	void         *_imageData; 
	
	// _imageData wrapped up in the BinaryData class
	Nobel::BinaryData   _binData;
    };
    
};

#endif /* ImageLoader.hh */




