/* ------------------------------------------------------------------------
 * $Id: Path.cc,v 1.3 2001/08/20 14:18:29 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-08-15 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- Local Includes
#include "User.hh"
#include "Path.hh"

std::string Path::empty;

// -- Code Segment
Path::Path(const std::string &path, char separator)
{
    std::size_t pos = 0; 
    
    // Step through the entire string
    while (pos < path.length()) {

	// Remove any leading separators
	while (path[pos] == separator && pos < path.length()) pos++;
	if (pos == path.length()) break;

	// Look for the separator in the path
	std::size_t end = path.find_first_of(separator, pos);

	// Create a directory string and add it to the list
	_directories.push_back(std::string(path, pos, end - pos));

	// Move to the next path
	pos = end;
    }
}

std::string Path::expandUser(const std::string &path)
{
    // If no tilde, don't expand at all! 
    if (path[0] != '~') return path;
    
    // Now, look for the first slash
    std::string result;
    std::size_t pos = path.find_first_of('/');
    if (pos == 1 || path.length() == 1) {
	
	// Current user, try for the HOME environment var
	result = getenv("HOME");
	
	// If this variable is not defined, do it the hard way
	if (result.empty()) result = User().getHome();
    }
    else {
	// Lookup the user in the password database
	std::string user(path, 1, (pos == std::string::npos)? pos : pos - 1);
	result = User(user).getHome();
    }
    
    // First the simple cases
    if (result.empty()) return path;
    if (pos == std::string::npos) return result;
    
    // Now build the finished path string
    result += path.substr(pos);

    return result;
}

std::string Path::basename(const std::string &path)
{
    // Use the split function to retrieve the base name
    return split(path).second;
}

std::string Path::dirname(const std::string &path)
{
    // Use the split function to retrieve the directory name
    return split(path).first;
}

std::pair<std::string, std::string> Path::split(const std::string &path)
{
    // Look for the last slash in the path
    std::size_t pos = path.find_last_of('/');

    // Construct the pair to return
    if (pos == std::string::npos)
	return std::pair<std::string, std::string>("", path);
    else
	return std::pair<std::string, std::string>(std::string(path, 0, pos+1),
						   std::string(path, pos+1));
}

/*
std::string Path::normpath(const std::string &path)
{
}
*/
