/* ------------------------------------------------------------------------
 * $Id: FunctionSet.cc,v 1.1 2001/06/19 22:48:01 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-17 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- System Includes
#include "FunctionObject.hh"
#include "StandardLibrary.hh"
#include "FunctionSet.hh"

Zorn::FunctionSet *Zorn::FunctionSet::_instance = 0;

// -- Code Segment

Zorn::FunctionSet::FunctionSet()
{
    // Map in the standard library
    addFunctionObject(new StandardLibrary());
}

Zorn::FunctionSet::~FunctionSet()
{
    // Delete all function objects
    for (std::map<std::string, FunctionObject *>::iterator i =
	     _functions.begin(); i != _functions.end(); i++) {
	
	// Decrease the reference count and deallocate if necessary
	i->second->decrement();
	if (i->second->getRefCount() == 0) delete i->second;
    }
}

void Zorn::FunctionSet::addFunction(const std::string &id,
				    FunctionObject *fobj)
{
    // Register the function in the function map
    _functions[id] = fobj;
    
    // Increase the reference count of the function object
    fobj->increment();
}

void Zorn::FunctionSet::addFunctionObject(FunctionObject *fobj)
{
    // Retrieve the function names
    std::vector<std::string> ids = fobj->getFunctionNames();

    // Traverse through the list of identifiers and map them in
    for (std::vector<std::string>::const_iterator i = ids.begin();
	 i != ids.end(); i++)
	addFunction(*i, fobj);
}

Zorn::FunctionObject *Zorn::FunctionSet::find(const std::string &id) const
{
    // Find the function object in the function map
    std::map<std::string, FunctionObject *>::const_iterator i = 
	_functions.find(id);
    
    // Did we find it?
    if (i != _functions.end()) return i->second;
    else return 0;
}
