#include <stdio.h>
#include <stdlib.h>

int size = 2000000;
unsigned char* isPrime;

void markMultiples(unsigned int n)
{
  unsigned int m;
  for(m=n; m < size; m += n)
#ifdef OPT
    if (!isPrime[m])
#endif
      isPrime[m]=1;
}

int main(int argc, char *argv[])
{
  unsigned int hits=1, i;

  if (argc > 1) size = atol(argv[1]);
  isPrime = malloc(size);
  for (i=0; i<size; i++) isPrime[i] = 0;

  printf ("Searching prime numbers to %d\n", size);
  for(i=2;i<size;i++)
    if (!isPrime[i]) {
      ++hits;
      markMultiples(i);
    }

  printf("Found %d prime numbers\n", hits);
  return 0;
}
