#
#   Copyright (C) 1998, 1999, 2000, 2001 Loic Dachary
#
#   This program is free software; you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the
#   Free Software Foundation; either version 2, or (at your option) any
#   later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
#
# 
# $Header: /cvsroot/catalog/catalog/t/fulltext.pl,v 1.4 2001/07/11 10:28:08 loic Exp $
#

use Cwd;

my($fulltext_conf) = load_config("conf/fulltext.conf");

sub fulltext_prepare {
    my($fulltext) = $fulltext_conf->{'fulltext_type'};

    #
    # Import fulltext configuration
    #
    my($conf) = load_config("conf/$fulltext.conf");
    my($dir) = getcwd() . '/t/tmp';
    system("rm -f $dir/*$fulltext* >&2");
    $conf->{"${fulltext}_dir"} = $dir;
    unload_config($conf, "conf/$fulltext.conf", "t/conf/$fulltext.conf", ":");

    system("perl -pi -e 's/^dmoz/test/' < conf/hook_$fulltext.conf > t/conf/hook_$fulltext.conf");

    #
    # Add appropriate hook in $db.conf
    #
    $conf = load_config("t/conf/db.conf");
    my($db) = $conf->{'db_type'};
    $conf = load_config("t/conf/$db.conf");
    $conf->{'hook'} = "Catalog::tools::hook_$fulltext";
    unload_config($conf, "t/conf/$db.conf");
}

sub fulltext_clean {
    my($fulltext) = $fulltext_conf->{'fulltext_type'};

    my($conf) = load_config("t/conf/$fulltext.conf");
    my($dir) = $conf->{"${fulltext}_dir"};
    system("rm -f $dir/*$fulltext* >&2");

    system("rm t/conf/$fulltext.conf t/conf/hook_$fulltext.conf");
}
