;;; @file kontros.s
;;; Transfer routines for the 8-bit/8-bit C64/C128/Vic-20 to PC cable
;;; designed by Frank Kontros (frank@kontros.uzhgorod.ua)
;;; @author Marko Mkel (msmakela@nic.funet.fi)

	;; additional commands for info mode
#define infoinit
	;; initialize the cable
#if host = 20	; trig falling CB1, CB2=pulse output handshaking
#define initcable lda ack:and #$0f:ora #$a0:sta ack
#endif
#if host = 64 || host = 128 ; set PA2 to input to avoid interference
#define initcable lda #<(255-ackval):and ack+2:sta ack+2
#endif
	;; deinitialize the cable
#define deinitcable
	;; determine whether a request is pending
#define isrequest lda #strval:bit strobe:\
	.(:bne req:sta data:jmp (oldirq):req ldx #0:stx ddr:.)
	;; wait for strobe
#if clearviaifr
#define wait_strobe lda #strval:.(:wait bit strobe:beq wait:.):sta strobe
#else
#define wait_strobe lda #strval:.(:wait bit strobe:beq wait:.)
#endif
	; .A = data, .X and .Y preserved
receive_switch:
	lda #0	; switch back to inputs
	sta ddr
	sta data	; send the handshaking pulse

receive:
#if clearviaifr
rereceive:	; rereceive (without handshake) is only different for the CIA
#endif
	wait_strobe
#if clearviaifr
#else
rereceive:	; rereceive (receive without handshaking) for the CIA
#endif		; clearviaifr
	lda data	; read the byte
#if clearviaifr
	sta data	; acknowledge (the VIA doesn't have read handshaking)
#endif
	rts

	; .A trashed, .Y = 00, .X preserved
send_switch:
		;;; wait for first part of handshake
	tay
	wait_strobe
		;;; and only then switch data direction.
	lda #$ff
	sta ddr	; set the data lines to output
	tya
	ldy #0	; clear .Y

send:
	sta data	; send the data
	wait_strobe
	rts
