;;; @file piabase.s
;;; Definitions for the MC 6821 PIA controlled memory expansion
;;; for the Commodore 64 and 128
;;; @author Marko Mkel (msmakela@nic.funet.fi)

	;; the PIA base address
pia = $d7c0
	;; enable the I/O area
#if host = 128
#define piaioen lda #$3e:sta $ff00
#else
#define piaioen
#endif
	;; initialize the PIA
#define pia_init piaioen:ldx #11:.(:cp lda piatable-1,x:sta pia,x:dex:bne cp:.)

	;; PIA bank selection
#if host = 128	; .A must contain the $d506 contents when calling this routine
#define piabanksel ora #$3f:sta $d506:lda bank:and #$f:lsr:ror:ror:tax:\
	and #$c0:ora #2:sta $d500:txa:ror:ror
#else
#define piabanksel lda bank:asl:asl:asl:asl
#endif
	;; initialization data
#define piadata piatable .byte $34,$fe,4,$ff,0,$ff,0,$dc,4,$fe,4:\
	piainit piabanksel:eor #$c0:and #$c0:ora #$c:sta pia:\
	lda start+1:lsr:lsr:and #$30:ora pia:sta pia

	;; increment and compare pointers and switch banks if necessary
#define pia_incmptr_decl incmptr inc start:.(:bne nosw:inc start+1:bpl nosw:\
	dex:lda #$40:sta start+1:clc:lda #$10:adc pia:sta pia:\
	nosw txa:.):.(:bne ne:\
	lda start:cmp end:bne ne:lda start+1:cmp end+1:ne rts:.)

	;; store or restore the common memory configuration
#if host = 128
#define phmmu lda $d506:pha
#define plmmu pla:sty $d500:sta $d506
#else
#define phmmu
#define plmmu
#endif

	;; load a memory block
#define plain_load lda end+1:pha:lda pia:pha:phmmu:jsr piainit:\
	LDY0R:.(:loop jsr receive:sta (start),y:jsr incmptr:bne loop:.):\
	plmmu:pla:sta pia:pla:sta start+1:sta end+1

	;; save the first byte
#if s_switch
#define SAVE1P lda (start),y:jsr send_switch:jsr incmptr:beq eof
#else
#define SAVE1P
#endif		; send != send_switch

	;; save a memory block
#define plain_save lda pia:pha:phmmu:jsr piainit:\
	LDY0R:.(:SAVE1P:loop lda (start),y:jsr send:jsr incmptr:bne loop:\
	eof plmmu:.):pla:sta pia
